/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.AbstractAdmin;
import org.wso2.utils.MBeanRegistrar;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerManagement;
import org.wso2.wsas.admin.service.ServerAdminMBean;
import org.wso2.wsas.admin.service.util.ServerData;
import org.wso2.wsas.admin.service.util.ServerStatus;
import org.wso2.wsas.util.Controllable;

public class ServerAdmin
extends AbstractAdmin
implements ServerAdminMBean {
    private static final Log log = LogFactory.getLog((Class)ServerAdmin.class);
    private Controllable controllable;

    public ServerData getServerData() throws AxisFault {
        return new ServerData("WSO2 WSAS", this.getAxisConfig().getRepository().toString());
    }

    public String getServerDataAsString() throws Exception {
        try {
            return this.getServerData().toString();
        }
        catch (AxisFault e) {
            String msg = "Cannot get server data";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public String getServerVersion() {
        return ServerConfiguration.getInstance().getFirstProperty("Version");
    }

    public ServerStatus getStatus() throws AxisFault {
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.update(this.getAxisConfig());
        return serverStatus;
    }

    public void restart() {
        ConfigurationContext configurationContext = this.getConfigContext();
        this.controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    ServerAdmin.this.controllable.restart();
                }
                catch (Exception e) {
                    String msg = "Cannot restart server";
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
        };
        th.start();
    }

    public void restartGracefully() {
        ConfigurationContext configurationContext = this.getConfigContext();
        this.controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    ServerAdmin.this.controllable.restartGracefully();
                }
                catch (Exception e) {
                    String msg = "Cannot restart server";
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
        };
        th.start();
    }

    public void shutdown() {
        ConfigurationContext configurationContext = this.getConfigContext();
        this.controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    ServerAdmin.this.controllable.shutdown();
                }
                catch (Exception e) {
                    String msg = "Cannot shutdown server";
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
        };
        th.start();
    }

    public void shutdownGracefully() {
        ConfigurationContext configurationContext = this.getConfigContext();
        this.controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    ServerAdmin.this.controllable.shutdownGracefully();
                }
                catch (Exception e) {
                    String msg = "Cannot gracefully shutdown server";
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
        };
        th.start();
    }

    public void startMaintenance() throws Exception {
        try {
            org.wso2.wsas.ServerStatus.setServerInMaintenance();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to maintenance mode";
            log.error((Object)msg, (Throwable)e);
        }
        HashMap inTransports = this.getAxisConfig().getTransportsIn();
        new ServerManagement((Map)inTransports).startMaintenance();
    }

    public void endMaintenance() throws Exception {
        HashMap inTransports = this.getAxisConfig().getTransportsIn();
        new ServerManagement((Map)inTransports).endMaintenance();
        try {
            org.wso2.wsas.ServerStatus.setServerRunning();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to running mode";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public boolean isAlive() {
        return true;
    }

    public String getServerStatus() throws Exception {
        try {
            return org.wso2.wsas.ServerStatus.getCurrentStatus();
        }
        catch (AxisFault e) {
            String msg = "Could not get current server status";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    static {
        MBeanRegistrar.registerMBean((Object)new ServerAdmin());
    }
}

