/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaReport;
import org.apache.sandesha2.client.SequenceReport;
import org.wso2.utils.AbstractAdmin;
import org.wso2.wsas.admin.service.util.Sandesha2Data;

public class Sandesha2Admin
extends AbstractAdmin {
    public String[] getOutgoingSequences() throws AxisFault {
        SandeshaReport sandeshaReport = this.getSandeshaReport();
        List outgoingSequnces = sandeshaReport.getOutgoingSequenceList();
        return outgoingSequnces.toArray(new String[outgoingSequnces.size()]);
    }

    public Sandesha2Data[] getOutgoingSequenceData() throws AxisFault {
        SandeshaReport sandeshaReport = this.getSandeshaReport();
        List outgoingSequnces = sandeshaReport.getOutgoingSequenceList();
        ArrayList<Sandesha2Data> dataList = new ArrayList<Sandesha2Data>();
        Iterator iterator = outgoingSequnces.iterator();
        while (iterator.hasNext()) {
            String sequenceId = (String)iterator.next();
            Sandesha2Data s2Data = new Sandesha2Data();
            s2Data.setSequenceID(sequenceId);
            s2Data.setFlow(2);
            s2Data.setSequenceReport(this.getOutgoingSequenceDetails(sequenceId));
            dataList.add(s2Data);
        }
        sandeshaReport = this.getSandeshaReport();
        List incomingSequences = sandeshaReport.getIncomingSequenceList();
        Iterator iterator2 = incomingSequences.iterator();
        while (iterator2.hasNext()) {
            String sequenceId = (String)iterator2.next();
            Sandesha2Data s2Data = new Sandesha2Data();
            s2Data.setSequenceID(sequenceId);
            s2Data.setFlow(1);
            s2Data.setSequenceReport(this.getIncomingSequenceDetails(sequenceId));
            dataList.add(s2Data);
        }
        Sandesha2Data[] arr = new Sandesha2Data[dataList.size()];
        for (int i = 0; i < arr.length; ++i) {
            Sandesha2Data data;
            arr[i] = data = (Sandesha2Data)dataList.get(i);
        }
        return arr;
    }

    public String[] getIncomingSequences() throws AxisFault {
        SandeshaReport sandeshaReport = this.getSandeshaReport();
        List incomingSequences = sandeshaReport.getOutgoingSequenceList();
        return incomingSequences.toArray(new String[incomingSequences.size()]);
    }

    public SequenceReport getIncomingSequenceDetails(String sequenceID) throws AxisFault {
        ConfigurationContext configurationContext = this.getConfigContext();
        if (configurationContext == null) {
            throw new AxisFault("Cannot proceed. ConfigurationContext is not set");
        }
        SequenceReport incomingSequenceReport = SandeshaClient.getIncomingSequenceReport((String)sequenceID, (ConfigurationContext)configurationContext);
        return incomingSequenceReport;
    }

    public SequenceReport getOutgoingSequenceDetails(String sequenceID) throws AxisFault {
        ConfigurationContext configurationContext = this.getConfigContext();
        if (configurationContext == null) {
            throw new AxisFault("Cannot proceed. ConfigurationContext is not set");
        }
        SequenceReport outgoingSequenceReport = SandeshaClient.getOutgoingSequenceReport((String)sequenceID, (ConfigurationContext)configurationContext);
        return outgoingSequenceReport;
    }

    private SandeshaReport getSandeshaReport() throws AxisFault {
        ConfigurationContext configurationContext = this.getConfigContext();
        if (configurationContext == null) {
            throw new AxisFault("Cannot proceed. ConfigurationContext is not set");
        }
        SandeshaReport sandeshaReport = SandeshaClient.getSandeshaReport((ConfigurationContext)configurationContext);
        if (sandeshaReport == null) {
            throw new AxisFault("Could not find a valid SandeshaReport");
        }
        return sandeshaReport;
    }
}

