/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.admin.service.ServiceAdmin;
import org.wso2.wsas.admin.service.ServiceGroupAdmin;
import org.wso2.wsas.admin.service.util.ServiceGroupMetaData;
import org.wso2.wsas.admin.service.util.ServiceMetaData;

public class GeneralServices {
    private static final String ATTACHMENT_ELE = "attachment";
    private static final String TYPE_ELE = "type";
    private static final String[] EXTENSIONS = new String[]{".aar", ".mar", ".jar", ".xml"};
    private static Log log = LogFactory.getLog((Class)GeneralServices.class);

    public ServiceGroupMetaData[] listServiceGroups() throws AxisFault {
        ServiceGroupAdmin sga = new ServiceGroupAdmin();
        ArrayList<ServiceGroupMetaData> list = new ArrayList<ServiceGroupMetaData>();
        ServiceGroupMetaData[] serviceGroupMetaData = sga.listServiceGroups();
        for (int i = 0; i < serviceGroupMetaData.length; ++i) {
            ServiceGroupMetaData sgmd = serviceGroupMetaData[i];
            if (sgmd.getGroup_name().equals("TryItMockServiceGroup")) continue;
            list.add(sgmd);
        }
        return list.toArray(new ServiceGroupMetaData[list.size()]);
    }

    public ServiceMetaData getServiceData(String serviceName) throws AxisFault {
        ServiceAdmin sa = new ServiceAdmin();
        return sa.getServiceData(serviceName);
    }

    private ConfigurationContext getConfigurationContext() {
        return MessageContext.getCurrentMessageContext().getConfigurationContext();
    }

    private AxisConfiguration getAxisConfiguration() {
        return this.getConfigurationContext().getAxisConfiguration();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String upload(OMElement payload) throws AxisFault {
        OMElement attachmentEle = payload.getFirstChildWithName(new QName(ATTACHMENT_ELE));
        if (attachmentEle == null) {
            String msg = "Attachment element is not available";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        OMNode child = attachmentEle.getFirstOMChild();
        if (child != null && child.getType() == 4) {
            OMText attachment = (OMText)child;
            DataHandler dh = (DataHandler)attachment.getDataHandler();
            OMElement typeEle = payload.getFirstChildWithName(new QName(TYPE_ELE));
            if (typeEle == null) {
                String msg = "Type element is not available";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            String value = typeEle.getText();
            if (value == null) {
                String msg = "Type text is not available";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            String uuid = this.write(dh, value);
            if (uuid != null) return uuid;
            String msg = "UUID is not available";
            log.error((Object)msg);
            throw new AxisFault(msg);
        } else {
            String msg = "Attachment is not be computed.";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
    }

    private String write(DataHandler dh, String type) throws AxisFault {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        String tmpDir = (String)configCtx.getProperty("WORK_DIR");
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        tmpDir = tmpDir + File.separator + "attachments" + File.separator + uuid + File.separator;
        new File(tmpDir).mkdirs();
        if (!type.startsWith(".")) {
            type = ".".concat(type);
        }
        File outFile = new File(tmpDir, uuid + type);
        try {
            FileOutputStream outStream = new FileOutputStream(outFile);
            dh.writeTo((OutputStream)outStream);
            outStream.flush();
            Map fileResourceMap = (Map)configCtx.getProperty("file.resource.map");
            if (fileResourceMap == null) {
                fileResourceMap = new TreeBidiMap();
                configCtx.setProperty("file.resource.map", (Object)fileResourceMap);
            }
            fileResourceMap.put(uuid, outFile.getAbsolutePath());
            return uuid;
        }
        catch (FileNotFoundException e) {
            String msg = "FileNotFoundException exception";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            String msg = "FileNotFoundException exception";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

