/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.AbstractAdmin;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.admin.service.util.DBServerData;
import org.wso2.wsas.admin.service.util.DataServiceInfo;
import org.wso2.wsas.util.WsasUtils;

public class DataServiceAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog((Class)DataServiceAdmin.class);

    public DataServiceInfo getDSMetaData(String init) throws AxisFault {
        if (init == null || init.length() == 0) {
            String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
            if (WsasUtils.isURL((String)axis2Repo)) {
                throw new AxisFault("WSAS is running from a URL repository " + axis2Repo + ". Cannot create Data Services for URL repositories");
            }
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMElement dwEle = fac.createOMElement(new QName(null, "dataWrapper"));
            OMElement dataEle = fac.createOMElement(new QName(null, "data"));
            OMElement configEle = fac.createOMElement(new QName(null, "config"));
            dataEle.addChild((OMNode)configEle);
            dwEle.addChild((OMNode)dataEle);
            DataServiceInfo dataServiceInfo = new DataServiceInfo();
            dataServiceInfo.setDataWrapper(dwEle);
            dataServiceInfo.setDbServerData(this.getDatabaseUrlDriverList());
            return dataServiceInfo;
        }
        DataServiceInfo dataServiceInfo = new DataServiceInfo();
        OMElement dataEle = this.getDataServiceContents(init);
        dataEle.build();
        dataEle.detach();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement dwEle = fac.createOMElement(new QName(null, "dataWrapper"));
        dwEle.addChild((OMNode)dataEle);
        dataServiceInfo.setDataWrapper(dwEle);
        dataServiceInfo.setDbServerData(this.getDatabaseUrlDriverList());
        return dataServiceInfo;
    }

    public OMElement getDataServiceContents(String serviceId) throws AxisFault {
        OMElement returnEle;
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        String fileParth = (String)axisService.getParameter("org.wso2.ws.dataservice.db_service_config_file").getValue();
        StringBuffer fileContents = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(fileParth));
            while ((str = in.readLine()) != null) {
                fileContents.append(str);
            }
            in.close();
        }
        catch (IOException e) {
            throw new AxisFault("Error while reading the contents from the service config file for service " + serviceId, (Throwable)e);
        }
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(fileContents.toString().getBytes()));
            returnEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            throw new AxisFault("Error while converting the contents of the configuration file into and OMElement for service " + serviceId, (Throwable)e);
        }
        return returnEle;
    }

    public void saveDataServiceContents(OMElement dataWrapper) throws AxisFault {
        String dataServiceFilePath;
        OMElement configEle = dataWrapper.getFirstChildWithName(new QName("data"));
        if (configEle == null) {
            throw new AxisFault("Data Service configuration start element <data/> is not found");
        }
        OMAttribute attribute = configEle.getAttribute(new QName("name"));
        String serviceId = attribute.getAttributeValue();
        if (serviceId == null) {
            throw new AxisFault("Data Service configuration cannot be continued due to missing Data Service name");
        }
        Iterator queries = configEle.getChildrenWithName(new QName("query"));
        while (queries.hasNext()) {
            String attValue;
            OMElement query = (OMElement)queries.next();
            Iterator results = query.getChildrenWithName(new QName("result"));
            while (results.hasNext()) {
                OMElement result = (OMElement)results.next();
                OMAttribute rowNameAttribute = result.getAttribute(new QName("rowname"));
                if (rowNameAttribute == null) continue;
                attValue = rowNameAttribute.getAttributeValue();
                result.removeAttribute(rowNameAttribute);
                result.addAttribute(OMAbstractFactory.getOMFactory().createOMAttribute("rowName", OMAbstractFactory.getOMFactory().createOMNamespace("", ""), attValue));
            }
            Iterator params = query.getChildrenWithName(new QName("param"));
            while (params.hasNext()) {
                OMElement param = (OMElement)params.next();
                OMAttribute sqlTypeAttribute = param.getAttribute(new QName("sqltype"));
                if (sqlTypeAttribute == null) continue;
                attValue = sqlTypeAttribute.getAttributeValue();
                param.removeAttribute(sqlTypeAttribute);
                param.addAttribute(OMAbstractFactory.getOMFactory().createOMAttribute("sqlType", OMAbstractFactory.getOMFactory().createOMNamespace("", ""), attValue));
            }
        }
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            String axis2RepoDirectory = this.getAxisConfig().getRepository().getPath();
            ConfigurationContext configCtx = this.getConfigContext();
            String repoDirectory = (String)configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_repo");
            String fileExtension = (String)configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_extension");
            String dataServiceDirectory = axis2RepoDirectory + File.separator + repoDirectory;
            dataServiceFilePath = dataServiceDirectory + File.separator + serviceId + "." + fileExtension;
            File directory = new File(dataServiceDirectory);
            directory.mkdirs();
            File file = new File(dataServiceFilePath);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new AxisFault("Error while creating the file for the new service config file for the new service " + serviceId, (Throwable)e);
            }
        } else {
            dataServiceFilePath = (String)axisService.getParameter("org.wso2.ws.dataservice.db_service_config_file").getValue();
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dataServiceFilePath));
            configEle.serialize((Writer)out);
            out.close();
        }
        catch (IOException e) {
            throw new AxisFault("Error while writing the contents for the service config file for the new service " + serviceId, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault("Error while serializing the config OMElement for the service " + serviceId, (Throwable)e);
        }
    }

    public DBServerData[] getDatabaseUrlDriverList() {
        ArrayList<DBServerData> databaseServers = new ArrayList<DBServerData>();
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        OMElement documentElement = serverConfiguration.getDocumentElement();
        OMElement databaseServersElement = documentElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "DatabaseServers"));
        Iterator serverElementIterator = databaseServersElement.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Server"));
        while (serverElementIterator.hasNext()) {
            OMElement serverElement = (OMElement)serverElementIterator.next();
            OMElement serverIdElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "Id"));
            OMElement jdbcUrlElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "JdbcURL"));
            OMElement driverClassElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "DriverClass"));
            DBServerData databaseServerData = new DBServerData();
            databaseServerData.setServerId(serverIdElement.getText());
            String text = jdbcUrlElement.getText();
            databaseServerData.setJdbcUrl(text);
            databaseServerData.setDriverClass(driverClassElement.getText());
            int index = text.indexOf("jdbc:");
            if (index > -1) {
                String tmp1 = text.substring(index + 5);
                index = tmp1.indexOf(":");
                String protocol = tmp1.substring(0, index);
                databaseServerData.setProtocol(protocol);
            } else {
                databaseServerData.setProtocol("generic");
            }
            databaseServers.add(databaseServerData);
        }
        DBServerData[] databaseServerList = new DBServerData[databaseServers.size()];
        databaseServers.toArray(databaseServerList);
        return databaseServerList;
    }

    public String[] getHeaderColumnNames(String resourcePath, String hasHeaders, String dataSourceType) {
        log.debug((Object)("getHeaderColumnNames() called with params :" + resourcePath + " : " + hasHeaders + " : " + dataSourceType));
        CSVReader reader = null;
        String[] columnHeader = null;
        if ("csv".equals(dataSourceType)) {
            InputStreamReader inputStreamReader = null;
            try {
                if (resourcePath.startsWith("http://")) {
                    URL url = new URL(resourcePath);
                    inputStreamReader = new InputStreamReader(url.openStream());
                    reader = new CSVReader((Reader)inputStreamReader);
                } else {
                    reader = new CSVReader((Reader)new FileReader(resourcePath));
                }
                if (reader != null) {
                    String[] firstLine = reader.readNext();
                    if (Boolean.valueOf(hasHeaders).booleanValue()) {
                        columnHeader = firstLine;
                    } else {
                        columnHeader = new String[firstLine.length];
                        for (int a = 0; a < firstLine.length; ++a) {
                            columnHeader[a] = String.valueOf(a + 1);
                        }
                    }
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)("Incorrect " + dataSourceType + " URL : " + resourcePath), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error reading file : " + resourcePath), (Throwable)e);
                e.printStackTrace();
            }
        }
        return columnHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testJDBCConnection(String driverClass, String jdbcURL, String username, String password) {
        if (driverClass == null || driverClass.length() == 0) {
            String message = "Driver class is missing";
            log.debug((Object)message);
            return message;
        }
        if (jdbcURL == null || jdbcURL.length() == 0) {
            String message = "Driver connection URL is missing";
            log.debug((Object)message);
            return message;
        }
        Connection connection = null;
        try {
            Class.forName(driverClass.trim());
            connection = DriverManager.getConnection(jdbcURL, username, password);
            String message = "Database connection is successfull with driver class" + driverClass + " , jdbc url " + jdbcURL + " and user name " + username;
            log.debug((Object)message);
            String string = message;
            return string;
        }
        catch (SQLException e) {
            String message = "Could not connect to database " + jdbcURL + " with username " + username;
            log.debug((Object)message, (Throwable)e);
            String string = message;
            return string;
        }
        catch (ClassNotFoundException e) {
            String message = "Drive class " + driverClass + " can not be loaded";
            log.debug((Object)message);
            String string = message;
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }
}

