/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.module.admin.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog((Class)AuthenticationHandler.class);
    private MessageContext msgContext;

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        this.msgContext = messageContext;
        this.authenticate((String)messageContext.getProperty("REMOTE_ADDR"));
        return Handler.InvocationResponse.CONTINUE;
    }

    protected void authenticate(String remoteIP) throws AxisFault {
        if (this.callToGeneralService()) {
            return;
        }
        if (!this.isAuthenticated(remoteIP)) {
            throw new AxisFault("Access Denied. Please login first.");
        }
    }

    private boolean isAuthenticated(String remoteIP) {
        OperationContext opCtx = this.msgContext.getOperationContext();
        ServiceContext serviceCtx = opCtx.getServiceContext();
        String opName = opCtx.getAxisOperation().getName().getLocalPart();
        String serviceName = serviceCtx.getAxisService().getName();
        if ((serviceName.equals("GlobalAdmin") || serviceName.equals("Axis2NodeManager")) && (opName.equals("login") || opName.equals("logout"))) {
            return true;
        }
        String loginStatus = (String)serviceCtx.getServiceGroupContext().getPropertyNonReplicable("wso2wsas.admin.logged.in");
        boolean authenticated = "true".equals(loginStatus);
        if (!authenticated) {
            SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
            log.warn((Object)("Illegal access attempt at " + date.format(new Date()) + " from IP address " + remoteIP));
        }
        return authenticated;
    }

    private boolean callToGeneralService() {
        String serviceName = this.msgContext.getAxisService().getName();
        return serviceName.equals("GeneralServices");
    }
}

