/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xfer;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.xfer.WSTransferFactory;
import org.wso2.xfer.WSTransferMessageReceiver;
import org.wso2.xfer.WSTransferOperations;

public class WSTransferModule
implements Module {
    private static final Log LOG = LogFactory.getLog((String)WSTransferModule.class.getClass().getName());
    private static final String ATTR_SERVICE_CLASS = "ServiceClass";
    private static final String OP_NAME_PUT = "put";
    private static final String OP_NAME_GET = "get";
    private static final String OP_NAME_CREATE = "create";
    private static final String OP_NAME_DELETE = "delete";

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        if (axisDescription instanceof AxisService) {
            try {
                AxisService axisService = (AxisService)axisDescription;
                String implClassName = (String)axisService.getParameterValue(ATTR_SERVICE_CLASS);
                if (implClassName == null || (implClassName = implClassName.trim()).length() == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WSTransferModule is not to engaged to service " + axisService.getName() + " because it doesn't contain an implementation class."));
                    }
                    return;
                }
                ClassLoader classLoader = axisService.getClassLoader();
                Class<?> implClass = classLoader.loadClass(implClassName);
                this.processAxisService(axisService, implClass);
            }
            catch (Exception ex) {
                throw AxisFault.makeFault((Throwable)ex);
            }
        }
    }

    private void processAxisService(AxisService axisService, Class implClass) throws Exception {
        AxisOperation transferOperation;
        WSTransferMessageReceiver transferMessageReceiver = new WSTransferMessageReceiver();
        if (WSTransferOperations.class.isAssignableFrom(implClass)) {
            transferMessageReceiver = new WSTransferMessageReceiver();
            transferOperation = axisService.getOperation(new QName(OP_NAME_GET));
            if (transferOperation != null) {
                this.setSoapAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get", transferOperation);
                transferOperation.setOutputAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse");
                transferOperation.setMessageReceiver((MessageReceiver)transferMessageReceiver);
            }
            if ((transferOperation = axisService.getOperation(new QName(OP_NAME_PUT))) != null) {
                this.setSoapAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/Put", transferOperation);
                transferOperation.setOutputAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/PutResponse");
                transferOperation.setMessageReceiver((MessageReceiver)transferMessageReceiver);
            }
            if ((transferOperation = axisService.getOperation(new QName(OP_NAME_DELETE))) != null) {
                this.setSoapAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/Delete", transferOperation);
                transferOperation.setOutputAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/DeleteResponse");
                transferOperation.setMessageReceiver((MessageReceiver)transferMessageReceiver);
            }
        }
        if (WSTransferFactory.class.isAssignableFrom(implClass) && (transferOperation = axisService.getOperation(new QName(OP_NAME_CREATE))) != null) {
            this.setSoapAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/Create", transferOperation);
            transferOperation.setOutputAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/CreateResponse");
            transferOperation.setMessageReceiver((MessageReceiver)transferMessageReceiver);
        }
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }

    private void setSoapAction(String soapAction, AxisOperation op) {
        AxisService service = (AxisService)op.getParent();
        String oldSoapAction = op.getInputAction();
        if (oldSoapAction != null) {
            service.mapActionToOperation(oldSoapAction, null);
        }
        op.setSoapAction(soapAction);
        service.mapActionToOperation(soapAction, op);
    }
}

