/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xfer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.wso2.xfer.WSTransferException;
import org.wso2.xfer.WSTransferUtil;

public class WSTransferMessageReceiver
extends AbstractInOutMessageReceiver {
    private static final String ATTR_SERVICE_CLASS = "ServiceClass";
    private static final String OP_NAME_PUT = "put";
    private static final String OP_NAME_GET = "get";
    private static final String OP_NAME_CREATE = "create";
    private static final String OP_NAME_DELETE = "delete";

    public void invokeBusinessLogic(MessageContext inMessageContext, MessageContext outMessageContext) throws AxisFault {
        block10: {
            Object serviceImplObject = this.getTheImplementationObject(inMessageContext);
            Class<?> serviceImplClass = serviceImplObject.getClass();
            AxisService axisService = inMessageContext.getAxisService();
            AxisOperation axisOperation = inMessageContext.getAxisOperation();
            String methodName = axisOperation.getName().getLocalPart();
            Method method = null;
            try {
                SOAPEnvelope envelope = inMessageContext.getEnvelope();
                SOAPEnvelope outSoapEnvelope = this.getSoapEnvelop(inMessageContext);
                outMessageContext.setEnvelope(outSoapEnvelope);
                if (OP_NAME_PUT.equals(methodName)) {
                    OMElement resultElement;
                    SOAPHeader headers = envelope.getHeader();
                    method = serviceImplClass.getDeclaredMethod(methodName, OMElement.class, OMElement.class);
                    SOAPBody body = envelope.getBody();
                    OMElement firstChild = body.getFirstElement();
                    if (firstChild == null) {
                        WSTransferUtil.triggerInvalidRepresentationFault(inMessageContext, "http://schemas.xmlsoap.org/ws/2005/06/management/faultDetail/MissingValues");
                    }
                    if ((resultElement = (OMElement)method.invoke(serviceImplObject, headers, firstChild)) != null) {
                        resultElement.declareNamespace(axisService.getTargetNamespace(), axisService.getTargetNamespacePrefix());
                        outSoapEnvelope.getBody().addChild((OMNode)resultElement);
                    }
                    break block10;
                }
                if (OP_NAME_GET.equals(methodName)) {
                    SOAPHeader headers = envelope.getHeader();
                    method = serviceImplClass.getDeclaredMethod(methodName, OMElement.class);
                    OMElement resultElement = (OMElement)method.invoke(serviceImplObject, headers);
                    if (resultElement == null) {
                        WSTransferUtil.triggerInvalidMessageInfoHeaderFault(inMessageContext, "MessageID");
                    }
                    resultElement.declareNamespace(axisService.getTargetNamespace(), axisService.getTargetNamespacePrefix());
                    outSoapEnvelope.getBody().addChild((OMNode)resultElement);
                    break block10;
                }
                if (OP_NAME_DELETE.equals(methodName)) {
                    SOAPHeader headers = envelope.getHeader();
                    method = serviceImplClass.getDeclaredMethod(methodName, String.class);
                    method.invoke(serviceImplObject, headers);
                    break block10;
                }
                if (OP_NAME_CREATE.equals(methodName)) {
                    method = serviceImplClass.getDeclaredMethod(methodName, OMElement.class);
                    SOAPBody body = envelope.getBody();
                    OMElement firstChild = body.getFirstElement();
                    if (firstChild == null) {
                        WSTransferUtil.triggerInvalidRepresentationFault(inMessageContext, "http://schemas.xmlsoap.org/ws/2005/06/management/faultDetail/MissingValues");
                    }
                    EndpointReference endpointReference = (EndpointReference)method.invoke(serviceImplObject, firstChild);
                    OMFactory factory = outSoapEnvelope.getOMFactory();
                    QName qname = new QName("http://schemas.xmlsoap.org/ws/2004/08/transfer", "ResourceCreated");
                    OMElement resultElement = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)endpointReference, (QName)qname, (String)"http://www.w3.org/2005/08/addressing");
                    outSoapEnvelope.getBody().addChild((OMNode)resultElement);
                    break block10;
                }
                throw new AxisFault("should nerver reach this bock");
            }
            catch (Exception ex) {
                this.handleError(inMessageContext, ex);
            }
        }
    }

    private void handleError(MessageContext messageContext, Exception ex) throws AxisFault {
        Throwable throwable;
        if (ex instanceof AxisFault) {
            throw (AxisFault)ex;
        }
        if (ex instanceof InvocationTargetException && (throwable = ex.getCause()) instanceof WSTransferException) {
            WSTransferUtil.triggerAxisFault(messageContext, (WSTransferException)throwable);
        }
        throw AxisFault.makeFault((Throwable)ex);
    }

    private SOAPEnvelope getSoapEnvelop(MessageContext inMessageContext) throws AxisFault {
        SOAPFactory soapFactory = this.getSOAPFactory(inMessageContext);
        return soapFactory.getDefaultEnvelope();
    }
}

