/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.FaultCode;
import org.apache.sandesha2.wsrm.IOMRMPart;

public class SequenceFault
implements IOMRMPart {
    private FaultCode faultCode;
    private String namespaceValue = null;

    public SequenceFault(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement sequenceFaultPart) throws OMException, SandeshaException {
        if (sequenceFaultPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noSeqFaultInElement", null));
        }
        OMElement faultCodePart = sequenceFaultPart.getFirstChildWithName(new QName(this.namespaceValue, "FaultCode"));
        if (faultCodePart != null) {
            this.faultCode = new FaultCode(this.namespaceValue);
            this.faultCode.fromOMElement(sequenceFaultPart);
        }
        ((SOAPHeaderBlock)sequenceFaultPart).setProcessed();
        return this;
    }

    public OMElement toOMElement(OMElement header) throws OMException {
        if (header == null || !(header instanceof SOAPHeader)) {
            throw new OMException(SandeshaMessageHelper.getMessage("seqFaultCannotBeExtractedToNonHeader"));
        }
        OMFactory factory = header.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement sequenceFaultElement = factory.createOMElement("SequenceFault", rmNamespace);
        if (this.faultCode != null) {
            this.faultCode.toOMElement(sequenceFaultElement);
        }
        header.addChild((OMNode)sequenceFaultElement);
        return header;
    }

    public void setFaultCode(FaultCode faultCode) {
        this.faultCode = faultCode;
    }

    public FaultCode getFaultCode() {
        return this.faultCode;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPHeader header = envelope.getHeader();
        OMElement elem = header.getFirstChildWithName(new QName(this.namespaceValue, "SequenceFault"));
        if (elem != null) {
            elem.detach();
        }
        this.toOMElement((OMElement)header);
    }
}

