/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;

public class MessagePending
implements IOMRMPart {
    boolean pending = false;
    String namespaceValue = null;

    public MessagePending(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        OMElement elem;
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
            header = factory.createSOAPHeader(envelope);
        }
        if ((elem = header.getFirstChildWithName(new QName(this.namespaceValue, "MessagePending"))) != null) {
            elem.detach();
        }
        this.toOMElement((OMElement)header);
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement messagePendingElement) throws OMException, SandeshaException {
        OMAttribute pendingAttr = messagePendingElement.getAttribute(new QName("pending"));
        if (pendingAttr == null) {
            String message = "MessagePending header must have an attribute named 'pending'";
            throw new SandeshaException(message);
        }
        String value = pendingAttr.getAttributeValue();
        if ("true".equals(value)) {
            this.pending = true;
        } else if ("false".equals(value)) {
            this.pending = false;
        } else {
            String message = "Attribute 'pending' must have value 'true' or 'false'";
            throw new SandeshaException(message);
        }
        ((SOAPHeaderBlock)messagePendingElement).setProcessed();
        return messagePendingElement;
    }

    public OMElement toOMElement(OMElement headerElement) throws OMException {
        if (!(headerElement instanceof SOAPHeader)) {
            String message = "'MessagePending' element can only be added to a SOAP Header";
            throw new OMException(message);
        }
        SOAPHeader header = (SOAPHeader)headerElement;
        OMFactory factory = header.getOMFactory();
        OMNamespace namespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        SOAPHeaderBlock headerBlock = header.addHeaderBlock("MessagePending", namespace);
        OMAttribute attribute = factory.createOMAttribute("pending", null, new Boolean(this.pending).toString());
        headerBlock.addAttribute(attribute);
        return headerElement;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(namespaceName);
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }
}

