/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.FaultData;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SOAPFaultEnvelopeCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.SequenceFault;

public class FaultManager {
    private static final Log log = LogFactory.getLog((Class)FaultManager.class);

    public static void checkForLastMsgNumberExceeded(RMMsgContext applicationRMMessage, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: FaultManager::checkForLastMsgNumberExceeded");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForLastMsgNumberExceeded");
        }
    }

    public static RMMsgContext checkForMessageNumberRoleover(MessageContext messageContext) {
        return null;
    }

    public static boolean checkForUnknownSequence(RMMsgContext rmMessageContext, String sequenceID, StorageManager storageManager, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: FaultManager::checkForUnknownSequence, " + sequenceID));
        }
        boolean validSequence = false;
        if (SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID) != null) {
            validSequence = true;
        } else if (SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID) != null) {
            validSequence = true;
        }
        if (!validSequence) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sequence not valid " + sequenceID));
            }
            MessageContext messageContext = rmMessageContext.getMessageContext();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(messageContext.getEnvelope());
            FaultData data = new FaultData();
            if (SOAPVersion2 == 1) {
                data.setCode("Client");
            } else {
                data.setCode("Sender");
            }
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMessageContext.getRMNamespaceValue(), 1));
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            OMElement identifierElement = factory.createOMElement("Identifier", rmMessageContext.getRMNamespaceValue(), "wsrm");
            identifierElement.setText(sequenceID);
            data.setDetail(identifierElement);
            data.setReason(SandeshaMessageHelper.getMessage("unknownSequenceFault", sequenceID));
            data.setType(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: FaultManager::checkForUnknownSequence, Sequence unknown");
            }
            boolean faultThrowable = !piggybackedMessage;
            FaultManager.getOrSendFault(rmMessageContext, data, faultThrowable);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForUnknownSequence");
        }
        return false;
    }

    public static boolean checkForInvalidAcknowledgement(RMMsgContext ackRMMessageContext, SequenceAcknowledgement sequenceAcknowledgement, StorageManager storageManager, RMSBean rmsBean, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: FaultManager::checkForInvalidAcknowledgement");
        }
        if (ackRMMessageContext.getMessageType() != 4 && log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForInvalidAcknowledgement, MessageType not an ACK");
        }
        boolean invalidAck = false;
        List sequenceAckList = sequenceAcknowledgement.getAcknowledgementRanges();
        Iterator it = sequenceAckList.iterator();
        while (it.hasNext()) {
            AcknowledgementRange acknowledgementRange = (AcknowledgementRange)it.next();
            long upper = acknowledgementRange.getUpperValue();
            long lower = acknowledgementRange.getLowerValue();
            if (lower > upper) {
                invalidAck = true;
            } else if (upper > rmsBean.getHighestOutMessageNumber()) {
                invalidAck = true;
            }
            if (!invalidAck) continue;
            FaultManager.makeInvalidAcknowledgementFault(ackRMMessageContext, sequenceAcknowledgement, acknowledgementRange, storageManager, piggybackedMessage);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForInvalidAcknowledgement");
        }
        return false;
    }

    public static void makeInvalidAcknowledgementFault(RMMsgContext rmMsgCtx, SequenceAcknowledgement sequenceAcknowledgement, AcknowledgementRange acknowledgementRange, StorageManager storageManager, boolean piggybackedMessage) throws AxisFault {
        FaultData data = new FaultData();
        int SOAPVersion2 = SandeshaUtil.getSOAPVersion(rmMsgCtx.getMessageContext().getEnvelope());
        if (SOAPVersion2 == 1) {
            data.setCode("Client");
        } else {
            data.setCode("Sender");
        }
        data.setType(3);
        data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMsgCtx.getRMNamespaceValue(), 3));
        data.setReason(SandeshaMessageHelper.getMessage("invalidAckFault"));
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
        OMElement seqAckElement = factory.createOMElement("SequenceAcknowledgement", rmMsgCtx.getRMNamespaceValue(), "wsrm");
        sequenceAcknowledgement.getIdentifier().toOMElement(seqAckElement);
        acknowledgementRange.toOMElement(seqAckElement);
        data.setDetail(seqAckElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForInvalidAcknowledgement, invalid ACK");
        }
        boolean throwable = !piggybackedMessage;
        FaultManager.getOrSendFault(rmMsgCtx, data, throwable);
    }

    public static void makeCreateSequenceRefusedFault(RMMsgContext rmMessageContext, String detail, Exception e) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: FaultManager::makeCreateSequenceRefusedFault, " + detail));
        }
        MessageContext messageContext = rmMessageContext.getMessageContext();
        int SOAPVersion2 = SandeshaUtil.getSOAPVersion(messageContext.getEnvelope());
        FaultData data = new FaultData();
        if (SOAPVersion2 == 1) {
            data.setCode("Client");
        } else {
            data.setCode("Sender");
        }
        data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMessageContext.getRMNamespaceValue(), 4));
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
        OMElement identifierElement = factory.createOMElement("Identifier", rmMessageContext.getRMNamespaceValue(), "wsrm");
        identifierElement.setText(detail);
        data.setDetail(identifierElement);
        data.setDetailString(detail);
        data.setReason(SandeshaMessageHelper.getMessage("createSequenceRefused"));
        data.setType(4);
        data.setExceptionString(SandeshaUtil.getStackTraceFromException(e));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::makeCreateSequenceRefusedFault");
        }
        FaultManager.getOrSendFault(rmMessageContext, data, true);
    }

    public static boolean checkForSequenceTerminated(RMMsgContext referenceRMMessage, String sequenceID, RMSequenceBean bean, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: FaultManager::checkForSequenceTerminated, " + sequenceID));
        }
        if (bean.isTerminated()) {
            MessageContext referenceMessage = referenceRMMessage.getMessageContext();
            FaultData data = new FaultData();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(referenceMessage.getEnvelope());
            if (SOAPVersion2 == 1) {
                data.setCode("Client");
            } else {
                data.setCode("Sender");
            }
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(referenceRMMessage.getRMNamespaceValue(), 7));
            data.setReason(SandeshaMessageHelper.getMessage("sequenceTerminatedFault", sequenceID));
            data.setType(7);
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            String rmNamespaceValue = referenceRMMessage.getRMNamespaceValue();
            OMElement identifierElement = factory.createOMElement("Identifier", rmNamespaceValue, "wsrm");
            identifierElement.setText(sequenceID);
            data.setDetail(identifierElement);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: FaultManager::checkForSequenceTerminated, sequence terminated");
            }
            boolean throwable = !piggybackedMessage;
            FaultManager.getOrSendFault(referenceRMMessage, data, throwable);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForSequenceTerminated");
        }
        return false;
    }

    public static boolean checkForSequenceClosed(RMMsgContext referenceRMMessage, String sequenceID, RMDBean rmdBean, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: FaultManager::checkForSequenceClosed, " + sequenceID));
        }
        if (rmdBean.isClosed()) {
            MessageContext referenceMessage = referenceRMMessage.getMessageContext();
            FaultData data = new FaultData();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(referenceMessage.getEnvelope());
            if (SOAPVersion2 == 1) {
                data.setCode("Client");
            } else {
                data.setCode("Sender");
            }
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(referenceRMMessage.getRMNamespaceValue(), 6));
            data.setReason(SandeshaMessageHelper.getMessage("cannotAcceptMsgAsSequenceClosedFault"));
            data.setType(6);
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            String rmNamespaceValue = referenceRMMessage.getRMNamespaceValue();
            OMElement identifierElement = factory.createOMElement("Identifier", rmNamespaceValue, "wsrm");
            identifierElement.setText(sequenceID);
            data.setDetail(identifierElement);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: FaultManager::checkForSequenceClosed, sequence closed");
            }
            boolean throwable = !piggybackedMessage;
            FaultManager.getOrSendFault(referenceRMMessage, data, throwable);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::checkForSequenceClosed");
        }
        return false;
    }

    public static void getOrSendFault(RMMsgContext referenceRMMsgContext, FaultData data, boolean throwable) throws AxisFault {
        SOAPFactory factory = (SOAPFactory)referenceRMMsgContext.getSOAPEnvelope().getOMFactory();
        SOAPFaultCode faultCode = factory.createSOAPFaultCode();
        SOAPFaultSubCode faultSubCode = factory.createSOAPFaultSubCode(faultCode);
        SOAPFaultValue faultColdValue = factory.createSOAPFaultValue(faultCode);
        SOAPFaultValue faultSubcodeValue = factory.createSOAPFaultValue(faultSubCode);
        faultColdValue.setText(data.getCode());
        faultSubcodeValue.setText(data.getSubcode());
        faultCode.setSubCode(faultSubCode);
        SOAPFaultReason reason = factory.createSOAPFaultReason();
        SOAPFaultText reasonText = factory.createSOAPFaultText();
        reasonText.setText(data.getReason());
        SOAPFaultDetail detail = factory.createSOAPFaultDetail();
        detail.addDetailEntry(data.getDetail());
        String SOAPNamespaceValue = factory.getSoapVersionURI();
        if (!"http://www.w3.org/2003/05/soap-envelope".equals(SOAPNamespaceValue)) {
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(SOAPNamespaceValue)) {
                reason.setText(data.getReason());
                referenceRMMsgContext.setProperty("faultcode", faultCode);
                referenceRMMsgContext.setProperty("detail", detail);
                referenceRMMsgContext.setProperty("faultstring", reason);
                MessageContext faultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)referenceRMMsgContext.getMessageContext(), null);
                SOAPFaultEnvelopeCreator.addSOAPFaultEnvelope(faultMessageContext, 1, data, referenceRMMsgContext.getRMNamespaceValue());
                faultMessageContext.setWSAAction(SpecSpecificConstants.getAddressingFaultAction(referenceRMMsgContext.getRMSpecVersion()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending fault message " + faultMessageContext.getEnvelope().getHeader()));
                }
                try {
                    AxisEngine.sendFault((MessageContext)faultMessageContext);
                    EndpointReference destination = faultMessageContext.getTo();
                    if (destination == null || destination.hasAnonymousAddress()) {
                        TransportUtils.setResponseWritten((MessageContext)referenceRMMsgContext.getMessageContext(), (boolean)true);
                    }
                }
                catch (Exception e) {
                    AxisFault fault = new AxisFault(faultColdValue.getTextAsQName(), data.getReason(), "", "", data.getDetail());
                    String message = SandeshaMessageHelper.getMessage("couldNotSendFaultDueToException", fault.getMessage(), e.getMessage());
                    log.error((Object)message);
                }
                return;
            }
            String message = SandeshaMessageHelper.getMessage("unknownSoapVersion");
            throw new SandeshaException(message);
        }
        reasonText.setLang("en");
        reason.addSOAPText(reasonText);
        referenceRMMsgContext.setProperty("Code", faultCode);
        referenceRMMsgContext.setProperty("Reason", reason);
        referenceRMMsgContext.setProperty("Detail", detail);
        AxisFault fault = new AxisFault(faultColdValue.getTextAsQName(), data.getReason(), "", "", data.getDetail());
        fault.setFaultAction(SpecSpecificConstants.getAddressingFaultAction(referenceRMMsgContext.getRMSpecVersion()));
        if (throwable) {
            if (referenceRMMsgContext.getMessageContext().isServerSide()) {
                throw fault;
            }
            log.error((Object)("Sandesha2 got a fault when processing the message essage " + referenceRMMsgContext.getMessageId()), (Throwable)fault);
        }
    }

    public static boolean isRMFault(String faultSubcodeValue) {
        if (faultSubcodeValue == null) {
            return false;
        }
        return "CreateSequenceRefused".equalsIgnoreCase(faultSubcodeValue) || "InvalidAcknowledgement".equalsIgnoreCase(faultSubcodeValue) || "LastMessageNumberExceeded".equalsIgnoreCase(faultSubcodeValue) || "MessageNumberRollover".equalsIgnoreCase(faultSubcodeValue) || "SequenceClosed".equalsIgnoreCase(faultSubcodeValue) || "SequenceTerminated".equalsIgnoreCase(faultSubcodeValue) || "UnknownSequence".equalsIgnoreCase(faultSubcodeValue);
    }

    private static Handler.InvocationResponse manageIncomingFault(AxisFault fault, RMMsgContext rmMsgCtx, SOAPFault faultPart) throws AxisFault {
        OMElement identifierOM;
        SOAPFaultDetail detail;
        String identifier;
        String soapFaultSubcode;
        Handler.InvocationResponse response;
        block14: {
            SandeshaListener listner;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: FaultManager::manageIncomingFault");
            }
            response = Handler.InvocationResponse.CONTINUE;
            if (log.isErrorEnabled()) {
                log.error((Object)fault);
            }
            if ((listner = (SandeshaListener)rmMsgCtx.getProperty(SandeshaClientConstants.SANDESHA_LISTENER)) != null) {
                listner.onError(fault);
            }
            SOAPFactory factory = (SOAPFactory)rmMsgCtx.getSOAPEnvelope().getOMFactory();
            String SOAPNamespaceValue = factory.getSoapVersionURI();
            soapFaultSubcode = null;
            identifier = null;
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(SOAPNamespaceValue)) {
                try {
                    SequenceFault sequenceFault = (SequenceFault)rmMsgCtx.getMessagePart(19);
                    if (sequenceFault != null) {
                        soapFaultSubcode = sequenceFault.getFaultCode().getFaultCode().getLocalPart();
                        identifier = sequenceFault.getFaultCode().getDetail();
                    }
                }
                catch (SandeshaException e) {
                    if (!log.isDebugEnabled()) break block14;
                    log.debug((Object)"Unable to process SequenceFault", (Throwable)((Object)e));
                }
            }
        }
        if (soapFaultSubcode == null && faultPart.getCode() != null && faultPart.getCode().getSubCode() != null && faultPart.getCode().getSubCode().getValue() != null) {
            soapFaultSubcode = faultPart.getCode().getSubCode().getValue().getTextAsQName().getLocalPart();
        }
        if ((detail = faultPart.getDetail()) != null && (identifierOM = detail.getFirstChildWithName(new QName(rmMsgCtx.getRMNamespaceValue(), "Identifier"))) != null) {
            identifier = identifierOM.getText();
        }
        if ("CreateSequenceRefused".equals(soapFaultSubcode)) {
            FaultManager.processCreateSequenceRefusedFault(rmMsgCtx, fault);
        } else if ("UnknownSequence".equals(soapFaultSubcode) || "SequenceTerminated".equals(soapFaultSubcode)) {
            FaultManager.processSequenceUnknownFault(rmMsgCtx, fault, identifier);
        }
        if (FaultManager.isRMFault(soapFaultSubcode)) {
            response = Handler.InvocationResponse.ABORT;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: FaultManager::manageIncomingFault, " + response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler.InvocationResponse processMessagesForFaults(RMMsgContext rmMsgCtx, StorageManager storageManager) throws AxisFault {
        Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
        SOAPEnvelope envelope = rmMsgCtx.getSOAPEnvelope();
        if (envelope == null) {
            return response;
        }
        SOAPFault faultPart = envelope.getBody().getFault();
        if (faultPart != null) {
            Transaction transaction = null;
            try {
                transaction = storageManager.getTransaction();
                AxisFault axisFault = FaultManager.getAxisFaultFromFromSOAPFault(faultPart);
                response = FaultManager.manageIncomingFault(axisFault, rmMsgCtx, faultPart);
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
            }
            finally {
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        return response;
    }

    private static AxisFault getAxisFaultFromFromSOAPFault(SOAPFault faultPart) {
        AxisFault axisFault = new AxisFault(faultPart.getCode(), faultPart.getReason(), faultPart.getNode(), faultPart.getRole(), faultPart.getDetail());
        return axisFault;
    }

    public static boolean checkForMessageRolledOver(RMMsgContext rmMessageContext, String sequenceId, long msgNo) throws AxisFault {
        if (msgNo == Long.MAX_VALUE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Max message number reached " + msgNo));
            }
            MessageContext messageContext = rmMessageContext.getMessageContext();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(messageContext.getEnvelope());
            FaultData data = new FaultData();
            data.setCode("Client");
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMessageContext.getRMNamespaceValue(), 2));
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            OMElement identifierElement = factory.createOMElement("Identifier", rmMessageContext.getRMNamespaceValue(), "wsrm");
            identifierElement.setText(sequenceId);
            OMElement maxMsgNumber = factory.createOMElement("MaxMessageNumber", rmMessageContext.getRMNamespaceValue(), "wsrm");
            maxMsgNumber.setText(Long.toString(msgNo));
            data.setDetail(identifierElement);
            data.setDetail2(maxMsgNumber);
            data.setReason(SandeshaMessageHelper.getMessage("messageNumberRollover"));
            data.setType(2);
            FaultManager.getOrSendFault(rmMessageContext, data, true);
            return true;
        }
        return false;
    }

    private static void processCreateSequenceRefusedFault(RMMsgContext rmMsgCtx, AxisFault fault) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: FaultManager::processCreateSequenceRefusedFault");
        }
        ConfigurationContext configCtx = rmMsgCtx.getMessageContext().getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, (AxisDescription)configCtx.getAxisConfiguration());
        RelatesTo relatesTo = rmMsgCtx.getMessageContext().getRelatesTo();
        String createSeqMsgId = null;
        if (relatesTo != null) {
            createSeqMsgId = relatesTo.getValue();
        } else {
            OperationContext context = rmMsgCtx.getMessageContext().getOperationContext();
            MessageContext createSeq = context.getMessageContext("Out");
            if (createSeq != null) {
                createSeqMsgId = createSeq.getMessageID();
            }
        }
        if (createSeqMsgId == null) {
            String message = SandeshaMessageHelper.getMessage("relatesToNotAvailable");
            log.error((Object)message);
            throw new SandeshaException(message);
        }
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean rmsBean = rmsBeanMgr.retrieve(createSeqMsgId);
        if (rmsBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: FaultManager::processCreateSequenceRefusedFault Unable to find RMSBean");
            }
            return;
        }
        SenderBean createSequenceSenderBean = retransmitterMgr.retrieve(createSeqMsgId);
        if (createSequenceSenderBean == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("createSeqEntryNotFound"));
        }
        retransmitterMgr.delete(createSeqMsgId);
        FaultManager.notifyClientsOfFault(rmsBean.getInternalSequenceID(), storageManager, configCtx, fault);
        rmMsgCtx.pause();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Terminating sending sequence " + rmsBean));
        }
        TerminateManager.terminateSendingSide(rmsBean, storageManager);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::processCreateSequenceRefusedFault");
        }
    }

    private static void processSequenceUnknownFault(RMMsgContext rmMsgCtx, AxisFault fault, String sequenceID) throws AxisFault {
        ConfigurationContext configCtx;
        StorageManager storageManager;
        RMSBean rmsBean;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: FaultManager::processSequenceUnknownFault " + sequenceID));
        }
        if ((rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx = rmMsgCtx.getMessageContext().getConfigurationContext(), (AxisDescription)configCtx.getAxisConfiguration()), sequenceID)) != null) {
            FaultManager.notifyClientsOfFault(rmsBean.getInternalSequenceID(), storageManager, configCtx, fault);
            rmMsgCtx.pause();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Terminating sending sequence " + rmsBean));
            }
            TerminateManager.terminateSendingSide(rmsBean, storageManager);
            rmsBean.setLastActivatedTime(System.currentTimeMillis());
            storageManager.getRMSBeanMgr().update(rmsBean);
        } else {
            RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
            if (rmdBean != null) {
                rmMsgCtx.pause();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Terminating sending sequence " + rmdBean));
                }
                TerminateManager.cleanReceivingSideOnTerminateMessage(configCtx, rmdBean.getSequenceID(), storageManager);
                rmdBean.setLastActivatedTime(System.currentTimeMillis());
                storageManager.getRMDBeanMgr().update(rmdBean);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: FaultManager::processSequenceUnknownFault Unable to find sequence");
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: FaultManager::processSequenceUnknownFault");
        }
    }

    static void notifyClientsOfFault(String internalSequenceId, StorageManager storageManager, ConfigurationContext configCtx, AxisFault fault) throws SandeshaStorageException {
        SenderBean target = new SenderBean();
        target.setInternalSequenceID(internalSequenceId);
        Iterator iterator = storageManager.getSenderBeanMgr().find(target).iterator();
        while (iterator.hasNext()) {
            MessageReceiver msgReceiver;
            SenderBean tempBean = (SenderBean)iterator.next();
            String messageStoreKey = tempBean.getMessageContextRefKey();
            MessageContext context = storageManager.retrieveMessageContext(messageStoreKey, configCtx);
            AxisOperation axisOperation = context.getAxisOperation();
            if (axisOperation == null || (msgReceiver = axisOperation.getMessageReceiver()) == null || !(msgReceiver instanceof CallbackReceiver)) continue;
            Object callback = ((CallbackReceiver)msgReceiver).lookupCallback(context.getMessageID());
            if (callback instanceof Callback) {
                ((CallbackReceiver)msgReceiver).addCallback(context.getMessageID(), (Callback)callback);
                ((Callback)callback).onError((Exception)((Object)fault));
                continue;
            }
            if (!(callback instanceof AxisCallback)) continue;
            ((CallbackReceiver)msgReceiver).addCallback(context.getMessageID(), (AxisCallback)callback);
            ((AxisCallback)callback).onError((Exception)((Object)fault));
        }
    }
}

