/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MessageRetransmissionAdjuster;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.util.WSRMMessageSender;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.TerminateSequence;

public class TerminateSeqMsgProcessor
extends WSRMMessageSender
implements MsgProcessor {
    private static final Log log = LogFactory.getLog((Class)TerminateSeqMsgProcessor.class);

    public boolean processInMessage(RMMsgContext terminateSeqRMMsg, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: TerminateSeqMsgProcessor::processInMessage");
        }
        MessageContext terminateSeqMsg = terminateSeqRMMsg.getMessageContext();
        TerminateSequence terminateSequence = (TerminateSequence)terminateSeqRMMsg.getMessagePart(11);
        if (terminateSequence == null) {
            String message = SandeshaMessageHelper.getMessage("noTerminateSeqPart");
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        String sequenceId = terminateSequence.getIdentifier().getIdentifier();
        if (sequenceId == null || "".equals(sequenceId)) {
            String message = SandeshaMessageHelper.getMessage("invalidsequenceID", null);
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        ConfigurationContext context = terminateSeqMsg.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, (AxisDescription)context.getAxisConfiguration());
        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId);
        if (rmdBean != null && rmdBean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(context);
            SOAPBody body = terminateSeqRMMsg.getSOAPEnvelope().getBody();
            SecurityToken token = secManager.recoverSecurityToken(rmdBean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, (OMElement)body, terminateSeqRMMsg.getMessageContext());
        }
        if (FaultManager.checkForUnknownSequence(terminateSeqRMMsg, sequenceId, storageManager, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: TerminateSeqMsgProcessor::processInMessage, unknown sequence");
            }
            return false;
        }
        RMMsgContext terminateSequenceResponse = null;
        if (SpecSpecificConstants.isTerminateSequenceResponseRequired(terminateSeqRMMsg.getRMSpecVersion())) {
            terminateSequenceResponse = this.getTerminateSequenceResponse(terminateSeqRMMsg, rmdBean, sequenceId, storageManager);
        }
        this.setUpHighestMsgNumbers(context, storageManager, sequenceId, terminateSeqRMMsg);
        boolean inOrderInvocation = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).isInOrder();
        boolean doFullTermination = false;
        if (inOrderInvocation) {
            long highestMsgNo = rmdBean.getHighestInMessageNumber();
            long nextMsgToProcess = rmdBean.getNextMsgNoToProcess();
            if (nextMsgToProcess > highestMsgNo) {
                doFullTermination = true;
            }
        } else {
            doFullTermination = true;
        }
        if (doFullTermination) {
            TerminateManager.cleanReceivingSideAfterInvocation(sequenceId, storageManager);
            TerminateManager.cleanReceivingSideOnTerminateMessage(context, sequenceId, storageManager);
        } else {
            TerminateManager.cleanReceivingSideOnTerminateMessage(context, sequenceId, storageManager);
        }
        rmdBean.setTerminated(true);
        rmdBean.setLastActivatedTime(System.currentTimeMillis());
        storageManager.getRMDBeanMgr().update(rmdBean);
        if (terminateSequenceResponse != null) {
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            MessageContext outMessage = terminateSequenceResponse.getMessageContext();
            EndpointReference toEPR = outMessage.getTo();
            outMessage.setServerSide(true);
            try {
                AxisEngine.send((MessageContext)outMessage);
            }
            catch (AxisFault e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to send terminate sequence response", (Throwable)e);
                }
                throw new SandeshaException(SandeshaMessageHelper.getMessage("couldNotSendTerminateResponse"), (Exception)((Object)e));
            }
            if (toEPR.hasAnonymousAddress()) {
                TransportUtils.setResponseWritten((MessageContext)terminateSeqMsg, (boolean)true);
            }
        } else {
            EndpointReference toEPR;
            String outgoingSideInternalSeqId = SandeshaUtil.getOutgoingSideInternalSequenceID(sequenceId);
            SenderBean senderFindBean = new SenderBean();
            senderFindBean.setInternalSequenceID(outgoingSideInternalSeqId);
            senderFindBean.setMessageType(7);
            senderFindBean.setSend(true);
            senderFindBean.setReSend(false);
            SenderBean outgoingSideTerminateBean = storageManager.getSenderBeanMgr().findUnique(senderFindBean);
            if (outgoingSideTerminateBean != null && (toEPR = new EndpointReference(outgoingSideTerminateBean.getToAddress())).hasAnonymousAddress()) {
                String messageKey = outgoingSideTerminateBean.getMessageContextRefKey();
                MessageContext message = storageManager.retrieveMessageContext(messageKey, context);
                RMMsgContext rmMessage = MsgInitializer.initializeMessage(message);
                message.setTransportOut(terminateSeqMsg.getTransportOut());
                message.setProperty("TRANSPORT_OUT", terminateSeqMsg.getProperty("TRANSPORT_OUT"));
                message.setProperty("OutTransportInfo", terminateSeqMsg.getProperty("OutTransportInfo"));
                try {
                    AxisEngine.send((MessageContext)message);
                    TransportUtils.setResponseWritten((MessageContext)terminateSeqMsg, (boolean)true);
                }
                catch (AxisFault e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unable to send terminate sequence response", (Throwable)e);
                    }
                    throw new SandeshaException(SandeshaMessageHelper.getMessage("couldNotSendTerminateResponse"), (Exception)((Object)e));
                }
                MessageRetransmissionAdjuster.adjustRetransmittion(rmMessage, outgoingSideTerminateBean, context, storageManager);
            }
        }
        terminateSeqMsg.pause();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: TerminateSeqMsgProcessor::processInMessage " + Boolean.TRUE));
        }
        return true;
    }

    private void setUpHighestMsgNumbers(ConfigurationContext configCtx, StorageManager storageManager, String sequenceId, RMMsgContext terminateRMMsg) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: TerminateSeqMsgProcessor::setUpHighestMsgNumbers, " + sequenceId));
        }
        RMDBeanMgr mgr = storageManager.getRMDBeanMgr();
        RMDBean bean = mgr.retrieve(sequenceId);
        long highestInMsgNo = bean.getHighestInMessageNumber();
        String responseSideInternalSequenceId = SandeshaUtil.getOutgoingSideInternalSequenceID(sequenceId);
        long highestOutMsgNo = 0L;
        try {
            RMSBean rmsBean;
            boolean allAcked;
            boolean addResponseSideTerminate = false;
            if (highestInMsgNo == 0L) {
                addResponseSideTerminate = false;
            } else {
                String highestOutRelatesTo;
                String inMsgId = bean.getHighestInMessageId();
                bean.setLastInMessageId(inMsgId);
                storageManager.getRMDBeanMgr().update(bean);
                RMSBean rmsBean2 = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, responseSideInternalSequenceId);
                if (rmsBean2 != null && (highestOutRelatesTo = rmsBean2.getHighestOutRelatesTo()) != null && highestOutRelatesTo.equals(inMsgId)) {
                    highestOutMsgNo = rmsBean2.getHighestOutMessageNumber();
                    addResponseSideTerminate = true;
                    rmsBean2.setLastOutMessage(highestOutMsgNo);
                    storageManager.getRMSBeanMgr().update(rmsBean2);
                }
            }
            String outgoingSequnceID = SandeshaUtil.getSequenceIDFromInternalSequenceID(responseSideInternalSequenceId, storageManager);
            if (addResponseSideTerminate && highestOutMsgNo > 0L && responseSideInternalSequenceId != null && outgoingSequnceID != null && (allAcked = SandeshaUtil.isAllMsgsAckedUpto(highestOutMsgNo, responseSideInternalSequenceId, storageManager)) && !(rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, outgoingSequnceID)).isTerminateAdded()) {
                TerminateManager.addTerminateSequenceMessage(terminateRMMsg, rmsBean.getInternalSequenceID(), outgoingSequnceID, storageManager);
                String referenceMsgKey = rmsBean.getReferenceMessageStoreKey();
                if (referenceMsgKey == null) {
                    String message = SandeshaMessageHelper.getMessage("referenceMessageNotSetForSequence", rmsBean.getSequenceID());
                    throw new SandeshaException(message);
                }
                MessageContext referenceMessage = storageManager.retrieveMessageContext(referenceMsgKey, configCtx);
                if (referenceMessage == null) {
                    String message = SandeshaMessageHelper.getMessage("referencedMessageNotFound", rmsBean.getSequenceID());
                    throw new SandeshaException(message);
                }
            }
        }
        catch (AxisFault e) {
            throw new SandeshaException((Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: TerminateSeqMsgProcessor::setUpHighestMsgNumbers");
        }
    }

    private RMMsgContext getTerminateSequenceResponse(RMMsgContext terminateSeqRMMsg, RMDBean rmdBean, String sequenceId, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: TerminateSeqMsgProcessor::addTerminateSequenceResponse, " + sequenceId));
        }
        RMMsgContext terminateSeqResponseRMMsg = RMMsgCreator.createTerminateSeqResponseMsg(terminateSeqRMMsg, rmdBean);
        MessageContext outMessage = terminateSeqResponseRMMsg.getMessageContext();
        RMMsgContext ackRMMessage = AcknowledgementManager.generateAckMessage(terminateSeqRMMsg, rmdBean, sequenceId, storageManager, true);
        Iterator iter = ackRMMessage.getMessageParts(7);
        while (iter.hasNext()) {
            SequenceAcknowledgement seqAck = (SequenceAcknowledgement)iter.next();
            terminateSeqResponseRMMsg.setMessagePart(7, seqAck);
        }
        terminateSeqResponseRMMsg.addSOAPEnvelope();
        terminateSeqResponseRMMsg.setFlow(2);
        terminateSeqResponseRMMsg.setProperty("Sandesha2AppProcessingDone", "true");
        outMessage.setResponseWritten(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: TerminateSeqMsgProcessor::addTerminateSequenceResponse");
        }
        return terminateSeqResponseRMMsg;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: TerminateSeqMsgProcessor::processOutMessage");
        }
        this.setupOutMessage(rmMsgCtx);
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(this.getStorageManager(), this.getInternalSequenceID());
        if (rmsBean.isTerminateAdded()) {
            String message = SandeshaMessageHelper.getMessage("terminateAddedPreviously");
            log.debug((Object)message);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: TerminateSeqMsgProcessor::processOutMessage, sequence previously terminated");
            }
            return true;
        }
        AxisOperation terminateOp = SpecSpecificConstants.getWSRMOperation(7, rmMsgCtx.getRMSpecVersion(), this.getMsgContext().getAxisService());
        OperationContext opcontext = OperationContextFactory.createOperationContext((int)terminateOp.getAxisSpecificMEPConstant(), (AxisOperation)terminateOp, (ServiceContext)this.getMsgContext().getServiceContext());
        opcontext.setParent((AbstractContext)this.getMsgContext().getServiceContext());
        this.getConfigurationContext().registerOperationContext(rmMsgCtx.getMessageId(), opcontext);
        this.getMsgContext().setOperationContext(opcontext);
        this.getMsgContext().setAxisOperation(terminateOp);
        TerminateSequence terminateSequencePart = (TerminateSequence)rmMsgCtx.getMessagePart(11);
        terminateSequencePart.getIdentifier().setIndentifer(this.getOutSequenceID());
        rmMsgCtx.setWSAAction(SpecSpecificConstants.getTerminateSequenceAction(this.getRMVersion()));
        rmMsgCtx.setSOAPAction(SpecSpecificConstants.getTerminateSequenceSOAPAction(this.getRMVersion()));
        rmsBean.setTerminateAdded(true);
        this.getStorageManager().getRMSBeanMgr().update(rmsBean);
        this.sendOutgoingMessage(rmMsgCtx, 7, 100L);
        rmMsgCtx.pause();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: TerminateSeqMsgProcessor::processOutMessage " + Boolean.TRUE));
        }
        return true;
    }
}

