/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.MessageValidator;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.SequenceOffer;

public class ApplicationMsgProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog((Class)ApplicationMsgProcessor.class);
    private String inboundSequence = null;
    private long inboundMessageNumber;

    public ApplicationMsgProcessor() {
    }

    public ApplicationMsgProcessor(String inboundSequenceId, long inboundMessageNumber) {
        this.inboundSequence = inboundSequenceId;
        this.inboundMessageNumber = inboundMessageNumber;
    }

    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ApplicationMsgProcessor::processInMessage");
            log.debug((Object)"Exit: ApplicationMsgProcessor::processInMessage");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOutMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        EndpointReference toEPR;
        SOAPBody soapBody;
        SOAPEnvelope env;
        RelatesTo relatesTo;
        RMSBean rmsBean;
        OperationContext operationContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ApplicationMsgProcessor::processOutMessage");
        }
        MessageContext msgContext = rmMsgCtx.getMessageContext();
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        MessageValidator.validateOutgoingMessage(rmMsgCtx);
        SandeshaListener faultCallback = (SandeshaListener)msgContext.getOptions().getProperty(SandeshaClientConstants.SANDESHA_LISTENER);
        if (faultCallback != null && (operationContext = msgContext.getOperationContext()) != null) {
            operationContext.setProperty(SandeshaClientConstants.SANDESHA_LISTENER, (Object)faultCallback);
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configContext, (AxisDescription)configContext.getAxisConfiguration());
        boolean serverSide = msgContext.isServerSide();
        if (msgContext.getMessageID() == null) {
            msgContext.setMessageID(SandeshaUtil.getUUID());
        }
        String internalSequenceId = null;
        String storageKey = SandeshaUtil.getUUID();
        boolean lastMessage = false;
        if (serverSide) {
            if (this.inboundSequence == null || "".equals(this.inboundSequence)) {
                String message = SandeshaMessageHelper.getMessage("incomingSequenceNotValidID", this.inboundSequence);
                log.debug((Object)message);
                throw new SandeshaException(message);
            }
            internalSequenceId = SandeshaUtil.getOutgoingSideInternalSequenceID(this.inboundSequence);
        } else {
            EndpointReference toEPR2 = msgContext.getTo();
            if (toEPR2 == null || toEPR2.getAddress() == null || "".equals(toEPR2.getAddress())) {
                String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
                log.debug((Object)message);
                throw new SandeshaException(message);
            }
            String to = toEPR2.getAddress();
            String sequenceKey = (String)msgContext.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
            internalSequenceId = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
            String lastAppMessage = (String)msgContext.getProperty(SandeshaClientConstants.LAST_MESSAGE);
            if (lastAppMessage != null && "true".equals(lastAppMessage)) {
                lastMessage = true;
            }
        }
        if (internalSequenceId != null) {
            rmMsgCtx.setProperty("Sandesha2InternalSequenceId", internalSequenceId);
        }
        Long messageNumberLng = (Long)msgContext.getProperty(SandeshaClientConstants.MESSAGE_NUMBER);
        long givenMessageNumber = -1L;
        if (messageNumberLng != null && (givenMessageNumber = messageNumberLng.longValue()) <= 0L) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("msgNumberMustBeLargerThanZero", Long.toString(givenMessageNumber)));
        }
        String dummyMessageString = (String)msgContext.getOptions().getProperty(SandeshaClientConstants.DUMMY_MESSAGE);
        boolean dummyMessage = false;
        if (dummyMessageString != null && "true".equals(dummyMessageString)) {
            dummyMessage = true;
        }
        if ((rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId)) != null && rmsBean.isSequenceClosedClient()) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceClosed", internalSequenceId));
        }
        if (rmsBean != null && rmsBean.isTerminateAdded()) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceTerminated", internalSequenceId));
        }
        if (rmsBean != null && rmsBean.isTimedOut()) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceTimedout", internalSequenceId));
        }
        if (!serverSide) {
            AxisOperation op = msgContext.getAxisOperation();
            int mep = -1;
            if (op != null) {
                mep = op.getAxisSpecificMEPConstant();
            }
            if (mep == 16) {
                SandeshaPolicyBean policy;
                EndpointReference replyTo;
                String specVersion = null;
                specVersion = rmsBean == null ? SequenceManager.getSpecVersion(msgContext, storageManager) : rmsBean.getRMVersion();
                if (specVersion == "Spec_2007_02" && ((replyTo = msgContext.getReplyTo()) == null || replyTo.hasAnonymousAddress()) && !(policy = SandeshaUtil.getPropertyBean((AxisDescription)configContext.getAxisConfiguration())).isEnableMakeConnection()) {
                    String message = SandeshaMessageHelper.getMessage("makeConnectionDisabled");
                    throw new SandeshaException(message);
                }
            }
        }
        if (rmsBean != null && rmsBean.getReferenceMessageStoreKey() == null) {
            String referenceMsgKey = SandeshaUtil.getUUID();
            storageManager.storeMessageContext(referenceMsgKey, msgContext);
            rmsBean.setReferenceMessageStoreKey(referenceMsgKey);
        }
        String outSequenceID = null;
        if (rmsBean == null) {
            Class mep = RMSBeanMgr.class;
            synchronized (mep) {
                rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
                if (rmsBean == null) {
                    rmsBean = SequenceManager.setupNewClientSequence(msgContext, internalSequenceId, storageManager);
                    rmsBean = this.addCreateSequenceMessage(rmMsgCtx, rmsBean, storageManager);
                }
            }
        } else {
            outSequenceID = rmsBean.getSequenceID();
        }
        long systemMessageNumber = rmsBean.getNextMessageNumber();
        if (givenMessageNumber > 0L && givenMessageNumber <= systemMessageNumber) {
            String message = SandeshaMessageHelper.getMessage("msgNumberNotLargerThanLastMsg", Long.toString(givenMessageNumber));
            throw new SandeshaException(message);
        }
        long messageNumber = -1L;
        messageNumber = givenMessageNumber > 0L ? givenMessageNumber : (systemMessageNumber > 0L ? systemMessageNumber + 1L : 1L);
        if (serverSide) {
            Boolean inboundLast;
            RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, this.inboundSequence);
            String lastRequestId = rmdBean.getLastInMessageId();
            RelatesTo relatesTo2 = msgContext.getRelatesTo();
            if (relatesTo2 != null && lastRequestId != null && lastRequestId.equals(relatesTo2.getValue())) {
                lastMessage = true;
            }
            if ((inboundLast = (Boolean)msgContext.getProperty("Sandesha2InboundLastMessage")) != null && inboundLast.booleanValue()) {
                lastMessage = true;
            }
        }
        if (lastMessage) {
            rmsBean.setLastOutMessage(messageNumber);
        }
        rmsBean.setHighestOutMessageNumber(messageNumber);
        boolean startPolling = false;
        if (!dummyMessage) {
            rmsBean.setNextMessageNumber(messageNumber);
            AxisOperation op = msgContext.getAxisOperation();
            int mep = -1;
            if (op != null) {
                mep = op.getAxisSpecificMEPConstant();
            }
            if (mep == 16) {
                EndpointReference replyTo = msgContext.getReplyTo();
                if (replyTo == null || replyTo.hasAnonymousAddress()) {
                    long expectedReplies = rmsBean.getExpectedReplies();
                    rmsBean.setExpectedReplies(expectedReplies + 1L);
                }
                if ("Spec_2007_02".equals(rmMsgCtx.getRMSpecVersion())) {
                    String newAddress;
                    String oldAddress = replyTo == null ? null : replyTo.getAddress();
                    EndpointReference newReplyTo = SandeshaUtil.rewriteEPR(rmsBean, msgContext.getReplyTo(), configContext);
                    String string = newAddress = newReplyTo == null ? null : newReplyTo.getAddress();
                    if (newAddress != null && !newAddress.equals(oldAddress)) {
                        msgContext.setReplyTo(newReplyTo);
                        if (!rmsBean.isPollingMode()) {
                            rmsBean.setPollingMode(true);
                            startPolling = true;
                        }
                    }
                }
            }
        }
        if ((relatesTo = msgContext.getRelatesTo()) != null) {
            rmsBean.setHighestOutRelatesTo(relatesTo.getValue());
        }
        if (serverSide && rmsBean.getToEPR() != null) {
            msgContext.setProperty(SandeshaClientConstants.AcksTo, (Object)rmsBean.getToEPR());
        }
        rmsBean.setApplicationMessageMessageId(msgContext.getMessageID());
        storageManager.getRMSBeanMgr().update(rmsBean);
        if (startPolling) {
            SandeshaUtil.startWorkersForSequence(msgContext.getConfigurationContext(), rmsBean);
        }
        if ((env = rmMsgCtx.getSOAPEnvelope()) == null) {
            SOAPEnvelope envelope = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(env)).getDefaultEnvelope();
            rmMsgCtx.setSOAPEnvelop(envelope);
        }
        if ((soapBody = rmMsgCtx.getSOAPEnvelope().getBody()) == null) {
            String message = SandeshaMessageHelper.getMessage("soapBodyNotPresent");
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        String messageId1 = SandeshaUtil.getUUID();
        if (rmMsgCtx.getMessageId() == null) {
            rmMsgCtx.setMessageId(messageId1);
        }
        if ((toEPR = msgContext.getTo()) != null) {
            String to = toEPR.getAddress();
            String operationName = msgContext.getOperationContext().getAxisOperation().getName().getLocalPart();
            if (msgContext.getWSAAction() == null) {
                msgContext.setWSAAction(to + "/" + operationName);
            }
            if (msgContext.getSoapAction() == null) {
                msgContext.setSoapAction("\"" + to + "/" + operationName + "\"");
            }
        }
        if (!dummyMessage) {
            this.processResponseMessage(rmMsgCtx, rmsBean, internalSequenceId, outSequenceID, messageNumber, storageKey, storageManager);
        }
        msgContext.pause();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: ApplicationMsgProcessor::processOutMessage " + Boolean.TRUE));
        }
        return true;
    }

    private RMSBean addCreateSequenceMessage(RMMsgContext applicationRMMsg, RMSBean rmsBean, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ApplicationMsgProcessor::addCreateSequenceMessage, " + rmsBean));
        }
        MessageContext applicationMsg = applicationRMMsg.getMessageContext();
        ConfigurationContext configCtx = applicationMsg.getConfigurationContext();
        RMMsgContext createSeqRMMessage = RMMsgCreator.createCreateSeqMsg(rmsBean, applicationRMMsg);
        createSeqRMMessage.setFlow(2);
        CreateSequence createSequencePart = (CreateSequence)createSeqRMMessage.getMessagePart(9);
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        SequenceOffer offer = createSequencePart.getSequenceOffer();
        if (offer != null) {
            String offeredSequenceId = offer.getIdentifer().getIdentifier();
            rmsBean.setOfferedSequence(offeredSequenceId);
        }
        MessageContext createSeqMsg = createSeqRMMessage.getMessageContext();
        createSeqMsg.setRelationships(null);
        String createSequenceMessageStoreKey = SandeshaUtil.getUUID();
        rmsBean.setCreateSeqMsgID(createSeqMsg.getMessageID());
        rmsBean.setCreateSequenceMsgStoreKey(createSequenceMessageStoreKey);
        MessageContext clonedMessage = SandeshaUtil.cloneMessageContext(createSeqMsg);
        String clonedMsgStoreKey = SandeshaUtil.getUUID();
        storageManager.storeMessageContext(clonedMsgStoreKey, clonedMessage);
        rmsBean.setReferenceMessageStoreKey(clonedMsgStoreKey);
        SecurityToken token = (SecurityToken)createSeqRMMessage.getProperty("SecurityToken");
        if (token != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
            rmsBean.setSecurityTokenData(secManager.getTokenRecoveryData(token));
        }
        storageManager.getRMSBeanMgr().insert(rmsBean);
        SenderBean createSeqEntry = new SenderBean();
        createSeqEntry.setMessageContextRefKey(createSequenceMessageStoreKey);
        createSeqEntry.setTimeToSend(System.currentTimeMillis());
        createSeqEntry.setMessageID(createSeqRMMessage.getMessageId());
        createSeqEntry.setInternalSequenceID(rmsBean.getInternalSequenceID());
        createSeqEntry.setSend(true);
        createSeqEntry.setMessageType(1);
        EndpointReference to = createSeqRMMessage.getTo();
        if (to != null) {
            createSeqEntry.setToAddress(to.getAddress());
        }
        if (to == null || to.hasAnonymousAddress()) {
            createSeqEntry.setTransportAvailable(false);
        }
        createSeqMsg.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        SandeshaUtil.executeAndStore(createSeqRMMessage, createSequenceMessageStoreKey);
        retransmitterMgr.insert(createSeqEntry);
        SandeshaUtil.startWorkersForSequence(configCtx, rmsBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: ApplicationMsgProcessor::addCreateSequenceMessage, " + rmsBean));
        }
        return rmsBean;
    }

    private void processResponseMessage(RMMsgContext rmMsg, RMSBean rmsBean, String internalSequenceId, String outSequenceID, long messageNumber, String storageKey, StorageManager storageManager) throws AxisFault {
        EndpointReference to;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ApplicationMsgProcessor::processResponseMessage, " + internalSequenceId + ", " + outSequenceID));
        }
        MessageContext msg = rmMsg.getMessageContext();
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        boolean lastMessage = false;
        if (msg.isServerSide()) {
            Boolean inboundLast = (Boolean)msg.getProperty("Sandesha2InboundLastMessage");
            if (inboundLast != null && inboundLast.booleanValue()) {
                lastMessage = true;
            }
        } else {
            Object obj = msg.getProperty(SandeshaClientConstants.LAST_MESSAGE);
            if (obj != null && "true".equals(obj)) {
                lastMessage = true;
            }
        }
        RMMsgCreator.secureOutboundMessage(rmsBean, msg);
        SenderBean appMsgEntry = new SenderBean();
        appMsgEntry.setMessageContextRefKey(storageKey);
        appMsgEntry.setTimeToSend(System.currentTimeMillis());
        appMsgEntry.setMessageID(rmMsg.getMessageId());
        appMsgEntry.setMessageNumber(messageNumber);
        appMsgEntry.setLastMessage(lastMessage);
        SOAPEnvelope envelope = rmMsg.getSOAPEnvelope();
        if (lastMessage && envelope != null && envelope.getBody().getFirstOMChild() == null) {
            appMsgEntry.setMessageType(12);
        } else {
            appMsgEntry.setMessageType(3);
        }
        appMsgEntry.setInboundSequenceId(this.inboundSequence);
        appMsgEntry.setInboundMessageNumber(this.inboundMessageNumber);
        if (outSequenceID == null) {
            appMsgEntry.setSend(false);
        } else {
            appMsgEntry.setSend(true);
            msg.setProperty("Sandesha2SetSendToTrue", (Object)"true");
            appMsgEntry.setSequenceID(outSequenceID);
        }
        if (rmsBean.isReplayModel()) {
            appMsgEntry.setReSend(false);
        }
        if ((to = rmMsg.getTo()) != null) {
            appMsgEntry.setToAddress(to.getAddress());
        }
        appMsgEntry.setInternalSequenceID(internalSequenceId);
        msg.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        msg.setCurrentHandlerIndex(msg.getCurrentHandlerIndex() + 1);
        SandeshaUtil.executeAndStore(rmMsg, storageKey);
        retransmitterMgr.insert(appMsgEntry);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: ApplicationMsgProcessor::processResponseMessage");
        }
    }
}

