/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.wsdl.codegen.extension.ModulePolicyExtension;
import org.apache.axis2.wsdl.codegen.extension.PolicyExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.RMPolicyExtension;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.util.PropertyManager;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.SandeshaThread;

public class SandeshaModule
implements Module,
ModulePolicyExtension {
    private Log log = LogFactory.getLog((Class)SandeshaModule.class);

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        String message;
        String message2;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entry: SandeshaModule::init, " + configContext));
        }
        AxisConfiguration config = configContext.getAxisConfiguration();
        Parameter parameter = new Parameter("Sandesha2ModuleClassLoader", (Object)module.getModuleClassLoader());
        config.addParameter(parameter);
        SandeshaMessageHelper.innit();
        SandeshaUtil.setAxisModule(module);
        SandeshaPolicyBean constantPropertyBean = new SandeshaPolicyBean();
        SandeshaPolicyBean propertyBean = PropertyManager.loadPropertiesFromModuleDescPolicy(module, constantPropertyBean);
        if (propertyBean == null) {
            message2 = SandeshaMessageHelper.getMessage("couldNotLoadModulePolicies");
            this.log.error((Object)message2);
            propertyBean = new SandeshaPolicyBean();
        } else if (this.log.isDebugEnabled()) {
            message2 = SandeshaMessageHelper.getMessage("modulePoliciesLoaded");
            this.log.info((Object)message2);
        }
        parameter = new Parameter("Sandesha2PropertyBean", (Object)propertyBean);
        config.addParameter(parameter);
        parameter = config.getParameter("inmemory");
        if (parameter != null) {
            config.removeParameter(parameter);
        }
        if ((parameter = config.getParameter("persistent")) != null) {
            config.removeParameter(parameter);
        }
        try {
            StorageManager inMemorytorageManager = SandeshaUtil.getInMemoryStorageManager(configContext);
            inMemorytorageManager.initStorage(module);
        }
        catch (SandeshaStorageException e) {
            message = SandeshaMessageHelper.getMessage("cannotInitInMemoryStorageManager", e.toString());
            this.log.debug((Object)message, (Throwable)((Object)e));
        }
        try {
            StorageManager permanentStorageManager = SandeshaUtil.getPermanentStorageManager(configContext);
            permanentStorageManager.initStorage(module);
        }
        catch (SandeshaStorageException e) {
            message = SandeshaMessageHelper.getMessage("cannotInitPersistentStorageManager", e.toString());
            this.log.debug((Object)message, (Throwable)((Object)e));
        }
        parameter = config.getParameter("Sandesha2SecurityManager");
        if (parameter != null) {
            config.removeParameter(parameter);
        }
        SecurityManager util = SandeshaUtil.getSecurityManager(configContext);
        util.initSecurity(module);
        configContext.setProperty("UseAsyncOperations", (Object)Boolean.TRUE);
        configContext.getAxisConfiguration().addTargetResolver(new TargetResolver(){

            public void resolveTarget(MessageContext messageContext) {
                AxisOperation operation;
                AxisService service;
                boolean engaged = false;
                AxisConfiguration axisConfiguration = messageContext.getConfigurationContext().getAxisConfiguration();
                if (axisConfiguration != null) {
                    Collection modules = axisConfiguration.getEngagedModules();
                    Iterator iter = modules.iterator();
                    while (iter.hasNext()) {
                        AxisModule module = (AxisModule)iter.next();
                        String moduleName = module.getName();
                        if (moduleName == null || !moduleName.startsWith("sandesha2")) continue;
                        engaged = true;
                    }
                }
                if ((service = messageContext.getAxisService()) != null) {
                    Collection modules = service.getEngagedModules();
                    Iterator iter = modules.iterator();
                    while (iter.hasNext()) {
                        AxisModule module = (AxisModule)iter.next();
                        String name = module.getName();
                        if (name == null || !name.startsWith("sandesha2")) continue;
                        engaged = true;
                    }
                }
                if ((operation = messageContext.getAxisOperation()) != null) {
                    Collection modules = operation.getEngagedModules();
                    Iterator iter = modules.iterator();
                    while (iter.hasNext()) {
                        AxisModule module = (AxisModule)iter.next();
                        String name = module.getName();
                        if (name == null || !name.startsWith("sandesha2")) continue;
                        engaged = true;
                    }
                }
                if (!engaged) {
                    if (SandeshaModule.this.log.isDebugEnabled()) {
                        SandeshaModule.this.log.debug((Object)"Unsetting USE_ASYNC_OPERATIONS and DISABLE_RESPONSE_ACK for unreliable message");
                    }
                    messageContext.setProperty("UseAsyncOperations", (Object)Boolean.FALSE);
                    messageContext.setProperty("DisableResponseAck", (Object)Boolean.FALSE);
                }
                if (SandeshaModule.this.log.isDebugEnabled()) {
                    SandeshaModule.this.log.debug((Object)"Entry: SandeshaModule::resolveTarget");
                }
                if (SandeshaUtil.isMessageUnreliable(messageContext)) {
                    if (SandeshaModule.this.log.isDebugEnabled()) {
                        SandeshaModule.this.log.debug((Object)"Unsetting USE_ASYNC_OPERATIONS for unreliable message");
                    }
                    messageContext.setProperty("UseAsyncOperations", (Object)Boolean.FALSE);
                }
                if (SandeshaModule.this.log.isDebugEnabled()) {
                    SandeshaModule.this.log.debug((Object)"Exit: SandeshaModule::resolveTarget");
                }
            }
        });
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit: SandeshaModule::init");
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        SandeshaPolicyBean axisDescPropertyBean;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entry: SandeshaModule::engageNotify, " + axisDescription));
        }
        AxisDescription parent = axisDescription.getParent();
        SandeshaPolicyBean parentPropertyBean = null;
        if (parent != null) {
            parentPropertyBean = SandeshaUtil.getPropertyBean(parent);
        }
        if ((axisDescPropertyBean = PropertyManager.loadPropertiesFromAxisDescription(axisDescription, parentPropertyBean)) != null) {
            Parameter parameter = new Parameter();
            parameter.setName("Sandesha2PropertyBean");
            parameter.setValue((Object)axisDescPropertyBean);
            axisDescription.addParameter(parameter);
        }
        if (axisDescription instanceof AxisService) {
            AxisService service = (AxisService)axisDescription;
            Iterator ops = service.getOperations();
            while (ops.hasNext()) {
                AxisOperation op = (AxisOperation)ops.next();
                this.log.debug((Object)("Examining operation " + op.getName() + ", mep " + op.getMessageExchangePattern()));
                String name = null;
                QName qName = op.getName();
                if (qName != null) {
                    name = qName.getLocalPart();
                }
                if (!(name != null && name.startsWith("Sandesha2Operation") || ServiceClient.ANON_OUT_IN_OP.equals(qName))) {
                    if (op.getAxisSpecificMEPConstant() != 16) continue;
                    Parameter p = new Parameter("ServiceContainsOutInMeps", (Object)Boolean.TRUE);
                    service.addParameter(p);
                }
                break;
            }
        } else if (axisDescription instanceof AxisOperation) {
            AxisOperation op = (AxisOperation)axisDescription;
            this.log.debug((Object)("Examining operation " + op.getName() + ", mep " + op.getAxisSpecificMEPConstant()));
            String name = null;
            QName qName = op.getName();
            if (qName != null) {
                name = qName.getLocalPart();
            }
            if (name != null && !name.startsWith("Sandesha2Operation") && !ServiceClient.ANON_OUT_IN_OP.equals(qName) && op.getAxisSpecificMEPConstant() == 16) {
                Parameter p = new Parameter("ServiceContainsOutInMeps", (Object)Boolean.TRUE);
                op.getParent().addParameter(p);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit: SandeshaModule::engageNotify");
        }
    }

    public PolicyExtension getPolicyExtension() {
        return new RMPolicyExtension();
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        StorageManager storageManager;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entry: SandeshaModule::shutdown, " + configurationContext));
        }
        if ((storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)configurationContext.getAxisConfiguration())) != null) {
            SandeshaThread sender = storageManager.getSender();
            SandeshaThread invoker = storageManager.getInvoker();
            PollingManager pollingManager = storageManager.getPollingManager();
            if (sender != null) {
                sender.stopRunning();
            }
            if (invoker != null) {
                invoker.stopRunning();
            }
            if (pollingManager != null) {
                pollingManager.stopRunning();
            }
            storageManager.shutdown();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit: SandeshaModule::shutdown");
        }
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return true;
    }
}

