/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.wsrm.IOMRMPart;

public class RMMsgContext {
    private MessageContext msgContext;
    private HashMap rmMessageParts = new HashMap();
    private int messageType = 0;
    private String rmNamespaceValue = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private String rmSpecVersion = null;

    public RMMsgContext() {
    }

    public void setMessageContext(MessageContext msgCtx) {
        this.msgContext = msgCtx;
    }

    public RMMsgContext(MessageContext ctx) {
        this();
        this.msgContext = ctx;
    }

    public void addSOAPEnvelope() throws AxisFault {
        int SOAPVersion2 = 1;
        if (!this.msgContext.isSOAP11()) {
            SOAPVersion2 = 2;
        }
        if (this.msgContext.getEnvelope() == null) {
            try {
                this.msgContext.setEnvelope(SOAPAbstractFactory.getSOAPFactory(SOAPVersion2).getDefaultEnvelope());
            }
            catch (AxisFault e) {
                throw new SandeshaException(e.getMessage());
            }
        }
        SOAPEnvelope envelope = this.msgContext.getEnvelope();
        Iterator keys = this.rmMessageParts.keySet().iterator();
        while (keys.hasNext()) {
            Integer key = (Integer)keys.next();
            int partId = key;
            if (this.isMultiPart(partId)) {
                Iterator it = this.getMessageParts(partId);
                while (it.hasNext()) {
                    IOMRMPart rmPart = (IOMRMPart)it.next();
                    rmPart.toSOAPEnvelope(envelope);
                }
                continue;
            }
            IOMRMPart rmPart = (IOMRMPart)this.rmMessageParts.get(key);
            rmPart.toSOAPEnvelope(envelope);
        }
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int msgType) {
        if (msgType >= 0 && msgType <= 15) {
            this.messageType = msgType;
        }
    }

    public void setMessagePart(int partId, IOMRMPart part) {
        if (partId >= 0 && partId <= 19) {
            if (this.isMultiPart(partId)) {
                ArrayList<IOMRMPart> partList = (ArrayList<IOMRMPart>)this.rmMessageParts.get(new Integer(partId));
                if (partList == null) {
                    partList = new ArrayList<IOMRMPart>();
                    this.rmMessageParts.put(new Integer(partId), partList);
                }
                partList.add(part);
            } else {
                this.rmMessageParts.put(new Integer(partId), part);
            }
        }
    }

    public IOMRMPart getMessagePart(int partId) throws SandeshaException {
        if (this.isMultiPart(partId)) {
            String message = "It is possible for a multiple MessageParts of this type to exit. Please call the 'getMessageParts' method";
            throw new SandeshaException(message);
        }
        return (IOMRMPart)this.rmMessageParts.get(new Integer(partId));
    }

    public Iterator getMessageParts(int partId) {
        Object obj = this.rmMessageParts.get(new Integer(partId));
        if (obj == null) {
            return new ArrayList().iterator();
        }
        if (obj instanceof ArrayList) {
            return ((ArrayList)obj).iterator();
        }
        ArrayList arr = new ArrayList();
        arr.add(obj);
        return arr.iterator();
    }

    public void removeMessageParts(int messageType) {
        this.rmMessageParts.remove(new Integer(messageType));
    }

    public boolean isMultiPart(int messagePartId) {
        return messagePartId == 7 || messagePartId == 15;
    }

    public EndpointReference getFrom() {
        return this.msgContext.getFrom();
    }

    public EndpointReference getTo() {
        return this.msgContext.getTo();
    }

    public EndpointReference getReplyTo() {
        return this.msgContext.getReplyTo();
    }

    public RelatesTo getRelatesTo() {
        return this.msgContext.getRelatesTo();
    }

    public String getMessageId() {
        return this.msgContext.getMessageID();
    }

    public void setFaultTo(EndpointReference epr) {
        this.msgContext.setFaultTo(epr);
    }

    public EndpointReference getFaultTo() {
        return this.msgContext.getFaultTo();
    }

    public SOAPEnvelope getSOAPEnvelope() {
        return this.msgContext.getEnvelope();
    }

    public void setSOAPEnvelop(SOAPEnvelope envelope) throws SandeshaException {
        try {
            this.msgContext.setEnvelope(envelope);
        }
        catch (AxisFault e) {
            throw new SandeshaException(e.getMessage());
        }
    }

    public void setFrom(EndpointReference epr) {
        this.msgContext.setFrom(epr);
    }

    public void setTo(EndpointReference epr) {
        this.msgContext.setTo(epr);
    }

    public void setReplyTo(EndpointReference epr) {
        this.msgContext.setReplyTo(epr);
    }

    public void setMessageId(String messageId) {
        this.msgContext.setMessageID(messageId);
    }

    public void setAction(String action) {
        this.msgContext.setWSAAction(action);
    }

    public void addRelatesTo(RelatesTo relatesTo) {
        this.msgContext.addRelatesTo(relatesTo);
    }

    public void setWSAAction(String URI) {
        this.msgContext.setWSAAction(URI);
    }

    public String getWSAAction() {
        return this.msgContext.getWSAAction();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public Object getProperty(String key) {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getProperty(key);
    }

    public boolean setProperty(String key, Object val) {
        if (this.msgContext == null) {
            return false;
        }
        this.msgContext.setProperty(key, val);
        return true;
    }

    public ConfigurationContext getConfigurationContext() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getConfigurationContext();
    }

    public void setSOAPAction(String SOAPAction) {
        this.msgContext.setSoapAction(SOAPAction);
    }

    public void pause() {
        if (this.msgContext != null) {
            this.msgContext.pause();
        }
    }

    public void setPaused(boolean pause) {
        if (this.msgContext != null) {
            this.msgContext.setPaused(pause);
        }
    }

    public String getRMNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public void setRMNamespaceValue(String rmNamespaceValue) {
        this.rmNamespaceValue = rmNamespaceValue;
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmNamespaceValue)) {
            this.rmSpecVersion = "Spec_2005_02";
        } else if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmNamespaceValue)) {
            this.rmSpecVersion = "Spec_2007_02";
        }
    }

    public String getRMSpecVersion() {
        if (this.rmSpecVersion == null && this.msgContext != null && this.msgContext.getOptions() != null) {
            this.rmSpecVersion = (String)this.msgContext.getOptions().getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
        }
        return this.rmSpecVersion;
    }

    public void setFlow(int flow) {
        this.msgContext.setFLOW(flow);
    }

    public int getFlow() {
        return this.msgContext.getFLOW();
    }

    public String getGeneratedSequenceId() {
        return (String)this.msgContext.getProperty("WSRMSequenceId");
    }
}

