/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class AprEndpoint {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$tomcat$util$net$AprEndpoint == null ? (class$org$apache$tomcat$util$net$AprEndpoint = AprEndpoint.class$("org.apache.tomcat.util.net.AprEndpoint")) : class$org$apache$tomcat$util$net$AprEndpoint));
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    protected final Object threadSync = new Object();
    protected Thread acceptorThread = null;
    protected Thread pollerThread = null;
    protected Thread sendfileThread = null;
    protected Stack workers = new Stack();
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    protected int maxThreads = 60;
    protected int threadPriority = 5;
    protected int pollerSize = 768;
    protected int sendfileSize = 256;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected int firstReadTimeout = 100;
    protected int pollTime = 5000;
    protected boolean daemon = true;
    protected String name = "TP";
    protected boolean useSendfile = true;
    protected int keepAliveCount = 0;
    protected int sendfileCount = 0;
    protected Poller poller = null;
    protected Sendfile sendfile = null;
    protected String SSLEngine = "off";
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "ALL";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;
    static /* synthetic */ Class class$org$apache$tomcat$util$net$AprEndpoint;

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setPollerSize(int pollerSize) {
        this.pollerSize = pollerSize;
    }

    public int getPollerSize() {
        return this.pollerSize;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getFirstReadTimeout() {
        return this.firstReadTimeout;
    }

    public void setFirstReadTimeout(int firstReadTimeout) {
        this.firstReadTimeout = firstReadTimeout;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        this.pollTime = pollTime;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public int getSendfileCount() {
        return this.sendfileCount;
    }

    public Poller getPoller() {
        return this.poller;
    }

    public Sendfile getSendfile() {
        return this.sendfile;
    }

    public int getMaxSpareThreads() {
        return 0;
    }

    public int getMinSpareThreads() {
        return 0;
    }

    public String getSSLEngine() {
        return this.SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        this.SSLEngine = SSLEngine;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.SSLProtocol = SSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.SSLCertificateFile = SSLCertificateFile;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = SSLCertificateKeyFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.SSLCertificateChainFile = SSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.SSLCACertificatePath = SSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.SSLCACertificateFile = SSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.SSLCARevocationPath = SSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.SSLCARevocationFile = SSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.SSLVerifyClient = SSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.SSLVerifyDepth = SSLVerifyDepth;
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.curThreadsBusy;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.rootPool = Pool.create((long)0L);
        this.serverSockPool = Pool.create((long)this.rootPool);
        String addressStr = null;
        addressStr = this.address == null ? null : this.address.getHostAddress();
        long inetAddress = Address.info((String)addressStr, (int)1, (int)this.port, (int)0, (long)this.rootPool);
        this.serverSock = Socket.create((int)1, (int)0, (int)6, (long)this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet((long)this.serverSock, (int)16, (int)1);
        }
        Socket.optSet((long)this.serverSock, (int)2, (int)1);
        int ret = Socket.bind((long)this.serverSock, (long)inetAddress);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", Error.strerror((int)ret)));
        }
        ret = Socket.listen((long)this.serverSock, (int)this.backlog);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", Error.strerror((int)ret)));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet((long)this.serverSock, (int)16, (int)1);
        }
        if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            log.warn((Object)sm.getString("endpoint.sendfile.nosupport"));
            this.useSendfile = false;
        }
        Socket.optSet((long)this.serverSock, (int)32768, (int)1);
        if (!"off".equalsIgnoreCase(this.SSLEngine)) {
            if ("on".equalsIgnoreCase(this.SSLEngine)) {
                SSL.initialize(null);
            } else {
                SSL.initialize((String)this.SSLEngine);
            }
            int value = 7;
            if ("SSLv2".equalsIgnoreCase(this.SSLProtocol)) {
                value = 1;
            } else if ("SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 2;
            } else if ("TLSv1".equalsIgnoreCase(this.SSLProtocol)) {
                value = 4;
            } else if ("SSLv2+SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 3;
            }
            this.sslContext = SSLContext.make((long)this.rootPool, (int)value, (int)1);
            SSLContext.setCipherSuite((long)this.sslContext, (String)this.SSLCipherSuite);
            SSLContext.setCertificate((long)this.sslContext, (String)this.SSLCertificateFile, (String)this.SSLCertificateKeyFile, (String)this.SSLPassword, (int)0);
            if (this.SSLCACertificateFile != null) {
                SSLContext.setCACertificate((long)this.sslContext, (String)this.SSLCACertificateFile, null);
            }
            value = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 3;
            }
            SSLContext.setVerify((long)this.sslContext, (int)value, (int)this.SSLVerifyDepth);
            this.useSendfile = false;
        }
        this.initialized = true;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor");
            this.acceptorThread.setPriority(this.getThreadPriority());
            this.acceptorThread.setDaemon(true);
            this.acceptorThread.start();
            this.poller = new Poller();
            this.poller.init();
            this.pollerThread = new Thread((Runnable)this.poller, this.getName() + "-Poller");
            this.pollerThread.setPriority(this.getThreadPriority());
            this.pollerThread.setDaemon(true);
            this.pollerThread.start();
            if (this.useSendfile) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                this.sendfileThread = new Thread((Runnable)this.sendfile, this.getName() + "-Sendfile");
                this.sendfileThread.setPriority(this.getThreadPriority());
                this.sendfileThread.setDaemon(true);
                this.sendfileThread.start();
            }
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            this.poller.destroy();
            if (this.useSendfile) {
                this.sendfile.destroy();
            }
            this.acceptorThread = null;
            this.pollerThread = null;
            this.sendfileThread = null;
        }
    }

    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        Pool.destroy((long)this.serverSockPool);
        this.serverSockPool = 0L;
        Socket.close((long)this.serverSock);
        this.serverSock = 0L;
        this.sslContext = 0L;
        Pool.destroy((long)this.rootPool);
        this.rootPool = 0L;
        this.initialized = false;
    }

    protected int getSequence() {
        return this.sequence++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unlockAccept() {
        java.net.Socket s;
        block10: {
            s = null;
            if (this.address == null) {
                s = new java.net.Socket("127.0.0.1", this.port);
                break block10;
            }
            s = new java.net.Socket(this.address, this.port);
            s.setSoLinger(true, 0);
        }
        Object var4_2 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.unlock", "" + this.port), (Throwable)e);
                }
                Object var4_3 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean setSocketOptions(long socket) {
        int step = 1;
        try {
            if (this.soLinger >= 0) {
                Socket.optSet((long)socket, (int)1, (int)this.soLinger);
            }
            if (this.tcpNoDelay) {
                Socket.optSet((long)socket, (int)512, (int)(this.tcpNoDelay ? 1 : 0));
            }
            if (this.soTimeout > 0) {
                Socket.timeoutSet((long)socket, (long)(this.soTimeout * 1000));
            }
            step = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach((long)this.sslContext, (long)socket);
                if (SSLSocket.handshake((long)socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
            }
        }
        catch (Throwable t) {
            if (step == 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), t);
                }
            } else {
                log.error((Object)sm.getString("endpoint.err.unexpected"), t);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        Stack stack = this.workers;
        synchronized (stack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return (Worker)this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        Worker workerThread = this.createWorkerThread();
        while (workerThread == null) {
            try {
                Stack stack = this.workers;
                synchronized (stack) {
                    this.workers.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            workerThread = this.createWorkerThread();
        }
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        Stack stack = this.workers;
        synchronized (stack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Handler {
        public boolean process(long var1);
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap sendfileData;
        protected ArrayList addS;

        protected void init() {
            this.pool = Pool.create((long)AprEndpoint.this.serverSockPool);
            try {
                this.sendfilePollset = Poll.create((int)AprEndpoint.this.sendfileSize, (long)this.pool, (int)0, (long)(AprEndpoint.this.soTimeout * 1000));
            }
            catch (Error e) {
                if (Status.APR_STATUS_IS_EINVAL((int)e.getError())) {
                    try {
                        AprEndpoint.this.sendfileSize = 62;
                        this.sendfilePollset = Poll.create((int)AprEndpoint.this.sendfileSize, (long)this.pool, (int)0, (long)(AprEndpoint.this.soTimeout * 1000));
                        log.warn((Object)sm.getString("endpoint.poll.limitedpollsize"));
                    }
                    catch (Error err) {
                        log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
                    }
                }
                log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
            }
            this.desc = new long[AprEndpoint.this.sendfileSize * 2];
            this.sendfileData = new HashMap(AprEndpoint.this.sendfileSize);
            this.addS = new ArrayList();
        }

        protected void destroy() {
            for (int i = this.addS.size() - 1; i >= 0; --i) {
                SendfileData data = (SendfileData)this.addS.get(i);
                Socket.destroy((long)data.socket);
            }
            int rv = Poll.pollset((long)this.sendfilePollset, (long[])this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    Socket.destroy((long)this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy((long)this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SendfileData data) {
            block8: {
                try {
                    data.fdpool = Socket.pool((long)data.socket);
                    data.fd = File.open((String)data.fileName, (int)4129, (int)0, (long)data.fdpool);
                    data.pos = data.start;
                    Socket.timeoutSet((long)data.socket, (long)0L);
                    do {
                        long nw;
                        if ((nw = Socket.sendfilen((long)data.socket, (long)data.fd, (long)data.pos, (long)(data.end - data.pos), (int)0)) < 0L) {
                            if (-nw != 120002L) {
                                Socket.destroy((long)data.socket);
                                data.socket = 0L;
                                return false;
                            }
                            break block8;
                        }
                        data.pos += nw;
                    } while (data.pos < data.end);
                    Pool.destroy((long)data.fdpool);
                    Socket.timeoutSet((long)data.socket, (long)(AprEndpoint.this.soTimeout * 1000));
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("endpoint.sendfile.error"), (Throwable)e);
                    return false;
                }
            }
            ArrayList arrayList = this.addS;
            synchronized (arrayList) {
                this.addS.add(data);
                this.addS.notify();
            }
            return false;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove((long)this.sendfilePollset, (long)data.socket);
            if (rv == 0) {
                --AprEndpoint.this.sendfileCount;
            }
            this.sendfileData.remove(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AprEndpoint.this.running) {
                ArrayList e3;
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                while (AprEndpoint.this.sendfileCount < 1 && this.addS.size() < 1) {
                    try {
                        e3 = this.addS;
                        synchronized (e3) {
                            this.addS.wait();
                        }
                    }
                    catch (InterruptedException e3) {
                    }
                }
                try {
                    int rv;
                    if (this.addS.size() > 0) {
                        e3 = this.addS;
                        synchronized (e3) {
                            for (int i = this.addS.size() - 1; i >= 0; --i) {
                                SendfileData data = (SendfileData)this.addS.get(i);
                                int rv2 = Poll.add((long)this.sendfilePollset, (long)data.socket, (int)4);
                                if (rv2 == 0) {
                                    this.sendfileData.put(new Long(data.socket), data);
                                    ++AprEndpoint.this.sendfileCount;
                                    continue;
                                }
                                log.warn((Object)sm.getString("endpoint.sendfile.addfail", "" + rv2));
                                Socket.destroy((long)data.socket);
                            }
                            this.addS.clear();
                        }
                    }
                    if ((rv = Poll.poll((long)this.sendfilePollset, (long)AprEndpoint.this.pollTime, (long[])this.desc, (boolean)false)) > 0) {
                        for (int n = 0; n < rv; ++n) {
                            SendfileData state = (SendfileData)this.sendfileData.get(new Long(this.desc[n * 2 + 1]));
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove(state);
                                Socket.destroy((long)state.socket);
                                continue;
                            }
                            long nw = Socket.sendfilen((long)state.socket, (long)state.fd, (long)state.pos, (long)(state.end - state.pos), (int)0);
                            if (nw < 0L) {
                                this.remove(state);
                                Socket.destroy((long)state.socket);
                                continue;
                            }
                            state.pos += nw;
                            if (state.pos < state.end) continue;
                            this.remove(state);
                            if (state.keepAlive) {
                                Pool.destroy((long)state.fdpool);
                                Socket.timeoutSet((long)state.socket, (long)(AprEndpoint.this.soTimeout * 1000));
                                AprEndpoint.this.getWorkerThread().assign(state.socket);
                                continue;
                            }
                            Socket.destroy((long)state.socket);
                        }
                        continue;
                    }
                    if (rv >= 0) continue;
                    if (-rv == 120001) {
                        rv = 0;
                        continue;
                    }
                    log.error((Object)sm.getString("endpoint.poll.fail", Error.strerror((int)(-rv))));
                    Sendfile sendfile = this;
                    synchronized (sendfile) {
                        this.destroy();
                        this.init();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.poll.error"), t);
                }
            }
            Object object = AprEndpoint.this.threadSync;
            synchronized (object) {
                AprEndpoint.this.threadSync.notifyAll();
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public boolean keepAlive;
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected long socket = 0L;

        protected Worker() {
        }

        protected synchronized void assign(long socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized long await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            long socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AprEndpoint.this.running) {
                long socket = this.await();
                if (socket == 0L) continue;
                if (!AprEndpoint.this.handler.process(socket)) {
                    Socket.destroy((long)socket);
                    socket = 0L;
                }
                AprEndpoint.this.recycleWorkerThread(this);
            }
            Worker worker = this;
            synchronized (worker) {
                AprEndpoint.this.threadSync.notifyAll();
            }
        }

        public void start() {
            this.thread = new ThreadWithAttributes(AprEndpoint.this, (Runnable)this);
            this.thread.setName(AprEndpoint.this.getName() + "-" + ++AprEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public class Poller
    implements Runnable {
        protected long serverPollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected long[] addS;
        protected int addCount = 0;

        protected void init() {
            this.pool = Pool.create((long)AprEndpoint.this.serverSockPool);
            try {
                this.serverPollset = Poll.create((int)AprEndpoint.this.pollerSize, (long)this.pool, (int)0, (long)(AprEndpoint.this.soTimeout * 1000));
            }
            catch (Error e) {
                if (Status.APR_STATUS_IS_EINVAL((int)e.getError())) {
                    try {
                        AprEndpoint.this.pollerSize = 62;
                        this.serverPollset = Poll.create((int)AprEndpoint.this.pollerSize, (long)this.pool, (int)0, (long)(AprEndpoint.this.soTimeout * 1000));
                        log.warn((Object)sm.getString("endpoint.poll.limitedpollsize"));
                    }
                    catch (Error err) {
                        log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
                    }
                }
                log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
            }
            this.desc = new long[AprEndpoint.this.pollerSize * 2];
            AprEndpoint.this.keepAliveCount = 0;
            this.addS = new long[AprEndpoint.this.pollerSize];
            this.addCount = 0;
        }

        protected void destroy() {
            for (int i = 0; i < this.addCount; --i) {
                Socket.destroy((long)this.addS[i]);
            }
            int rv = Poll.pollset((long)this.serverPollset, (long[])this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    Socket.destroy((long)this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy((long)this.pool);
            AprEndpoint.this.keepAliveCount = 0;
            this.addCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long socket) {
            long[] lArray = this.addS;
            synchronized (this.addS) {
                if (this.addCount >= this.addS.length) {
                    Socket.destroy((long)socket);
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                this.addS[this.addCount] = socket;
                ++this.addCount;
                this.addS.notify();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            maintainTime = 0L;
            block14: while (true) {
                if (!AprEndpoint.this.running) {
                    var3_7 = AprEndpoint.this.threadSync;
                    // MONITORENTER : var3_7
                    AprEndpoint.this.threadSync.notifyAll();
                    // MONITOREXIT : var3_7
                    return;
                }
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (AprEndpoint.this.keepAliveCount < 1 && this.addCount < 1) {
                    maintainTime = 0L;
                    try {
                        e = this.addS;
                        // MONITORENTER : this.addS
                        this.addS.wait();
                        // MONITOREXIT : e
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    if (this.addCount > 0) {
                        e = this.addS;
                        // MONITORENTER : this.addS
                        for (i = this.addCount - 1; i >= 0; --i) {
                            rv = Poll.add((long)this.serverPollset, (long)this.addS[i], (int)1);
                            if (rv == 0) {
                                ++AprEndpoint.this.keepAliveCount;
                                continue;
                            }
                            Socket.destroy((long)this.addS[i]);
                        }
                        this.addCount = 0;
                        // MONITOREXIT : e
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    rv = Poll.poll((long)this.serverPollset, (long)AprEndpoint.this.pollTime, (long[])this.desc, (boolean)true);
                    if (rv > 0) {
                        AprEndpoint.this.keepAliveCount -= rv;
                        n = 0;
                        break;
                    }
                    if (rv < 0 && -rv != 120001) {
                        AprEndpoint.log.error((Object)AprEndpoint.sm.getString("endpoint.poll.fail", Error.strerror((int)(-rv))));
                        n = this;
                        // MONITORENTER : n
                        this.destroy();
                        this.init();
                        // MONITOREXIT : n
                    }
                    while (true) {
                        if (AprEndpoint.this.soTimeout <= 0 || maintainTime <= 1000000L) continue block14;
                        rv = Poll.maintain((long)this.serverPollset, (long[])this.desc, (boolean)true);
                        maintainTime = 0L;
                        if (rv <= 0) continue block14;
                        AprEndpoint.this.keepAliveCount -= rv;
                        n = 0;
                        while (true) {
                            if (n >= rv) continue block14;
                            Socket.destroy((long)this.desc[n]);
                            ++n;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    AprEndpoint.log.error((Object)AprEndpoint.sm.getString("endpoint.poll.error"), t);
                    continue;
                }
                break;
            }
            while (true) {
                if (n >= rv) ** continue;
                if ((this.desc[n * 2] & 32L) == 32L || (this.desc[n * 2] & 16L) == 16L) {
                    Socket.destroy((long)this.desc[n * 2 + 1]);
                } else {
                    AprEndpoint.this.getWorkerThread().assign(this.desc[n * 2 + 1]);
                }
                ++n;
            }
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                Worker workerThread = AprEndpoint.this.getWorkerThread();
                try {
                    long socket = Socket.accept((long)AprEndpoint.this.serverSock);
                    if (AprEndpoint.this.setSocketOptions(socket)) {
                        workerThread.assign(socket);
                        continue;
                    }
                    Socket.destroy((long)socket);
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("endpoint.accept.fail"), (Throwable)e);
                }
            }
            Object object = AprEndpoint.this.threadSync;
            synchronized (object) {
                AprEndpoint.this.threadSync.notifyAll();
            }
        }
    }
}

