/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.wsdl.converter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.wtp.ext.validate.service.util.WSASUoloadServiceRequestUtil;
import org.wso2.wsf.ide.wtp.ext.wsdl.converter.AbstractWSDLConverterWizardPage;
import org.wso2.wsf.ide.wtp.ext.wsdl.converter.WSASWSDLConverterPage;
import org.wso2.wsf.ide.wtp.ext.wsdl.converter.WSASWSDLConverterPlugin;
import org.wso2.wsf.ide.wtp.ext.wsdl.converter.WSASWSDLConverterResultPage;

public class WSASWSDLConverterWizard
extends Wizard
implements INewWizard {
    WSASUoloadServiceRequestUtil util = WSASUoloadServiceRequestUtil.getInstance();
    WSASWSDLConverterPage wsdlConverterPage;
    WSASWSDLConverterResultPage wsdlConverterResultPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public WSASWSDLConverterWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WSASWSDLConverterPlugin.getResourceString("main.header"));
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        AbstractWSDLConverterWizardPage wizardPage = null;
        for (int i = 0; i < pages.length; ++i) {
            wizardPage = (AbstractWSDLConverterWizardPage)pages[i];
            if (wizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractWSDLConverterWizardPage thisPage = (AbstractWSDLConverterWizardPage)page;
        AbstractWSDLConverterWizardPage nextPage = (AbstractWSDLConverterWizardPage)super.getNextPage(page);
        while (thisPage != null && thisPage.isSkipNext() && nextPage != null) {
            thisPage = nextPage;
            nextPage = (AbstractWSDLConverterWizardPage)super.getNextPage((IWizardPage)nextPage);
        }
        if (WSASWSDLConverterPlugin.getDefault().isGoAheadConversion()) {
            try {
                File resourceFile = null;
                String path = this.wsdlConverterPage.getWSDLPathText();
                if (path != null && !path.equals("")) {
                    resourceFile = new File(path);
                }
                URL resultURL = new URL(WSASCoreUIMessages.LOCAL_SERVER_PORT + this.goAheadConversion(resourceFile));
                WSASWSDLConverterPlugin.getDefault().setValidateURL(resultURL);
                this.wsdlConverterResultPage.fillBrowserWithResults();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return nextPage;
    }

    public void addPages() {
        this.wsdlConverterPage = new WSASWSDLConverterPage();
        this.addPage((IWizardPage)this.wsdlConverterPage);
        this.wsdlConverterResultPage = new WSASWSDLConverterResultPage();
        this.addPage((IWizardPage)this.wsdlConverterResultPage);
    }

    public boolean performFinish() {
        if (this.wsdlConverterResultPage.getBrowserPopUpCheck()) {
            this.util.popupInternalBrowser(WSASWSDLConverterPlugin.getDefault().getValidateURL());
        }
        return true;
    }

    private String goAheadConversion(File resourceFile) {
        return this.util.requestValidate(resourceFile, this.wsdlConverterPage.getFileType());
    }
}

