/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.wsdl.converter;

import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.wso2.wsf.ide.wtp.ext.server.bean.WSASConfigurationBean;
import org.wso2.wsf.ide.wtp.ext.server.constant.WSASMessageConstant;
import org.wso2.wsf.ide.wtp.ext.validate.service.util.WSASUoloadServiceRequestUtil;
import org.wso2.wsf.ide.wtp.ext.wsdl.converter.AbstractWSDLConverterWizardPage;
import org.wso2.wsf.ide.wtp.ext.wsdl.converter.WSASWSDLConverterPlugin;

public class WSASWSDLConverterPage
extends AbstractWSDLConverterWizardPage {
    Text wsdlPathText;
    String fileType;
    Button wsdlBrowseButton;

    public WSASWSDLConverterPage() {
        super("page1");
    }

    protected void initializeDefaultSettings() {
    }

    public void createControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridLayout lo = new GridLayout(1, true);
        container.setLayout((Layout)lo);
        Group wsdlGroup = new Group(container, 0);
        wsdlGroup.setText("Please upload your WSDL 1.1");
        GridLayout layout = new GridLayout();
        layout.numColumns = 14;
        wsdlGroup.setLayout((Layout)layout);
        GridData gd = new GridData(784);
        wsdlGroup.setLayoutData((Object)gd);
        this.wsdlPathText = new Text((Composite)wsdlGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 13;
        this.wsdlPathText.setLayoutData((Object)gd);
        this.wsdlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.wsdlBrowseButton = new Button((Composite)wsdlGroup, 0);
        this.wsdlBrowseButton.setText("Upload");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.wsdlBrowseButton.setLayoutData((Object)gd);
        this.wsdlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASWSDLConverterPage.this.handleBrowse(container);
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)container);
        if (!WSASConfigurationBean.isWsasCorrectPathSet() || !WSASConfigurationBean.isWsasStartStatus()) {
            this.updateStatus(WSASMessageConstant.WARNING_WSAS_NOT_STARTED);
            this.toggleControls(false);
        } else {
            this.toggleControls(true);
        }
        if (this.restoredFromPreviousSettings) {
            this.handleModify();
        }
    }

    private void handleModify() {
    }

    public boolean getWizardComplete() {
        return false;
    }

    private void handleBrowse(Composite parent) {
        WSASUoloadServiceRequestUtil uploadUtil = WSASUoloadServiceRequestUtil.getInstance();
        uploadUtil.reset();
        FileDialog fileDialog = new FileDialog(parent.getShell());
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.wsdlPathText.setText(fileName);
            this.updateStatus(null);
            Path filePath = new Path(fileName);
            this.setFileType(filePath.getFileExtension());
            if (fileName.endsWith(".wsdl") || fileName.endsWith(".xml")) {
                WSASWSDLConverterPlugin.getDefault().setGoAheadConvertion(true);
                uploadUtil.setWSDL(true);
            } else {
                this.updateStatus("File Type Invalid !!, Valid Types {aar,zip,jar,xml'}");
            }
        }
    }

    public String getWSDLPathText() {
        return this.wsdlPathText.getText();
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    private void toggleControls(boolean toggleValue) {
        this.wsdlPathText.setEnabled(toggleValue);
        this.wsdlBrowseButton.setEnabled(toggleValue);
    }
}

