/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.validate.service.util;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.wso2.wsf.ide.wtp.ext.server.command.WTPInternalBrowserCommand;
import org.wso2.wsf.ide.wtp.ext.server.constant.WSASMessageConstant;

public class WSASUoloadServiceRequestUtil {
    private static WSASUoloadServiceRequestUtil instance;
    private DataHandler dh;
    private SOAPConnection connection;
    private SOAPFactory soapFactory;
    private boolean isXml;
    private boolean isArchive;
    private boolean isService;
    private boolean isModule;
    private boolean isWSDL;
    private boolean alredyInit;

    private WSASUoloadServiceRequestUtil() {
    }

    public static WSASUoloadServiceRequestUtil getInstance() {
        if (instance == null) {
            instance = new WSASUoloadServiceRequestUtil();
        }
        return instance;
    }

    private void init() {
        try {
            this.connection = SOAPConnectionFactory.newInstance().createConnection();
            this.soapFactory = SOAPFactory.newInstance();
            this.alredyInit = true;
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
    }

    public String requestValidate(File resourceFile, String fileType) {
        if (!this.alredyInit) {
            this.init();
        }
        String returnUUID = null;
        if (this.isService) {
            returnUUID = this.isXml ? this.sendUploadFileToWSAS(resourceFile, fileType, WSASMessageConstant.validateServiceEndpoint, WSASMessageConstant.serviceXMLEndOperation) : this.sendUploadFileToWSAS(resourceFile, fileType, WSASMessageConstant.validateServiceEndpoint, WSASMessageConstant.archiveEndOperation);
        } else if (this.isModule) {
            returnUUID = this.isXml ? this.sendUploadFileToWSAS(resourceFile, fileType, WSASMessageConstant.validateModuleEndpoint, WSASMessageConstant.moduleXMLEndOperation) : this.sendUploadFileToWSAS(resourceFile, fileType, WSASMessageConstant.validateModuleEndpoint, WSASMessageConstant.archiveEndOperation);
        } else if (this.isWSDL) {
            returnUUID = this.sendUploadFileToWSAS(resourceFile, fileType, WSASMessageConstant.wsdlConversionEndpoint, WSASMessageConstant.wsdlConversionEndOperation);
        }
        return returnUUID;
    }

    public void popupInternalBrowser(URL url) {
        WTPInternalBrowserCommand.popUpInrernalBrouwser(url.toString());
    }

    private String sendUploadFileToWSAS(File resourceFile, String fileType, String validateServiceEndpoint, String endOperation) {
        try {
            Iterator iterator;
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            QName uploadQName = new QName("http://org.apache.axis2/xsd", "upload", "ns");
            SOAPElement uploadElement = this.soapFactory.createElement(uploadQName);
            this.dh = new DataHandler((DataSource)new FileDataSource(resourceFile));
            AttachmentPart attachment = message.createAttachmentPart(this.dh);
            attachment.setContentId("myAttachment");
            attachment.setContentType("txt/xml");
            QName payloadQName = new QName("payload");
            SOAPElement payloadElement = this.soapFactory.createElement(payloadQName);
            QName attach = new QName("attachment");
            SOAPElement attachmentElement = this.soapFactory.createElement(attach);
            attachmentElement.setAttribute("href", "cid:" + attachment.getContentId());
            QName attachmentId = new QName("type");
            SOAPElement attachmentIdEle = this.soapFactory.createElement(attachmentId);
            attachmentIdEle.addTextNode(fileType);
            payloadElement.addChildElement(attachmentElement);
            payloadElement.addChildElement(attachmentIdEle);
            uploadElement.addChildElement(payloadElement);
            message.getSOAPBody().addChildElement(uploadElement);
            message.addAttachmentPart(attachment);
            SOAPMessage result = this.connection.call(message, (Object)WSASMessageConstant.generalServiceEndPoint);
            SOAPPart part = result.getSOAPPart();
            SOAPEnvelope envelope = part.getEnvelope();
            SOAPBody body = envelope.getBody();
            Node uploadResponse = body.getFirstChild();
            Node returnNode = uploadResponse.getFirstChild();
            String uuid = returnNode.getFirstChild().toString();
            if (!body.hasFault() && (iterator = result.getAttachments()).hasNext()) {
                this.dh = ((AttachmentPart)iterator.next()).getDataHandler();
                String fname = this.dh.getName();
            }
            if (this.isArchive) {
                // empty if block
            }
            String returnId = this.sendUUID(uuid, validateServiceEndpoint, endOperation);
            return returnId;
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String sendUUID(String uuid, String endPoint, String endOperation) {
        try {
            Iterator iterator;
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            QName uploadQName = new QName("http://org.wso2.wsf/tools", endOperation, "ns");
            SOAPElement uploadElement = this.soapFactory.createElement(uploadQName);
            QName qnameEle = new QName("fileId");
            SOAPElement attachmentIdEle = this.soapFactory.createElement(qnameEle);
            attachmentIdEle.addTextNode(uuid);
            uploadElement.addChildElement(attachmentIdEle);
            message.getSOAPBody().addChildElement(uploadElement);
            SOAPMessage result = this.connection.call(message, (Object)endPoint);
            SOAPPart part = result.getSOAPPart();
            SOAPEnvelope envelope = part.getEnvelope();
            SOAPBody body = envelope.getBody();
            if (!body.hasFault() && (iterator = result.getAttachments()).hasNext()) {
                this.dh = ((AttachmentPart)iterator.next()).getDataHandler();
                String fname = this.dh.getName();
            }
            Node uploadResponse = body.getFirstChild();
            Node returnNode = uploadResponse.getFirstChild();
            String uuid1 = returnNode.getFirstChild().toString();
            return uuid1;
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setXml(boolean isXml) {
        this.isXml = isXml;
    }

    public void setArchive(boolean isArchive) {
        this.isArchive = isArchive;
    }

    public void setService(boolean isService) {
        this.isService = isService;
    }

    public void setModule(boolean isModule) {
        this.isModule = isModule;
    }

    public void reset() {
        this.isModule = false;
        this.isService = false;
        this.isXml = false;
        this.isArchive = false;
        this.isWSDL = false;
    }

    public void setWSDL(boolean isWSDL) {
        this.isWSDL = isWSDL;
    }
}

