/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.validate.service;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.wtp.ext.validate.service.AbstractArchiveValidateWizardPage;
import org.wso2.wsf.ide.wtp.ext.validate.service.WSASArchiveResultPage;
import org.wso2.wsf.ide.wtp.ext.validate.service.WSASArchiveValidatePage;
import org.wso2.wsf.ide.wtp.ext.validate.service.WSASArchiveValidatePlugin;
import org.wso2.wsf.ide.wtp.ext.validate.service.util.WSASUoloadServiceRequestUtil;

public class WSASArchiveValidaterWizard
extends Wizard
implements INewWizard {
    WSASUoloadServiceRequestUtil util = WSASUoloadServiceRequestUtil.getInstance();
    WSASArchiveValidatePage archiveValidatePage;
    WSASArchiveResultPage archiveResultPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public WSASArchiveValidaterWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WSASArchiveValidatePlugin.getResourceString("main.header"));
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        AbstractArchiveValidateWizardPage wizardPage = null;
        for (int i = 0; i < pages.length; ++i) {
            wizardPage = (AbstractArchiveValidateWizardPage)pages[i];
            if (wizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractArchiveValidateWizardPage thisPage = (AbstractArchiveValidateWizardPage)page;
        AbstractArchiveValidateWizardPage nextPage = (AbstractArchiveValidateWizardPage)super.getNextPage(page);
        while (thisPage != null && thisPage.isSkipNext() && nextPage != null) {
            thisPage = nextPage;
            nextPage = (AbstractArchiveValidateWizardPage)super.getNextPage((IWizardPage)nextPage);
        }
        if (WSASArchiveValidatePlugin.getDefault().isGoAheadValidation()) {
            try {
                File resourceFile = null;
                if (this.archiveValidatePage.getAarPathEnabled()) {
                    resourceFile = new File(this.archiveValidatePage.getAarPathText());
                }
                if (this.archiveValidatePage.getServicesXMlPathEnabled()) {
                    resourceFile = new File(this.archiveValidatePage.getServicesXMlPathText());
                }
                URL resultURL = new URL(WSASCoreUIMessages.LOCAL_SERVER_PORT + this.goAheadVelidation(resourceFile));
                WSASArchiveValidatePlugin.getDefault().setValidateURL(resultURL);
                this.archiveResultPage.fillBrowserWithResults();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return nextPage;
    }

    public void addPages() {
        this.archiveValidatePage = new WSASArchiveValidatePage();
        this.addPage((IWizardPage)this.archiveValidatePage);
        this.archiveResultPage = new WSASArchiveResultPage();
        this.addPage((IWizardPage)this.archiveResultPage);
    }

    public boolean performFinish() {
        if (this.archiveResultPage.getBrowserPopUpCheck()) {
            this.util.popupInternalBrowser(WSASArchiveValidatePlugin.getDefault().getValidateURL());
        }
        return true;
    }

    private String goAheadVelidation(File resourceFile) {
        return this.util.requestValidate(resourceFile, this.archiveValidatePage.getFileType());
    }
}

