/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.validate.service;

import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.wso2.wsf.ide.wtp.ext.server.bean.WSASConfigurationBean;
import org.wso2.wsf.ide.wtp.ext.server.constant.WSASMessageConstant;
import org.wso2.wsf.ide.wtp.ext.validate.service.AbstractArchiveValidateWizardPage;
import org.wso2.wsf.ide.wtp.ext.validate.service.WSASArchiveValidatePlugin;
import org.wso2.wsf.ide.wtp.ext.validate.service.util.WSASUoloadServiceRequestUtil;

public class WSASArchiveValidatePage
extends AbstractArchiveValidateWizardPage {
    Text servicesXMlPathText;
    Text aarPathText;
    String fileType;
    Button validateAARBrowseButton;
    Button validateServicesXmlBrowseButton;
    Button validateAARRadioButton;
    Button validateServicesXmlRadioButton;

    public WSASArchiveValidatePage() {
        super("page1");
    }

    protected void initializeDefaultSettings() {
    }

    public void createControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 14;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(784);
        container.setLayoutData((Object)gd);
        this.validateAARRadioButton = new Button(container, 16);
        this.validateAARRadioButton.setText("Select AAR (Service Archive)");
        gd = new GridData();
        gd.horizontalSpan = 14;
        this.validateAARRadioButton.setLayoutData((Object)gd);
        this.validateAARRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASArchiveValidatePage.this.setPathVisible(WSASArchiveValidatePage.this.servicesXMlPathText, false);
                WSASArchiveValidatePage.this.setPathVisible(WSASArchiveValidatePage.this.aarPathText, true);
                WSASArchiveValidatePage.this.toggleValidateAAR(true);
            }
        });
        this.aarPathText = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 13;
        this.aarPathText.setLayoutData((Object)gd);
        this.aarPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.validateAARBrowseButton = new Button(container, 0);
        this.validateAARBrowseButton.setText("Browse");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.validateAARBrowseButton.setLayoutData((Object)gd);
        this.validateAARBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASArchiveValidatePage.this.handleBrowse(container, WSASArchiveValidatePage.this.aarPathText);
            }
        });
        Label separator = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setText(" ");
        separator.setLayoutData((Object)gd);
        this.validateServicesXmlRadioButton = new Button(container, 16);
        this.validateServicesXmlRadioButton.setText("Select Services.xml");
        gd = new GridData();
        gd.horizontalSpan = 14;
        this.validateServicesXmlRadioButton.setLayoutData((Object)gd);
        this.validateServicesXmlRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASArchiveValidatePage.this.setPathVisible(WSASArchiveValidatePage.this.servicesXMlPathText, true);
                WSASArchiveValidatePage.this.setPathVisible(WSASArchiveValidatePage.this.aarPathText, false);
                WSASArchiveValidatePage.this.toggleValidateServicesXml(true);
            }
        });
        this.servicesXMlPathText = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 13;
        this.servicesXMlPathText.setLayoutData((Object)gd);
        this.servicesXMlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.validateServicesXmlBrowseButton = new Button(container, 0);
        this.validateServicesXmlBrowseButton.setText("Browse");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.validateServicesXmlBrowseButton.setLayoutData((Object)gd);
        this.validateServicesXmlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASArchiveValidatePage.this.handleBrowse(container, WSASArchiveValidatePage.this.servicesXMlPathText);
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)container);
        if (!WSASConfigurationBean.isWsasCorrectPathSet() || !WSASConfigurationBean.isWsasStartStatus()) {
            this.updateStatus(WSASMessageConstant.WARNING_WSAS_NOT_STARTED);
            this.toggleControls(false);
        } else {
            this.toggleControls(true);
            this.toggleValidateAAR(true);
            this.setPathVisible(this.servicesXMlPathText, false);
            this.setPathVisible(this.aarPathText, true);
        }
        if (this.restoredFromPreviousSettings) {
            this.handleModify();
        }
    }

    private void handleModify() {
    }

    public boolean getWizardComplete() {
        return false;
    }

    private void handleBrowse(Composite parent, Text pathText) {
        WSASUoloadServiceRequestUtil uploadUtil = WSASUoloadServiceRequestUtil.getInstance();
        uploadUtil.reset();
        uploadUtil.setService(true);
        FileDialog fileDialog = new FileDialog(parent.getShell());
        String fileName = fileDialog.open();
        if (fileName != null) {
            pathText.setText(fileName);
            this.updateStatus(null);
            Path filePath = new Path(fileName);
            this.setFileType(filePath.getFileExtension());
            if (fileName.endsWith(".zip") || fileName.endsWith(".jar") || fileName.endsWith(".aar")) {
                WSASArchiveValidatePlugin.getDefault().setGoAheadValidation(true);
                uploadUtil.setArchive(true);
            } else if (fileName.endsWith(".xml")) {
                WSASArchiveValidatePlugin.getDefault().setGoAheadValidation(true);
                uploadUtil.setXml(true);
            } else {
                this.updateStatus("File Type Invalid !!, Valid Types {aar,zip,jar,xml'}");
            }
        }
    }

    public void updateWizardPageStatus(String message) {
        this.updateStatus(message);
    }

    public String getServicesXMlPathText() {
        return this.servicesXMlPathText.getText();
    }

    public String getAarPathText() {
        return this.aarPathText.getText();
    }

    public boolean getServicesXMlPathEnabled() {
        return this.servicesXMlPathText.getEnabled();
    }

    public boolean getAarPathEnabled() {
        return this.aarPathText.getEnabled();
    }

    public void setPathVisible(Text pathComponemt, boolean value) {
        pathComponemt.setEditable(value);
        pathComponemt.setEnabled(value);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    private void toggleControls(boolean toggleValue) {
        this.setPathVisible(this.aarPathText, toggleValue);
        this.setPathVisible(this.servicesXMlPathText, toggleValue);
        this.validateAARBrowseButton.setEnabled(toggleValue);
        this.validateServicesXmlBrowseButton.setEnabled(toggleValue);
        this.validateAARRadioButton.setEnabled(toggleValue);
        this.validateServicesXmlRadioButton.setEnabled(toggleValue);
    }

    private void toggleValidateAAR(boolean toggleValue) {
        this.validateServicesXmlBrowseButton.setEnabled(!toggleValue);
        this.validateAARBrowseButton.setEnabled(toggleValue);
        this.validateServicesXmlRadioButton.setSelection(!toggleValue);
        this.servicesXMlPathText.clearSelection();
        this.validateAARRadioButton.setSelection(toggleValue);
    }

    private void toggleValidateServicesXml(boolean toggleValue) {
        this.validateServicesXmlBrowseButton.setEnabled(toggleValue);
        this.validateAARBrowseButton.setEnabled(!toggleValue);
        this.validateAARRadioButton.setSelection(!toggleValue);
        this.aarPathText.clearSelection();
        this.validateServicesXmlRadioButton.setSelection(toggleValue);
    }
}

