/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.validate.module;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.wtp.ext.validate.module.AbstractModuleValidateWizardPage;
import org.wso2.wsf.ide.wtp.ext.validate.module.WSASModuleResultPage;
import org.wso2.wsf.ide.wtp.ext.validate.module.WSASModuleValidatePage;
import org.wso2.wsf.ide.wtp.ext.validate.module.WSASModuleValidatePlugin;
import org.wso2.wsf.ide.wtp.ext.validate.service.util.WSASUoloadServiceRequestUtil;

public class WSASModuleValidaterWizard
extends Wizard
implements INewWizard {
    WSASUoloadServiceRequestUtil util = WSASUoloadServiceRequestUtil.getInstance();
    WSASModuleValidatePage moduleValidatePage;
    WSASModuleResultPage moduleResultPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public WSASModuleValidaterWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WSASModuleValidatePlugin.getResourceString("main.header"));
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        AbstractModuleValidateWizardPage wizardPage = null;
        for (int i = 0; i < pages.length; ++i) {
            wizardPage = (AbstractModuleValidateWizardPage)pages[i];
            if (wizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractModuleValidateWizardPage thisPage = (AbstractModuleValidateWizardPage)page;
        AbstractModuleValidateWizardPage nextPage = (AbstractModuleValidateWizardPage)super.getNextPage(page);
        while (thisPage != null && thisPage.isSkipNext() && nextPage != null) {
            thisPage = nextPage;
            nextPage = (AbstractModuleValidateWizardPage)super.getNextPage((IWizardPage)nextPage);
        }
        if (WSASModuleValidatePlugin.getDefault().isGoAheadValidation()) {
            try {
                File resourceFile = null;
                if (this.moduleValidatePage.getMarPathEnabled()) {
                    resourceFile = new File(this.moduleValidatePage.getMarPathText());
                }
                if (this.moduleValidatePage.getModuleXMlPathEnabled()) {
                    resourceFile = new File(this.moduleValidatePage.getModuleXMlPathText());
                }
                URL resultURL = new URL(WSASCoreUIMessages.LOCAL_SERVER_PORT + this.goAheadVelidation(resourceFile));
                WSASModuleValidatePlugin.getDefault().setValidateURL(resultURL);
                this.moduleResultPage.fillBrowserWithResults();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return nextPage;
    }

    public void addPages() {
        this.moduleValidatePage = new WSASModuleValidatePage();
        this.addPage((IWizardPage)this.moduleValidatePage);
        this.moduleResultPage = new WSASModuleResultPage();
        this.addPage((IWizardPage)this.moduleResultPage);
    }

    public boolean performFinish() {
        if (this.moduleResultPage.getBrowserPopUpCheck()) {
            this.util.popupInternalBrowser(WSASModuleValidatePlugin.getDefault().getValidateURL());
        }
        return true;
    }

    private String goAheadVelidation(File resourceFile) {
        return this.util.requestValidate(resourceFile, this.moduleValidatePage.getFileType());
    }
}

