/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.validate.module;

import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.wso2.wsf.ide.wtp.ext.server.bean.WSASConfigurationBean;
import org.wso2.wsf.ide.wtp.ext.server.constant.WSASMessageConstant;
import org.wso2.wsf.ide.wtp.ext.validate.module.AbstractModuleValidateWizardPage;
import org.wso2.wsf.ide.wtp.ext.validate.module.WSASModuleValidatePlugin;
import org.wso2.wsf.ide.wtp.ext.validate.service.util.WSASUoloadServiceRequestUtil;

public class WSASModuleValidatePage
extends AbstractModuleValidateWizardPage {
    Text moduleXMlPathText;
    Text marPathText;
    String fileType;
    Button validateMARBrowseButton;
    Button validateModuleXmlBrowseButton;
    Button validateMARRadioButton;
    Button validateModuleXmlRadioButton;

    public WSASModuleValidatePage() {
        super("page1");
    }

    protected void initializeDefaultSettings() {
    }

    public void createControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 14;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(784);
        container.setLayoutData((Object)gd);
        this.validateMARRadioButton = new Button(container, 16);
        this.validateMARRadioButton.setText("Select MAR (Module Archive)");
        gd = new GridData();
        gd.horizontalSpan = 14;
        this.validateMARRadioButton.setLayoutData((Object)gd);
        this.validateMARRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASModuleValidatePage.this.setPathVisible(WSASModuleValidatePage.this.moduleXMlPathText, false);
                WSASModuleValidatePage.this.setPathVisible(WSASModuleValidatePage.this.marPathText, true);
                WSASModuleValidatePage.this.toggleValidateMAR(true);
            }
        });
        this.marPathText = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 13;
        this.marPathText.setLayoutData((Object)gd);
        this.marPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.validateMARBrowseButton = new Button(container, 0);
        this.validateMARBrowseButton.setText("Browse");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.validateMARBrowseButton.setLayoutData((Object)gd);
        this.validateMARBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASModuleValidatePage.this.handleBrowse(container, WSASModuleValidatePage.this.marPathText);
            }
        });
        Label separator = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setText(" ");
        separator.setLayoutData((Object)gd);
        this.validateModuleXmlRadioButton = new Button(container, 16);
        this.validateModuleXmlRadioButton.setText("Select Module.xml");
        gd = new GridData();
        gd.horizontalSpan = 14;
        this.validateModuleXmlRadioButton.setLayoutData((Object)gd);
        this.validateModuleXmlRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASModuleValidatePage.this.setPathVisible(WSASModuleValidatePage.this.moduleXMlPathText, true);
                WSASModuleValidatePage.this.setPathVisible(WSASModuleValidatePage.this.marPathText, false);
                WSASModuleValidatePage.this.toggleValidateModuleXml(true);
            }
        });
        this.moduleXMlPathText = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 13;
        this.moduleXMlPathText.setLayoutData((Object)gd);
        this.moduleXMlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.validateModuleXmlBrowseButton = new Button(container, 0);
        this.validateModuleXmlBrowseButton.setText("Browse");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.validateModuleXmlBrowseButton.setLayoutData((Object)gd);
        this.validateModuleXmlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSASModuleValidatePage.this.handleBrowse(container, WSASModuleValidatePage.this.moduleXMlPathText);
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)container);
        if (!WSASConfigurationBean.isWsasCorrectPathSet() || !WSASConfigurationBean.isWsasStartStatus()) {
            this.updateStatus(WSASMessageConstant.WARNING_WSAS_NOT_STARTED);
            this.toggleControls(false);
        } else {
            this.toggleControls(true);
            this.toggleValidateMAR(true);
            this.setPathVisible(this.moduleXMlPathText, false);
            this.setPathVisible(this.marPathText, true);
        }
        if (this.restoredFromPreviousSettings) {
            this.handleModify();
        }
    }

    private void handleModify() {
    }

    public boolean getWizardComplete() {
        return false;
    }

    private void handleBrowse(Composite parent, Text pathText) {
        WSASUoloadServiceRequestUtil uploadUtil = WSASUoloadServiceRequestUtil.getInstance();
        uploadUtil.reset();
        uploadUtil.setModule(true);
        FileDialog fileDialog = new FileDialog(parent.getShell());
        String fileName = fileDialog.open();
        if (fileName != null) {
            pathText.setText(fileName);
            this.updateStatus(null);
            Path filePath = new Path(fileName);
            this.setFileType(filePath.getFileExtension());
            if (fileName.endsWith(".zip") || fileName.endsWith(".jar") || fileName.endsWith(".mar")) {
                WSASModuleValidatePlugin.getDefault().setGoAheadValidation(true);
                uploadUtil.setModule(true);
            } else if (fileName.endsWith(".xml")) {
                WSASModuleValidatePlugin.getDefault().setGoAheadValidation(true);
                uploadUtil.setXml(true);
            } else {
                this.updateStatus("File Type Invalid !!, Valid Types {mar,zip,jar,xml'}");
            }
        }
    }

    public void updateWizardPageStatus(String message) {
        this.updateStatus(message);
    }

    public String getModuleXMlPathText() {
        return this.moduleXMlPathText.getText();
    }

    public String getMarPathText() {
        return this.marPathText.getText();
    }

    public boolean getModuleXMlPathEnabled() {
        return this.moduleXMlPathText.getEnabled();
    }

    public boolean getMarPathEnabled() {
        return this.marPathText.getEnabled();
    }

    public void setPathVisible(Text pathComponemt, boolean value) {
        pathComponemt.setEditable(value);
        pathComponemt.setEnabled(value);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    private void toggleControls(boolean toggleValue) {
        this.setPathVisible(this.moduleXMlPathText, toggleValue);
        this.setPathVisible(this.marPathText, toggleValue);
        this.validateModuleXmlBrowseButton.setEnabled(toggleValue);
        this.validateMARBrowseButton.setEnabled(toggleValue);
        this.validateMARRadioButton.setEnabled(toggleValue);
        this.validateModuleXmlRadioButton.setEnabled(toggleValue);
    }

    private void toggleValidateMAR(boolean toggleValue) {
        this.validateModuleXmlBrowseButton.setEnabled(!toggleValue);
        this.validateMARBrowseButton.setEnabled(toggleValue);
        this.validateModuleXmlRadioButton.setSelection(!toggleValue);
        this.moduleXMlPathText.clearSelection();
        this.validateMARRadioButton.setSelection(toggleValue);
    }

    private void toggleValidateModuleXml(boolean toggleValue) {
        this.validateModuleXmlBrowseButton.setEnabled(toggleValue);
        this.validateMARBrowseButton.setEnabled(!toggleValue);
        this.validateModuleXmlRadioButton.setSelection(toggleValue);
        this.marPathText.clearSelection();
        this.validateMARRadioButton.setSelection(!toggleValue);
    }
}

