/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.server.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.wso2.wsf.ide.wtp.ext.server.bean.WSASConfigurationBean;
import org.wso2.wsf.ide.wtp.ext.server.command.WSASStartCommand;
import org.wso2.wsf.ide.wtp.ext.server.command.WTPInternalBrowserCommand;
import org.wso2.wsf.ide.wtp.ext.server.constant.WSASMessageConstant;
import org.wso2.wsf.ide.wtp.ext.server.monitor.WSASUpMonitorThread;
import org.wso2.wsf.ide.wtp.ext.server.util.WSASUtils;

public class WSASStartMenuDelegate
extends ActionDelegate
implements IWorkbenchWindowPulldownDelegate {
    MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    private IStatus status;
    private final long interval = 1000L;
    private Shell shell = null;

    public void run(IAction action) {
        WSASConfigurationBean.Init();
        if (!WSASConfigurationBean.isWsasCorrectPathSet()) {
            this.box.setMessage(WSASMessageConstant.WARNING_WSAS_PATH_NOT_SET);
            this.box.open();
        } else {
            try {
                this.status = WSASStartCommand.run();
                if (this.status.getCode() == 11) {
                    this.box.setMessage(this.status.getMessage());
                    this.box.open();
                } else {
                    WSASUpMonitorThread wsasMonitor = new WSASUpMonitorThread();
                    wsasMonitor.start();
                }
            }
            catch (InvocationTargetException e) {
                this.status = new Status(4, "id", 1, e.getMessage(), null);
                this.box.setMessage(WSASMessageConstant.INFO_WSAS_START_FAIL + "Reason" + e.getMessage());
                this.box.open();
            }
            System.setProperty("WSASStartStatus", "done");
            while (!WSASConfigurationBean.isWsasStartStatus()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            WSASUpMonitorThread.setAlive(false);
            if (!WSASConfigurationBean.isWSASAlreadyRunning()) {
                this.box.setMessage(WSASMessageConstant.INFO_WSAS_START_SUCCESS);
                this.box.open();
                WTPInternalBrowserCommand.popUpInrernalBrouwser(WSASUtils.getWSASHTTPSAddtess());
                this.shell.getParent().redraw();
            }
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.shell = window.getShell();
    }
}

