/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.server.command;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.wtp.ext.server.bean.WSASConfigurationBean;
import org.wso2.wsf.ide.wtp.ext.server.util.WSASDebugUtil;

public class WSASDebugCommand {
    private static IStatus status;

    public static IStatus run() throws InvocationTargetException {
        try {
            status = Status.OK_STATUS;
            Process wsasProcess = null;
            String[] pathNodesStopWin = new String[]{"bin", "wso2wsas.bat"};
            String[] pathNodesStopIx = new String[]{"bin", "wso2wsas.sh"};
            WSASDebugUtil debugUtil = new WSASDebugUtil();
            File runnerFile = debugUtil.createWindowsDebugRunnerFile();
            if (WSASConfigurationBean.isWsasStartStatus()) {
                status = new Status(4, "id", 11, "WSAS Already Running !!", null);
                WSASConfigurationBean.setWSASAlreadyRunning(true);
            } else {
                String wsasInstallationLocation = WSASConfigurationBean.getWsasInstallationPath();
                Runtime runtime = Runtime.getRuntime();
                String OS = System.getProperty("os.name").toLowerCase();
                String debugAppender = " --debug " + WSASConfigurationBean.getWsasDebugPort();
                if (OS.indexOf("windows 9") > -1 || OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1) {
                    wsasProcess = runtime.exec(runnerFile.getAbsolutePath() + " " + FileUtils.addNodesToPath((String)wsasInstallationLocation, (String[])pathNodesStopWin) + debugAppender);
                    wsasProcess.waitFor();
                } else {
                    wsasProcess = runtime.exec("xterm -e sh " + FileUtils.addNodesToPath((String)wsasInstallationLocation, (String[])pathNodesStopIx) + debugAppender);
                }
                WSASConfigurationBean.setWSASAlreadyRunning(false);
            }
            runnerFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }
}

