/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.java2wsdl;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.wso2.wsf.ide.wtp.ext.java2wsdl.AbstractJAVA2WSDLWizardPage;
import org.wso2.wsf.ide.wtp.ext.java2wsdl.WSASJAVA2WSDLPlugin;

public class JavaWSDLOutputLocationPage
extends AbstractJAVA2WSDLWizardPage {
    private Text outputFolderTextBox;
    private Text outputFileNameTextBox;
    private Button workspaceProjectOptionsButton;
    private Button filesyStemOptionsButton;
    private boolean workspaceSaveOption = false;

    public JavaWSDLOutputLocationPage() {
        super("page3");
    }

    protected void initializeDefaultSettings() {
        this.settings.put("OUTPUT_WSDL_LOCATION", "");
        this.settings.put("OUTPUT_WSDL", "services.wsdl");
        this.settings.put("OUTPUT_WSDL_LOCATION_FILESYATEM", true);
        this.settings.put("OUTPUT_WSDL_LOCATION_WORKSPACE", false);
    }

    public int getPageType() {
        return 2;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label selectLabel = new Label(container, 0);
        selectLabel.setText(WSASJAVA2WSDLPlugin.getResourceString("Select the location where to put the output"));
        selectLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.workspaceProjectOptionsButton = new Button(container, 16);
        this.workspaceProjectOptionsButton.setLayoutData((Object)gd);
        this.workspaceProjectOptionsButton.setText(WSASJAVA2WSDLPlugin.getResourceString("page3.workspace.caption"));
        this.workspaceProjectOptionsButton.setToolTipText(WSASJAVA2WSDLPlugin.getResourceString("page3.workspace.desc"));
        this.workspaceProjectOptionsButton.setSelection(this.settings.getBoolean("OUTPUT_WSDL_LOCATION_WORKSPACE"));
        this.workspaceProjectOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWSDLOutputLocationPage.this.handleCheckboxSelection();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.filesyStemOptionsButton = new Button(container, 16);
        this.filesyStemOptionsButton.setLayoutData((Object)gd);
        this.filesyStemOptionsButton.setText(WSASJAVA2WSDLPlugin.getResourceString("page3.filesystem.caption"));
        this.filesyStemOptionsButton.setToolTipText(WSASJAVA2WSDLPlugin.getResourceString("page3.filesystem.desc"));
        this.filesyStemOptionsButton.setSelection(this.settings.getBoolean("OUTPUT_WSDL_LOCATION_FILESYATEM"));
        this.filesyStemOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWSDLOutputLocationPage.this.handleCheckboxSelection();
            }
        });
        Label label1 = new Label(container, 0);
        label1.setText(WSASJAVA2WSDLPlugin.getResourceString("page3.output.label"));
        gd = new GridData(768);
        this.outputFolderTextBox = new Text(container, 2048);
        this.outputFolderTextBox.setLayoutData((Object)gd);
        this.outputFolderTextBox.setText("");
        this.outputFolderTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaWSDLOutputLocationPage.this.handleFolderTextChange();
            }
        });
        Button browseButton = new Button(container, 8);
        browseButton.setText(WSASJAVA2WSDLPlugin.getResourceString("general.browse"));
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaWSDLOutputLocationPage.this.handleBrowse();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(container, 0);
        label.setText(WSASJAVA2WSDLPlugin.getResourceString("page3.outputname.label"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.outputFileNameTextBox = new Text(container, 2048);
        this.outputFileNameTextBox.setLayoutData((Object)gd);
        this.outputFileNameTextBox.setText(this.settings.get("OUTPUT_WSDL"));
        this.outputFileNameTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaWSDLOutputLocationPage.this.handleFileNameTextChange();
            }
        });
        if (this.restoredFromPreviousSettings) {
            this.handleFolderTextChange();
            this.handleFolderTextChange();
        }
        this.setPageComplete(false);
        this.setControl((Control)container);
    }

    private void handleCheckboxSelection() {
        if (this.workspaceProjectOptionsButton.getSelection()) {
            this.settings.put("OUTPUT_WSDL_LOCATION_WORKSPACE", true);
            this.settings.put("OUTPUT_WSDL_LOCATION_FILESYATEM", false);
            this.workspaceSaveOption = true;
        } else if (this.filesyStemOptionsButton.getSelection()) {
            this.settings.put("OUTPUT_WSDL_LOCATION_FILESYATEM", true);
            this.settings.put("OUTPUT_WSDL_LOCATION_WORKSPACE", false);
            this.workspaceSaveOption = false;
        }
    }

    private void handleFolderTextChange() {
        String outputFolder = this.outputFolderTextBox.getText();
        this.settings.put("OUTPUT_WSDL_LOCATION", outputFolder);
        if ("".equals(outputFolder.trim())) {
            this.updateStatus("Input a proper location for the output");
        } else {
            this.updateStatus(null);
        }
    }

    private void handleFileNameTextChange() {
        String outFileName = this.outputFileNameTextBox.getText();
        this.settings.put("OUTPUT_WSDL", outFileName);
        if ("".equals(outFileName.trim())) {
            this.updateStatus("Input a file name");
        } else if (outFileName.matches("\\W")) {
            this.updateStatus("Input a valid file name");
        } else if (!outFileName.endsWith(".wsdl") && !outFileName.endsWith(".xml")) {
            this.updateStatus("Input a valid file name , Example : services.wsdl or services.xml");
        } else {
            this.updateStatus(null);
        }
    }

    private void handleBrowse() {
        boolean location = false;
        if (this.settings.getBoolean("OUTPUT_WSDL_LOCATION_FILESYATEM")) {
            location = false;
        } else if (this.settings.getBoolean("OUTPUT_WSDL_LOCATION_WORKSPACE")) {
            location = true;
        }
        if (this.workspaceSaveOption) {
            location = true;
        }
        if (!location) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            String returnString = dialog.open();
            if (returnString != null) {
                this.outputFolderTextBox.setText(returnString);
            }
        } else {
            Path path;
            Object[] result;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)root, false, WSASJAVA2WSDLPlugin.getResourceString("page3.containerbox.title"));
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && root.exists((IPath)(path = (Path)result[0]))) {
                this.outputFolderTextBox.setText(root.getLocation().append((IPath)path).toFile().getAbsolutePath());
            }
        }
    }

    public String getFullFileName() {
        String folder = this.outputFolderTextBox.getText();
        String fileName = this.outputFileNameTextBox.getText();
        if (!fileName.endsWith(".wsdl")) {
            fileName = fileName + ".wsdl";
        }
        return folder + File.separator + fileName;
    }

    public String getOutputWSDLName() {
        return this.outputFileNameTextBox.getText();
    }

    public String getOutputLocation() {
        return this.outputFolderTextBox.getText();
    }
}

