/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.java2wsdl;

import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.wso2.wsf.ide.wtp.ext.java2wsdl.AbstractJAVA2WSDLWizardPage;
import org.wso2.wsf.ide.wtp.ext.java2wsdl.WSASJAVA2WSDLPlugin;
import org.wso2.wsf.ide.wtp.ext.java2wsdl.util.ClassFileReader;

public class JavaSourceSelectionPage
extends AbstractJAVA2WSDLWizardPage {
    private Composite container;
    private Text javaClassNameBox;
    private List javaClasspathList;
    private Label statusLabel;

    public JavaSourceSelectionPage() {
        super("page1");
    }

    protected void initializeDefaultSettings() {
        this.settings.put("JAVA_CLASS_NAME", "");
        this.settings.put("JAVA_CLASS_PATH_NAME", new String[]{""});
    }

    public int getPageType() {
        return 2;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        Label label = new Label(this.container, 0);
        label.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.classname.label"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.javaClassNameBox = new Text(this.container, 2048);
        this.javaClassNameBox.setLayoutData((Object)gd);
        this.javaClassNameBox.setText(this.settings.get("JAVA_CLASS_NAME"));
        this.javaClassNameBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaSourceSelectionPage.this.handleClassNameTextChange();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label = new Label(this.container, 0);
        label.setLayoutData((Object)gd);
        label.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.classpath.label"));
        gd = new GridData(768);
        Button addDirButton = new Button(this.container, 8);
        addDirButton.setLayoutData((Object)gd);
        addDirButton.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.addDir.label"));
        addDirButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                JavaSourceSelectionPage.this.handleDirectoryBrowse();
            }
        });
        gd = new GridData(768);
        Button addJarButton = new Button(this.container, 8);
        addJarButton.setLayoutData((Object)gd);
        addJarButton.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.addJar.label"));
        addJarButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                JavaSourceSelectionPage.this.handleFileBrowse();
            }
        });
        gd = new GridData(768);
        Button removeEntryButton = new Button(this.container, 8);
        removeEntryButton.setLayoutData((Object)gd);
        removeEntryButton.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.removeEntry.label"));
        removeEntryButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                JavaSourceSelectionPage.this.handleRemove();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 2;
        ScrolledComposite c2 = new ScrolledComposite(this.container, 512);
        c2.setExpandHorizontal(false);
        c2.setExpandVertical(false);
        c2.setLayoutData((Object)gd);
        this.javaClasspathList = new List((Composite)c2, 2568);
        this.javaClasspathList.setLayoutData((Object)gd);
        this.settings.put("JAVA_CLASS_PATH_NAME", new String[0]);
        this.javaClasspathList.setItems(this.settings.getArray("JAVA_CLASS_PATH_NAME"));
        this.javaClasspathList.setSize(600, 250);
        c2.setContent((Control)this.javaClasspathList);
        gd = new GridData(768);
        Button tryLoadButton = new Button(this.container, 8);
        tryLoadButton.setLayoutData((Object)gd);
        tryLoadButton.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.tryLoad.label"));
        tryLoadButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ArrayList errorListener = new ArrayList();
                if (!ClassFileReader.tryLoadingClass(JavaSourceSelectionPage.this.getClassName(), JavaSourceSelectionPage.this.getClassPathList(), errorListener)) {
                    for (Object nextObject : errorListener) {
                        String errorMessage = nextObject == null ? WSASJAVA2WSDLPlugin.getResourceString("page1.unknownError.label") : nextObject.toString();
                        JavaSourceSelectionPage.this.updateStatus(errorMessage);
                        JavaSourceSelectionPage.this.updateStatusTextField(false, errorMessage);
                    }
                } else {
                    JavaSourceSelectionPage.this.updateStatusTextField(true, WSASJAVA2WSDLPlugin.getResourceString("page1.successLoading.label"));
                    JavaSourceSelectionPage.this.updateStatus(null);
                }
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.statusLabel = new Label(this.container, 0);
        this.statusLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLabel3 = new Label(this.container, 258);
        fillLabel3.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label hintLabel = new Label(this.container, 0);
        hintLabel.setText(WSASJAVA2WSDLPlugin.getResourceString("page1.hint.caption"));
        hintLabel.setLayoutData((Object)gd);
        this.setPageComplete(false);
        this.setControl((Control)this.container);
        if (this.restoredFromPreviousSettings) {
            this.handleClassNameTextChange();
        }
    }

    private void handleDirectoryBrowse() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell());
        String dirName = fileDialog.open();
        if (dirName != null && !this.checkFilenameExistsInList(dirName)) {
            this.javaClasspathList.add(dirName);
            this.updateListEntries();
        }
        this.updateStatusTextField(false, "");
    }

    private void handleRemove() {
        int[] selectionIndices = this.javaClasspathList.getSelectionIndices();
        for (int i = 0; i < selectionIndices.length; ++i) {
            this.javaClasspathList.remove(selectionIndices[i]);
        }
        this.updateListEntries();
        this.updateStatusTextField(false, "");
    }

    private void handleFileBrowse() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{"*.jar"});
        String fileName = fileDialog.open();
        if (fileName != null && !this.checkFilenameExistsInList(fileName)) {
            this.javaClasspathList.add(fileName);
            this.updateListEntries();
        }
        this.updateStatusTextField(false, "");
    }

    private boolean checkFilenameExistsInList(String filename) {
        String[] array = this.javaClasspathList.getItems();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(filename)) continue;
            return true;
        }
        return false;
    }

    private void updateStatusTextField(boolean success, String text) {
        if (success) {
            this.getCodegenWizard().setDefaultNamespaces(this.javaClassNameBox.getText());
        }
        this.statusLabel.setText(text);
    }

    private void updateListEntries() {
        this.settings.put("JAVA_CLASS_PATH_NAME", this.javaClasspathList.getItems());
    }

    private void handleClassNameTextChange() {
        String className = this.javaClassNameBox.getText();
        this.settings.put("JAVA_CLASS_NAME", className);
        if (className == null || "".equals(className.trim())) {
            this.updateStatus(WSASJAVA2WSDLPlugin.getResourceString("page1.error.invalidClassName"));
        } else if (className.endsWith(".")) {
            this.updateStatus(WSASJAVA2WSDLPlugin.getResourceString("page1.error.ClassNameNotTerminated"));
        }
    }

    public String getClassName() {
        return this.javaClassNameBox.getText();
    }

    public String[] getClassPathList() {
        return this.javaClasspathList.getItems();
    }
}

