/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.dumpaar.script;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.wsf.ide.wtp.ext.dumpaar.script.AntBuildDTO;

public class AntMapBuilder {
    private IPath buildFileLocation;

    public boolean buildAntBuildMap(AntBuildDTO dto) {
        try {
            Document document = this.createDomDocument();
            Element mapElement = document.createElement("Map");
            document.appendChild(mapElement);
            mapElement.appendChild(this.getEntryElement(document, "serviceName", dto.getServiceName()));
            mapElement.appendChild(this.getEntryElement(document, "buildTarget", dto.getTargetPath()));
            Path outputLocation = new Path(dto.getTargetPath());
            outputLocation = outputLocation.removeLastSegments(1);
            outputLocation = outputLocation.append(dto.getServiceName());
            outputLocation = outputLocation.append(dto.getServiceName() + "DumpAARMap.xml");
            AntMapBuilder.writeXmlFile(document, outputLocation.toOSString());
            this.setBuildFileLocation((IPath)outputLocation);
        }
        catch (DOMException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Document createDomDocument() throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        return doc;
    }

    private Element getEntryElement(Document document, String key, String value) {
        Element entryElement = document.createElement("Entry");
        entryElement.setAttribute("key", key);
        entryElement.setAttribute("value", value);
        return entryElement;
    }

    private static void writeXmlFile(Document doc, String filename) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        File file = new File(filename);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }

    public IPath getBuildFileLocation() {
        return this.buildFileLocation;
    }

    private void setBuildFileLocation(IPath buildFileLocation) {
        this.buildFileLocation = buildFileLocation;
    }
}

