/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.wtp.ext.dumpaar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.wso2.wsf.ide.core.context.ServiceContext;
import org.wso2.wsf.ide.core.utils.ArchiveManipulator;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.core.utils.ScriptBuilder;
import org.wso2.wsf.ide.wtp.ext.dumpaar.AbstractDumpAARWizardPage;
import org.wso2.wsf.ide.wtp.ext.dumpaar.WSASDumpAARPlugin;
import org.wso2.wsf.ide.wtp.ext.dumpaar.WSASDumpAARSelectionPage;
import org.wso2.wsf.ide.wtp.ext.dumpaar.script.AntBuildDTO;
import org.wso2.wsf.ide.wtp.ext.dumpaar.script.AntMapBuilder;
import org.wso2.wsf.ide.wtp.ext.java2wsdl.JAVA2WSDLOptionsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSASDumpArchiverWizard
extends Wizard
implements INewWizard {
    WSASDumpAARSelectionPage dumpAARSelectionPage;
    JAVA2WSDLOptionsPage java2WSDLOptionsPage;
    boolean alreadyInit;
    IPath systemDirPath;
    IPath dumpAARPath;
    IPath dumpAARTargetPath;
    IPath workspacePath;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public WSASDumpArchiverWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("WSO2 Web Services AAR Dump Tool");
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        AbstractDumpAARWizardPage wizardPage = null;
        for (int i = 0; i < pages.length; ++i) {
            wizardPage = (AbstractDumpAARWizardPage)pages[i];
            if (wizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractDumpAARWizardPage thisPage = (AbstractDumpAARWizardPage)page;
        AbstractDumpAARWizardPage nextPage = (AbstractDumpAARWizardPage)super.getNextPage(page);
        while (thisPage != null && thisPage.isSkipNext() && nextPage != null) {
            thisPage = nextPage;
            nextPage = (AbstractDumpAARWizardPage)super.getNextPage((IWizardPage)nextPage);
        }
        return nextPage;
    }

    public void addPages() {
        this.dumpAARSelectionPage = new WSASDumpAARSelectionPage();
        this.addPage((IWizardPage)this.dumpAARSelectionPage);
    }

    public boolean performFinish() {
        IPath selectedServicePath;
        File selectedServiceFile;
        String serviceToDump = this.dumpAARSelectionPage.getSelectedService();
        if (!this.alreadyInit) {
            this.initFolderStructure();
        }
        if ((selectedServiceFile = new File((selectedServicePath = this.dumpAARPath.append(serviceToDump)).toOSString())).exists()) {
            FileUtils.deleteDirectories((File)selectedServiceFile);
        }
        FileUtils.createDirectorys((String)selectedServiceFile.getAbsolutePath());
        try {
            FileUtils.copyDirectory((File)new File(this.dumpAARSelectionPage.getWSASRepoPath().append(serviceToDump).toOSString()), (File)selectedServiceFile);
            ServiceContext context = ServiceContext.getInstance();
            String projectName = this.getProjectForService(serviceToDump, context.getServiceToProjectMap());
            FileUtils.copyDirectory((File)new File(this.workspacePath.append(projectName).append("src").toOSString()), (File)selectedServiceFile);
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            archiveManipulator.archiveDir(serviceToDump + ".aar", selectedServicePath.toOSString());
            File archiveLocation = new File(this.systemDirPath.append(serviceToDump + ".aar").toOSString());
            Path archiveDestLocation = new Path(this.dumpAARTargetPath.toOSString());
            archiveDestLocation = archiveDestLocation.append(serviceToDump + ".aar");
            FileUtils.copyFile((String)archiveLocation.getAbsolutePath(), (String)archiveDestLocation.toOSString());
            archiveLocation.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.dumpAARSelectionPage.getBuildCheckBoxSelection()) {
            AntBuildDTO antBuildDTO = new AntBuildDTO();
            antBuildDTO.setServiceName(serviceToDump);
            antBuildDTO.setTargetPath(this.dumpAARTargetPath.toOSString());
            AntMapBuilder antMapBuilder = new AntMapBuilder();
            antMapBuilder.buildAntBuildMap(antBuildDTO);
            try {
                ScriptBuilder scriptBuilder = new ScriptBuilder();
                FileInputStream inStream = new FileInputStream(antMapBuilder.getBuildFileLocation().toOSString());
                Path antBuildLocation = new Path(antBuildDTO.getTargetPath());
                antBuildLocation = antBuildLocation.removeLastSegments(1);
                antBuildLocation = antBuildLocation.append(antBuildDTO.getServiceName() + "AntBuild.xml");
                FileOutputStream outStream = new FileOutputStream(antBuildLocation.toOSString());
                InputStream xslStream = ((Object)((Object)this)).getClass().getResourceAsStream("org/wso2/wsf/ide/wtp/ext/dumpaar/xsl/AntBuildTemplate.xsl");
                if (xslStream == null) {
                    xslStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/wso2/wsf/ide/wtp/ext/dumpaar/xsl/AntBuildTemplate.xsl");
                }
                scriptBuilder.parseXMLFile((InputStream)inStream, (OutputStream)outStream, xslStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)WSASDumpAARPlugin.getResourceString("page1.name"), (String)WSASDumpAARPlugin.getResourceString("page1.success"));
        return true;
    }

    private void initFolderStructure() {
        this.systemDirPath = new Path(System.getProperty("user.dir"));
        this.dumpAARPath = this.systemDirPath.append("dumpAAR");
        this.dumpAARTargetPath = new Path(this.dumpAARPath.append("target").toOSString());
        FileUtils.createDirectorys((String)this.dumpAARPath.toOSString());
        FileUtils.createDirectorys((String)this.dumpAARTargetPath.toOSString());
        this.workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
        this.alreadyInit = true;
    }

    private String getProjectForService(String service, Map<String, String> serviceToProjectMap) {
        String mappedProjectName = null;
        if (serviceToProjectMap.containsKey(service)) {
            mappedProjectName = serviceToProjectMap.get(service);
        }
        return mappedProjectName;
    }
}

