/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsdlconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.Util;

public class WSDLConverter {
    private static Log log = LogFactory.getLog((Class)WSDLConverter.class);

    public String convert(String fileId) throws AxisFault {
        String wsdl11FilePath = this.getFilePathFromFileId(fileId);
        return this.convertWSDL11ToWSDL20(wsdl11FilePath);
    }

    public String convertFromURL(String url) throws AxisFault {
        return this.convertWSDL11ToWSDL20(Util.writeWSDLToFileSystem(url));
    }

    private String convertWSDL11ToWSDL20(String wsdl11FilePath) throws AxisFault {
        try {
            InputStream inXSLTStream = Util.getConverterXSLStream();
            FileInputStream inXMLStream = new FileInputStream(new File(wsdl11FilePath));
            StreamSource xmlSource = new StreamSource(inXMLStream);
            StreamSource xsltSource = new StreamSource(inXSLTStream);
            String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
            if (File.separatorChar == '\\') {
                wsdl11FilePath = wsdl11FilePath.replace('\\', '/');
            }
            int lastIndex = wsdl11FilePath.lastIndexOf(47);
            String filePath = wsdl11FilePath.substring(0, lastIndex);
            File outFile = new File(filePath, uuid + ".xml");
            FileOutputStream out = new FileOutputStream(outFile);
            StreamResult wsdlResult = new StreamResult(out);
            ClassLoader classLoader = MessageContext.getCurrentMessageContext().getAxisService().getClassLoader();
            Util.transform(xmlSource, xsltSource, wsdlResult, classLoader);
            ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)configCtx.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                configCtx.setProperty("file.resource.map", fileResourcesMap);
            }
            fileResourcesMap.put(uuid, outFile.getAbsolutePath());
            return "/filedownload?id=" + uuid;
        }
        catch (FileNotFoundException e) {
            String msg = "File provided cannot be found. " + e.getMessage() + ". Please select a valid file.";
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (TransformerConfigurationException e) {
            String msg = "Problem has occured during the process of transformation. " + e.getMessage();
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (TransformerException e) {
            String msg = "Problem has occured during the process of transformation. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "IllegalAccessException. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (ClassNotFoundException e) {
            String msg = "ClassNotFoundException. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (InstantiationException e) {
            String msg = "InstantiationException. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
    }

    protected String getTargetFileLocation(String wsdl11FilePath) throws AxisFault {
        File file = new File(wsdl11FilePath);
        if (file.isFile()) {
            String name = file.getName();
            String wsdlFileName = name.substring(0, name.lastIndexOf(".")) + "-wsdl20.wsdl";
            return file.getParent() + File.separator + wsdlFileName;
        }
        String s = "File path does not refers to a file";
        log.error((Object)s);
        throw new AxisFault(s);
    }

    private String getFilePathFromFileId(String fileId) {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        return (String)fileResMap.get(fileId);
    }
}

