/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.tryit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.Util;
import org.wso2.tryit.ProxyMessageReceiver;
import org.wso2.tryit.ProxyTimerTask;
import org.wso2.utils.NetworkUtils;

public class GenericAJAXClient {
    public static String TRYIT_SG_NAME = "TryItMockServiceGroup";
    private static String PROXY_TIMER = "_PROXY_TIMER_";
    public static String LAST_TOUCH_TIME = "_LAST_TOUCH_TIME_";
    public static final long PERIOD = 1200000L;
    private static Log log = LogFactory.getLog((Class)GenericAJAXClient.class);

    public String generateAJAXApp(String url, String hostName) throws AxisFault {
        Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
        }
        try {
            WSDL11ToAxisServiceBuilder builder;
            ClassLoader classLoader;
            block18: {
                classLoader = MessageContext.getCurrentMessageContext().getAxisService().getClassLoader();
                File location = Util.writeWSDLToFileSystemHelpler(url);
                FileInputStream inXMLStream = new FileInputStream(location);
                try {
                    XMLStreamReader streamReader1 = XMLInputFactory.newInstance().createXMLStreamReader(inXMLStream);
                    StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(streamReader1);
                    OMElement docEle = stAXOMBuilder.getDocumentElement();
                    if (docEle.getQName().getLocalPart().equals("definitions")) {
                        builder = new WSDL11ToAxisServiceBuilder((InputStream)new FileInputStream(location));
                        builder.setBaseUri(this.getBaseURI(url));
                        builder.setAllPorts(true);
                        break block18;
                    }
                    if (docEle.getQName().getLocalPart().equals("description")) {
                        builder = new WSDL20ToAxisServiceBuilder((InputStream)new FileInputStream(location), null, null);
                        builder.setBaseUri(this.getBaseURI(url));
                        break block18;
                    }
                    String msg = GenericAJAXClient.class.getName() + " standard WSDL document is not found";
                    log.error((Object)msg);
                    throw new AxisFault(msg);
                }
                catch (XMLStreamException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
            AxisService service = builder.populateService();
            this.updateMockProxyServiceGroup(service, MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration());
            ArrayList<String> exposeTxList = new ArrayList<String>();
            exposeTxList.add("http");
            service.setExposedTransports(exposeTxList);
            ByteArrayOutputStream wsdl2Bos = new ByteArrayOutputStream();
            if (hostName == null || hostName.length() == 0) {
                hostName = NetworkUtils.getLocalHostname();
            }
            service.printWSDL2((OutputStream)wsdl2Bos, hostName);
            if (log.isDebugEnabled()) {
                try {
                    XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(wsdl2Bos.toByteArray()));
                    StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(streamReader);
                    OMElement ele = stAXOMBuilder.getDocumentElement();
                    log.debug((Object)("output ==> " + ele.toString()));
                }
                catch (XMLStreamException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            StreamSource wsdlSource = new StreamSource(new ByteArrayInputStream(wsdl2Bos.toByteArray()));
            InputStream wsdl2sigXSLTStream = this.getClass().getClassLoader().getResourceAsStream("wsdl2sig.xslt");
            StreamSource wsdl2sigXSLTSource = new StreamSource(wsdl2sigXSLTStream);
            DocumentBuilder docB = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document docSig = docB.newDocument();
            DOMResult resultSig = new DOMResult(docSig);
            Util.transform(wsdlSource, wsdl2sigXSLTSource, resultSig, classLoader);
            DOMSource sigDomSource = new DOMSource(docSig);
            Util.FileInfo jsFileLocation = Util.getOutputFileLocation(".stub.js");
            File jsFile = jsFileLocation.getFile();
            InputStream jsStubXSLTStream = this.getClass().getClassLoader().getResourceAsStream("jsstub.xslt");
            StreamSource jsStubXSLSource = new StreamSource(jsStubXSLTStream);
            FileOutputStream jsStubOutputStream = new FileOutputStream(jsFile);
            StreamResult jsStubResult = new StreamResult(jsStubOutputStream);
            Util.transform(sigDomSource, jsStubXSLSource, jsStubResult, classLoader);
            File[] files0 = jsFile.getParentFile().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".stub.js");
                }
            });
            if (files0 != null && files0[0] != null && files0[0].getAbsoluteFile() != null) {
                String absolutePath = files0[0].getAbsoluteFile().getAbsolutePath();
                fileResourcesMap.put(jsFileLocation.getUuid(), absolutePath);
            }
            InputStream tryItXSLTStream = this.getClass().getClassLoader().getResourceAsStream("tryit.xslt");
            StreamSource tryItXSLSource = new StreamSource(tryItXSLTStream);
            Util.FileInfo htmlFileLocation = Util.getOutputFileLocation(".html");
            File tryItOutFile = htmlFileLocation.getFile();
            FileOutputStream tryItOutFileStream = new FileOutputStream(tryItOutFile);
            StreamResult tryItResult = new StreamResult(tryItOutFileStream);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("wsrequest-location", "js/WSRequest.js");
            paramMap.put("stub-location", "filedownload?id=" + jsFileLocation.getUuid());
            paramMap.put("show-alternate", "false");
            paramMap.put("fixendpoints", "false");
            Util.transform(sigDomSource, tryItXSLSource, tryItResult, paramMap, classLoader);
            File[] files1 = tryItOutFile.getParentFile().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".html");
                }
            });
            if (files1 != null && files1[0] != null && files1[0].getAbsoluteFile() != null) {
                fileResourcesMap.put(htmlFileLocation.getUuid(), files1[0].getAbsoluteFile().getAbsolutePath());
            }
            return "/filedownload?id=" + htmlFileLocation.getUuid();
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (TransformerException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (InstantiationException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMockProxyServiceGroup(AxisService axisService, AxisConfiguration axisConfig) throws AxisFault {
        ProxyMessageReceiver receiver = new ProxyMessageReceiver();
        PhasesInfo phaseInfo = axisConfig.getPhasesInfo();
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation op = (AxisOperation)i.next();
            op.setMessageReceiver((MessageReceiver)receiver);
            phaseInfo.setOperationPhases(op);
        }
        AxisConfiguration axisConfiguration = axisConfig;
        synchronized (axisConfiguration) {
            AxisService testService;
            AxisServiceGroup serviceGroup = axisConfig.getServiceGroup(TRYIT_SG_NAME);
            if (serviceGroup == null) {
                serviceGroup = new AxisServiceGroup();
                serviceGroup.setServiceGroupName(TRYIT_SG_NAME);
            }
            if ((testService = axisConfig.getService(axisService.getName())) != null) {
                int loop = 1;
                while (true) {
                    String testName;
                    if (axisConfig.getService(testName = axisService.getName() + "_" + loop) == null) {
                        axisService.setName(testName);
                        break;
                    }
                    ++loop;
                }
            }
            serviceGroup.addService(axisService);
            axisConfig.addServiceGroup(serviceGroup);
            axisService.addParameter(LAST_TOUCH_TIME, (Object)new Long(System.currentTimeMillis()));
            Parameter parameter = axisConfig.getParameter(PROXY_TIMER);
            if (parameter == null) {
                Timer timer = new Timer();
                timer.scheduleAtFixedRate((TimerTask)new ProxyTimerTask(axisConfig), 1200000L, 1200000L);
                parameter = new Parameter(PROXY_TIMER, (Object)timer);
                axisConfig.addParameter(parameter);
            }
        }
    }

    private String getBaseURI(String currentURI) {
        String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
        return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
    }
}

