/*
 * Decompiled with CFR 0.152.
 */
package org.wso2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static Log log = LogFactory.getLog((Class)Util.class);

    public static String writeWSDLToFileSystem(String url) throws AxisFault {
        return Util.writeWSDLToFileSystemHelpler(url).getAbsolutePath();
    }

    public static InputStream writeWSDLToStream(String url) throws IOException {
        return new FileInputStream(Util.writeWSDLToFileSystemHelpler(url));
    }

    public static InputStream getConverterXSLStream() throws AxisFault {
        InputStream inXSLTStream = Util.class.getClassLoader().getResourceAsStream("org/wso2/wsdlconverter/wsdl11to20.xsl");
        if (inXSLTStream == null) {
            inXSLTStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/wso2/wsdlconverter/wsdl11to20.xsl");
        }
        if (inXSLTStream == null) {
            String e = Util.class.getName() + " wsdl11to20.xsl cannot be located.";
            log.error((Object)e);
            throw new AxisFault(e);
        }
        return inXSLTStream;
    }

    public static void transform(Source xmlIn, Source xslIn, Result result, ClassLoader classLoader) throws TransformerException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Util.transform(xmlIn, xslIn, result, null, classLoader);
    }

    public static void transform(Source xmlIn, Source xslIn, Result result, Map paramMap, ClassLoader classLoader) throws TransformerException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        try {
            Class<?> providerClass = Class.forName("net.sf.saxon.TransformerFactoryImpl", false, classLoader);
            TransformerFactory transformerFactory = (TransformerFactory)providerClass.newInstance();
            Transformer transformer = transformerFactory.newTransformer(xslIn);
            if (paramMap != null) {
                Set set = paramMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = (String)paramMap.get(key);
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(xmlIn, result);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static FileInfo getOutputFileLocation(String suffix) {
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        String extraFileLocation = MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
        File dirs = new File(extraFileLocation);
        if (!dirs.exists()) {
            dirs.mkdirs();
        }
        File outFile = new File(extraFileLocation, uuid + suffix);
        return new FileInfo(uuid, outFile);
    }

    public static File writeWSDLToFileSystemHelpler(String url) throws AxisFault {
        try {
            int len;
            URL wsdlURL = new URL(url);
            URLConnection connection = wsdlURL.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                String msg = "Unable to process given URL. Only HTTP protocol is currently supported.";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            HttpURLConnection uconn = (HttpURLConnection)connection;
            uconn.setRequestMethod("GET");
            uconn.setAllowUserInteraction(false);
            uconn.setDefaultUseCaches(false);
            uconn.setDoInput(true);
            uconn.setDoOutput(false);
            uconn.setInstanceFollowRedirects(true);
            uconn.setUseCaches(false);
            uconn.connect();
            InputStream inStrm = uconn.getInputStream();
            BufferedInputStream bIn = new BufferedInputStream(inStrm);
            File outFile = Util.getOutputFileLocation(".xml").getFile();
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = bIn.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            bIn.close();
            inStrm.close();
            uconn.disconnect();
            out.close();
            return outFile;
        }
        catch (IllegalArgumentException e) {
            String msg = "URL provided is invalid. " + e.getMessage() + ". Please use a valid URL";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (MalformedURLException e) {
            String msg = "URL provided is invalid. " + e.getMessage() + ". Please use a valid URL";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (FileNotFoundException e) {
            String msg = "File provied is invalid. " + e.getMessage() + ". Please use a valid file.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (IOException e) {
            String msg = "Problems has encountered in connection. " + e.getMessage() + ". Please check the connection and try this again.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
    }

    public static class FileInfo {
        private String uuid;
        private File file;

        public FileInfo(String uuid, File file) {
            this.uuid = uuid;
            this.file = file;
        }

        public String getUuid() {
            return this.uuid;
        }

        public File getFile() {
            return this.file;
        }
    }
}

