/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.SessionRequestHandle;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.impl.nio.reactor.SessionRequestQueue;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.concurrent.ThreadFactory;

public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    private final SessionRequestQueue requestQueue = new SessionRequestQueue();
    private long lastTimeoutCheck = System.currentTimeMillis();

    public DefaultConnectingIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        super(workerCount, threadFactory, params);
    }

    public DefaultConnectingIOReactor(int workerCount, HttpParams params) throws IOReactorException {
        this(workerCount, null, params);
    }

    protected void processEvents(int readyCount) throws IOReactorException {
        long currentTime;
        this.processSessionRequests();
        if (readyCount > 0) {
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = selectedKeys.iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                this.processEvent(key);
            }
            selectedKeys.clear();
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastTimeoutCheck >= this.selectTimeout) {
            this.lastTimeoutCheck = currentTime;
            Set<SelectionKey> keys = this.selector.keys();
            if (keys != null) {
                this.processTimeouts(keys);
            }
        }
    }

    private void processEvent(SelectionKey key) {
        block8: {
            try {
                if (!key.isConnectable()) break block8;
                SocketChannel channel = (SocketChannel)key.channel();
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                SessionRequestImpl sessionRequest = requestHandle.getSessionRequest();
                try {
                    channel.finishConnect();
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
                key.cancel();
                if (!channel.isConnected()) break block8;
                try {
                    block9: {
                        try {
                            this.prepareSocket(channel.socket());
                        }
                        catch (IOException ex) {
                            if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block9;
                            throw new IOReactorException("Failure initalizing socket", ex);
                        }
                    }
                    ChannelEntry entry = new ChannelEntry(channel, sessionRequest);
                    this.addChannel(entry);
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
            }
            catch (CancelledKeyException ex) {
                key.attach(null);
            }
        }
    }

    private void processTimeouts(Set keys) {
        long now = System.currentTimeMillis();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SessionRequestHandle handle;
            SessionRequestImpl sessionRequest;
            int timeout;
            SelectionKey key = (SelectionKey)it.next();
            Object attachment = key.attachment();
            if (!(attachment instanceof SessionRequestHandle) || (timeout = (sessionRequest = (handle = (SessionRequestHandle)key.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || handle.getRequestTime() + (long)timeout >= now) continue;
            sessionRequest.timeout();
        }
    }

    public SessionRequest connect(SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        if (this.status > 1) {
            throw new IllegalStateException("I/O reactor has been shut down");
        }
        SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteAddress, localAddress, attachment, callback);
        sessionRequest.setConnectTimeout(HttpConnectionParams.getConnectionTimeout((HttpParams)this.params));
        this.requestQueue.push(sessionRequest);
        this.selector.wakeup();
        return sessionRequest;
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address == null) {
            return;
        }
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processSessionRequests() throws IOReactorException {
        SessionRequestImpl request;
        while ((request = this.requestQueue.pop()) != null) {
            SelectionKey key;
            SocketChannel socketChannel;
            if (request.isCompleted()) continue;
            try {
                socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure opening socket", ex);
            }
            try {
                boolean connected;
                this.validateAddress(request.getLocalAddress());
                this.validateAddress(request.getRemoteAddress());
                if (request.getLocalAddress() != null) {
                    socketChannel.socket().bind(request.getLocalAddress());
                }
                if (connected = socketChannel.connect(request.getRemoteAddress())) {
                    this.prepareSocket(socketChannel.socket());
                    ChannelEntry entry = new ChannelEntry(socketChannel, request);
                    this.addChannel(entry);
                    return;
                }
            }
            catch (IOException ex) {
                request.failed(ex);
                return;
            }
            try {
                key = socketChannel.register(this.selector, 0);
                request.setKey(key);
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            SessionRequestHandle requestHandle = new SessionRequestHandle(request);
            try {
                key.attach(requestHandle);
                key.interestOps(8);
            }
            catch (CancelledKeyException ex) {}
        }
    }
}

