/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractIOReactor;
import org.apache.http.impl.nio.reactor.SessionHandle;
import org.apache.http.impl.nio.reactor.SessionSet;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.IOSession;

public class BaseIOReactor
extends AbstractIOReactor {
    private final long timeoutCheckInterval;
    private SessionSet bufferingSessions = new SessionSet();
    private long lastTimeoutCheck;
    private IOReactorExceptionHandler exceptionHandler = null;
    private IOEventDispatch eventDispatch = null;

    public BaseIOReactor(long selectTimeout) throws IOReactorException {
        super(selectTimeout);
        this.timeoutCheckInterval = selectTimeout;
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.eventDispatch = eventDispatch;
        this.execute();
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void handleRuntimeException(RuntimeException ex) {
        if (this.exceptionHandler == null || !this.exceptionHandler.handle(ex)) {
            throw ex;
        }
    }

    protected void acceptable(SelectionKey key) {
    }

    protected void connectable(SelectionKey key) {
    }

    protected void readable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastRead();
        try {
            this.eventDispatch.inputReady(session);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
        if (session.hasBufferedInput()) {
            this.bufferingSessions.add(session);
        }
    }

    protected void writable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastWrite();
        try {
            this.eventDispatch.outputReady(session);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    protected void validate(Set keys) {
        Iterator it;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.timeoutCheckInterval) {
            this.lastTimeoutCheck = currentTime;
            if (keys != null) {
                it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = (SelectionKey)it.next();
                    this.timeoutCheck(key, currentTime);
                }
            }
        }
        if (!this.bufferingSessions.isEmpty()) {
            it = this.bufferingSessions.iterator();
            while (it.hasNext()) {
                IOSession session = (IOSession)it.next();
                if (!session.hasBufferedInput()) {
                    it.remove();
                    continue;
                }
                try {
                    int ops = session.getEventMask();
                    if ((ops & 1) <= 0) continue;
                    try {
                        this.eventDispatch.inputReady(session);
                    }
                    catch (RuntimeException ex) {
                        this.handleRuntimeException(ex);
                    }
                    if (session.hasBufferedInput()) continue;
                    it.remove();
                }
                catch (CancelledKeyException ex) {
                    it.remove();
                }
            }
        }
    }

    protected void timeoutCheck(SelectionKey key, long now) {
        SessionHandle handle;
        IOSession session;
        int timeout;
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle && (timeout = (session = (handle = (SessionHandle)key.attachment()).getSession()).getSocketTimeout()) > 0 && handle.getLastReadTime() + (long)timeout < now) {
            try {
                this.eventDispatch.timeout(session);
            }
            catch (RuntimeException ex) {
                this.handleRuntimeException(ex);
            }
        }
    }

    protected void keyCreated(SelectionKey key, IOSession session) {
        SessionHandle handle = new SessionHandle(session);
        key.attach(handle);
        try {
            this.eventDispatch.connected(session);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    protected IOSession keyCancelled(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle) {
            SessionHandle handle = (SessionHandle)attachment;
            return handle.getSession();
        }
        return null;
    }

    protected void sessionClosed(IOSession session) {
        try {
            this.eventDispatch.disconnected(session);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }
}

