/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsdlview;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.java2wsdl.Java2WSDLCodegenEngine;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOptionParser;
import org.apache.ws.java2wsdl.utils.Java2WSDLOptionsValidator;

public class WSDLView {
    private static Log log = LogFactory.getLog((Class)WSDLView.class);

    public OMElement getOptions() throws AxisFault {
        InputStream ins = this.getClass().getResourceAsStream("wsdlview-options.xml");
        if (ins == null) {
            ins = Thread.currentThread().getContextClassLoader().getResourceAsStream("wsdlview-options.xml");
        }
        if (ins == null) {
            String msg = WSDLView.class.getName() + " wsdlview-options.xml cannot be located in the classpath";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        try {
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(ins);
            StAXOMBuilder builder = new StAXOMBuilder(streamReader);
            OMElement ele = builder.getDocumentElement();
            ele.build();
            return ele;
        }
        catch (XMLStreamException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public String wsdlview(String[] options) throws AxisFault {
        File[] files;
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        String wsdlOutputDir = MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("WORK_DIR") + File.separator + "tools_wsdlview" + File.separator + uuid + File.separator;
        ArrayList<String> optionsList = new ArrayList<String>();
        boolean isXCAvailable = false;
        String xcValue = "";
        for (int j = 0; j < options.length; ++j) {
            if (options[j].equalsIgnoreCase("-xc")) {
                isXCAvailable = true;
                continue;
            }
            if (isXCAvailable) {
                xcValue = options[j];
                isXCAvailable = false;
                continue;
            }
            optionsList.add(options[j]);
        }
        optionsList.add("-o");
        optionsList.add(wsdlOutputDir);
        optionsList.add("-of");
        optionsList.add(uuid + ".xml");
        this.parseXC(xcValue, optionsList);
        String[] args = optionsList.toArray(new String[optionsList.size()]);
        Java2WSDLCommandLineOptionParser commandLineOptionParser = new Java2WSDLCommandLineOptionParser(args);
        try {
            Map allOptions = commandLineOptionParser.getAllOptions();
            List list = commandLineOptionParser.getInvalidOptions(new Java2WSDLOptionsValidator());
            if (list.size() > 0) {
                String faultOptions = "";
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Java2WSDLCommandLineOption commandLineOption = (Java2WSDLCommandLineOption)iterator.next();
                    String optionValue = commandLineOption.getOptionValue();
                    faultOptions = faultOptions + "Invalid input for [ " + commandLineOption.getOptionType() + (optionValue != null ? " : " + optionValue + " ]" : " ]") + "\n";
                }
                log.error((Object)faultOptions);
                throw new AxisFault(faultOptions);
            }
            new Java2WSDLCodegenEngine(allOptions).generate();
        }
        catch (Exception e) {
            String rootMsg = WSDLView.class.getName() + " Exception has occured.";
            Throwable throwable = e.getCause();
            if (throwable != null) {
                String tmpMsg = throwable.toString();
                if (tmpMsg.toString().indexOf("org.apache.axis2.AxisFault") > -1) {
                    tmpMsg = "Please provide the correct inputs to either -p2n or -xc";
                    log.error((Object)tmpMsg, throwable);
                    throw new AxisFault(tmpMsg);
                }
                log.error((Object)rootMsg, throwable);
                throw new AxisFault(throwable.toString());
            }
            String tmpMsg = e.toString();
            if (tmpMsg.indexOf("java.lang.StringIndexOutOfBoundsException") > -1) {
                tmpMsg = "Please provide the correct inputs to either -p2n or -xc";
                log.error((Object)tmpMsg, (Throwable)e);
                throw new AxisFault(tmpMsg);
            }
            log.error((Object)rootMsg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
        }
        if ((files = new File(wsdlOutputDir).listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".xml");
            }
        })) != null && files[0] != null && files[0].getAbsoluteFile() != null) {
            fileResourcesMap.put(uuid, files[0].getAbsoluteFile().getAbsolutePath());
        }
        return "/filedownload?id=" + uuid;
    }

    public String wsdlviewWithResources(String[] options, String[] uuids) throws AxisFault {
        Map fileResourcesMap = (Map)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            String msg = WSDLView.class.getName() + " File resource map couldn't be located";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> pathList = new ArrayList<URL>();
        if (uuids != null && uuids.length >= 1) {
            for (int j = 0; j < uuids.length; ++j) {
                String path = (String)fileResourcesMap.get(uuids[j]);
                try {
                    if (path == null || path.length() == 0) continue;
                    pathList.add(new File(path).toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
        } else {
            String msg = WSDLView.class.getName() + " resources are missing";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        try {
            URL[] urls = pathList.toArray(new URL[pathList.size()]);
            URLClassLoader newCl = URLClassLoader.newInstance(urls, prevCl);
            Thread.currentThread().setContextClassLoader(newCl);
            String string = this.wsdlview(options);
            return string;
        }
        catch (AxisFault e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    private void parseXC(String value, ArrayList options) {
        if (value == null || value.length() == 0) {
            return;
        }
        String[] tokens = value.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token == null || token.length() == 0) continue;
            options.add("-xc");
            options.add(token);
        }
    }
}

