/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIUtils {
    private static final Log log = LogFactory.getLog((Class)JNDIUtils.class);

    public static DataSource getDataSource(AxisService axisService) throws AxisFault {
        Parameter resource;
        Parameter contextUrl;
        Parameter factoryClass;
        Parameter password;
        Properties properties = null;
        Parameter username = axisService.getParameter("jndi_username");
        if (username != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty("java.naming.security.principal", ((String)username.getValue()).trim());
        }
        if ((password = axisService.getParameter("jndi_password")) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty("java.naming.security.credentials", ((String)password.getValue()).trim());
        }
        if ((factoryClass = axisService.getParameter("jndi_context_class")) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty("java.naming.factory.initial", ((String)factoryClass.getValue()).trim());
        }
        if ((contextUrl = axisService.getParameter("jndi_provider_url")) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty("java.naming.provider.url", ((String)contextUrl.getValue()).trim());
        }
        if ((resource = axisService.getParameter("jndi_resource_name")) == null) {
            log.error((Object)"JNDI Resource name not specified in Data Service Configuration file");
            return null;
        }
        try {
            InitialContext context = JNDIUtils.getContext(properties);
            Object obj = JNDIUtils.getJNDIResource(context, (String)resource.getValue());
            if (obj != null) {
                DataSource dataSource = (DataSource)obj;
                return dataSource;
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error retrieving properties from AxisService", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            log.error((Object)"Naming error occurred while trying to retrieve JDBC Connection from JNDI tree.", (Throwable)e);
            throw new AxisFault("Naming error occurred while trying to retrieve JDBC Connection from JNDI tree.", (Throwable)e);
        }
        return null;
    }

    private static InitialContext getContext(Properties properties) throws AxisFault, NamingException {
        return new InitialContext(properties);
    }

    private static Object getJNDIResource(InitialContext context, String resourceName) throws AxisFault, NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up for resource : " + resourceName));
        }
        Object obj = context.lookup(resourceName);
        return obj;
    }
}

