/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.TimerTask;
import javax.sql.DataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.ws.dataservice.DBCPConnectionManager;
import org.wso2.ws.dataservice.DBDeployer;
import org.wso2.ws.dataservice.DBUtils;
import org.wso2.ws.dataservice.beans.Config;

public class FaultyServiceRectifier
extends TimerTask {
    private static final Log log = LogFactory.getLog((Class)FaultyServiceRectifier.class);
    private ConfigurationContext configurationCtx;
    private Config config;
    private DeploymentFileData deploymentFileData;

    public FaultyServiceRectifier(AxisService service, DeploymentFileData deploymentData, ConfigurationContext configCtx, Config dataServiceConfigSection) {
        this.deploymentFileData = deploymentData;
        this.configurationCtx = configCtx;
        this.config = dataServiceConfigSection;
    }

    public boolean cancel() {
        return super.cancel();
    }

    public void run() {
        String deploymentFileName = "";
        try {
            deploymentFileName = this.deploymentFileData.getFile().getAbsolutePath();
            log.info((Object)("Trying to re-establish fautly database connection for data services :" + deploymentFileName));
            DBCPConnectionManager dbcpConnectionManager = DBUtils.initializeDBConnectionManager(deploymentFileName, this.config);
            DataSource dataSource = dbcpConnectionManager.getDatasource();
            if (dataSource != null) {
                Connection connection = dataSource.getConnection();
                log.info((Object)("Database connection successful. Removing " + deploymentFileName + " from Fault Service list."));
                this.configurationCtx.getAxisConfiguration().getFaultyServices().remove(deploymentFileName);
                this.cancel();
                DBDeployer dbDeployer = new DBDeployer();
                dbDeployer.init(this.configurationCtx);
                dbDeployer.deploy(this.deploymentFileData);
            } else {
                log.error((Object)("Database connection re-establishment for " + deploymentFileName + " failed.Retrying..."));
            }
        }
        catch (AxisFault e) {
            log.error((Object)("Error occurred while trying to re-establish database connection for " + deploymentFileName + ".Retrying...."), (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)("Error occurred while trying to re-establish database connection for " + deploymentFileName + ".Retrying...."), (Throwable)e);
        }
    }
}

