/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.wso2.ws.dataservice.DBCPConnectionManager;
import org.wso2.ws.dataservice.beans.CSVQuery;
import org.wso2.ws.dataservice.beans.Config;
import org.wso2.ws.dataservice.beans.ExcelQuery;
import org.wso2.ws.dataservice.beans.Param;
import org.wso2.ws.dataservice.beans.Query;
import org.wso2.ws.dataservice.beans.Result;

public class DBUtils {
    private static final Log log = LogFactory.getLog((Class)DBUtils.class);

    public static OMNode toOM(Reader reader) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((Reader)reader);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
        return staxOMBuilder.getDocumentElement();
    }

    private static OMElement processSQLQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) {
        HashMap<String, String> inputs = new HashMap<String, String>();
        Iterator iter = inputMessage.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            inputs.put(element.getLocalName().toLowerCase(), element.getText());
        }
        OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
        return DBUtils.getRDBMSResult(callQueryElement, axisService, inputs, 0);
    }

    private static OMElement getRDBMSResult(OMElement callQueryElement, AxisService axisService, HashMap inputs, int queryLevel) {
        OMElement resultElement = null;
        try {
            OMElement queryElement;
            String href = callQueryElement.getAttributeValue(new QName("href"));
            if (href != null) {
                HashMap queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                queryElement = (OMElement)queries.get(href);
            } else {
                queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<Integer, String> paramOrder = new HashMap<Integer, String>();
            HashMap<Integer, String> originalParamNames = new HashMap<Integer, String>();
            HashMap<String, String> paramType = new HashMap<String, String>();
            Iterator iParams = queryElement.getChildrenWithName(new QName("param"));
            int position = 0;
            while (iParams.hasNext()) {
                OMElement param = (OMElement)iParams.next();
                String inOutType = param.getAttributeValue(new QName("type"));
                String paramName = param.getAttributeValue(new QName("name"));
                String sqlType = param.getAttributeValue(new QName("sqlType"));
                if (inOutType == null || inOutType.trim().length() == 0) {
                    inOutType = "IN";
                }
                params.put(paramName.toLowerCase(), sqlType);
                paramOrder.put(new Integer(position + 1), paramName.toLowerCase());
                originalParamNames.put(new Integer(position + 1), paramName);
                paramType.put(paramName.toLowerCase(), inOutType);
                ++position;
            }
            String query = queryElement.getFirstChildWithName(new QName("sql")).getText();
            String firstPartOfSQL = query.substring(0, 6);
            resultElement = firstPartOfSQL.equalsIgnoreCase("SELECT") ? DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, originalParamNames, paramType, axisService, false, queryLevel) : (firstPartOfSQL.equalsIgnoreCase("INSERT") || firstPartOfSQL.equalsIgnoreCase("UPDATE") || firstPartOfSQL.equalsIgnoreCase("DELETE") || firstPartOfSQL.equalsIgnoreCase("CREATE") ? DBUtils.getSelectResult(queryElement, inputs, params, paramOrder, originalParamNames, paramType, axisService, true, queryLevel) : DBUtils.getStoredProcedureResult(queryElement, inputs, params, paramOrder, originalParamNames, paramType, axisService, queryLevel));
        }
        catch (Exception e) {
            log.error((Object)"Error occured", (Throwable)e);
            return DBUtils.generateErrorResponse(axisService.getTargetNamespace(), (AxisFault)((Object)e));
        }
        return resultElement;
    }

    private static OMElement generateErrorResponse(String targetNamespace, AxisFault e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(targetNamespace, "data");
        OMElement resultElement = fac.createOMElement("data", omNs);
        OMElement faultElement = fac.createOMElement("fault", null);
        OMElement codeElement = fac.createOMElement("code", omNs);
        codeElement.setText(e.getMessage());
        OMElement detailElement = fac.createOMElement("detail", omNs);
        detailElement.setText(sw.toString());
        faultElement.addChild((OMNode)codeElement);
        faultElement.addChild((OMNode)detailElement);
        resultElement.addChild((OMNode)faultElement);
        return resultElement;
    }

    private static Connection checkDBConnectionStatus(AxisService axisService, Connection conn) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"checking database connection status");
        }
        if ("RDBMS".equals((String)axisService.getParameterValue("DATASOURCE_TYPE")) || "JNDI".equals((String)axisService.getParameterValue("DATASOURCE_TYPE"))) {
            try {
                if (conn == null || conn.isClosed()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Database connection is closed.Trying to re-establish.");
                    }
                    Config config = (Config)axisService.getParameterValue("org.wso2.ws.dataservice.config");
                    return DBUtils.createConnection(axisService, config);
                }
                return conn;
            }
            catch (SQLException e) {
                log.error((Object)"Error occurred while trying to re-establish the database connection.", (Throwable)e);
                throw new AxisFault("Error occurred while trying to re-establish the database connection.", (Throwable)e);
            }
        }
        return null;
    }

    private static OMElement getStoredProcedureResult(OMElement queryElement, HashMap inputValues, HashMap params, HashMap paramOrder, HashMap originalParamNames, HashMap paramType, AxisService axisService, int queryLevel) throws AxisFault {
        OMElement resultElement = null;
        Connection conn = null;
        boolean noResultSet = false;
        boolean hasResponse = true;
        OMNamespace omNs = null;
        String sqlQuery = queryElement.getFirstChildWithName(new QName("sql")).getText();
        try {
            conn = DBUtils.checkDBConnectionStatus(axisService, conn);
            conn.setAutoCommit(false);
            CallableStatement cs = (CallableStatement)DBUtils.getProcessedPreparedStatement(inputValues, params, paramOrder, originalParamNames, paramType, conn, sqlQuery, "STORED-PROCEDURE", axisService.getName());
            ResultSet rs = null;
            try {
                rs = cs.executeQuery();
                if (rs.getMetaData().getColumnCount() == 0) {
                    noResultSet = true;
                }
            }
            catch (SQLException e) {
                if (e.getMessage().indexOf("java.sql.CallableStatement.executeQuery() was called but no result set was returned. Use java.sql.CallableStatement.executeUpdate() for non-queries.") > -1) {
                    noResultSet = true;
                    cs.executeUpdate();
                }
                log.error((Object)"Error occured getting stored procedure result", (Throwable)e);
            }
            OMElement result = queryElement.getFirstChildWithName(new QName("result"));
            String prefix = null;
            String resultElementNS = null;
            Query query = new Query(queryElement.getChildrenWithName(new QName("param")));
            if (result == null) {
                hasResponse = false;
            }
            if (hasResponse) {
                Result resultObj = new Result(result);
                resultElementNS = result.getAttributeValue(new QName("defaultNamespace"));
                if (resultElementNS == null || resultElementNS.trim().length() == 0) {
                    resultElementNS = axisService.getTargetNamespace();
                }
                String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
                OMFactory fac = OMAbstractFactory.getOMFactory();
                HashMap namespacePrefixMap = null;
                HashMap queryLevelNamespaceMap = null;
                HashMap queryLevelPrefixMap = null;
                if (axisService.getParameterValue("org.wso2.ws.dataservice.namespaceprefixmap") != null) {
                    namespacePrefixMap = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.namespaceprefixmap");
                    queryLevelNamespaceMap = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.querylevelnamespacemap");
                    queryLevelPrefixMap = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.querylevelprefixmap");
                    prefix = (String)namespacePrefixMap.get(resultElementNS);
                    if (prefix == null) {
                        prefix = "data" + BeanUtil.getUniquePrefix();
                        namespacePrefixMap.put(resultElementNS, prefix);
                        queryLevelNamespaceMap.put(new Integer(queryLevel), resultElementNS);
                        queryLevelPrefixMap.put(new Integer(queryLevel), prefix);
                    }
                } else {
                    namespacePrefixMap = new HashMap();
                    queryLevelNamespaceMap = new HashMap();
                    queryLevelPrefixMap = new HashMap();
                    prefix = "data" + BeanUtil.getUniquePrefix();
                    namespacePrefixMap.put(resultElementNS, prefix);
                    queryLevelNamespaceMap.put(new Integer(queryLevel), resultElementNS);
                    queryLevelPrefixMap.put(new Integer(queryLevel), prefix);
                    axisService.addParameter("org.wso2.ws.dataservice.namespaceprefixmap", (Object)namespacePrefixMap);
                    axisService.addParameter("org.wso2.ws.dataservice.querylevelnamespacemap", (Object)queryLevelNamespaceMap);
                    axisService.addParameter("org.wso2.ws.dataservice.querylevelprefixmap", (Object)queryLevelPrefixMap);
                }
                omNs = fac.createOMNamespace(resultElementNS, prefix);
                if (queryLevel > 0) {
                    String previousNS = (String)queryLevelNamespaceMap.get(new Integer(queryLevel - 1));
                    String previousNSPrefix = (String)queryLevelPrefixMap.get(new Integer(queryLevel - 1));
                    omNs = fac.createOMNamespace(previousNS, previousNSPrefix);
                    resultElement = fac.createOMElement(resultObj.getResultWrapper(), omNs);
                } else {
                    resultElement = fac.createOMElement(resultObj.getResultWrapper(), omNs);
                }
                Iterator tmpElements = result.getChildElements();
                ArrayList<OMElement> tmpElementsArrayList = new ArrayList<OMElement>();
                while (tmpElements.hasNext()) {
                    OMElement element = (OMElement)tmpElements.next();
                    tmpElementsArrayList.add(element);
                }
                if (!noResultSet && rs != null) {
                    while (rs.next()) {
                        HashMap<String, String> elementValues = new HashMap<String, String>();
                        int columnCount = rs.getMetaData().getColumnCount();
                        if (queryLevel > 0) {
                            omNs = fac.createOMNamespace(resultElementNS, prefix);
                        }
                        OMElement row = fac.createOMElement(resultObj.getRowName(), omNs);
                        if (resultObj.getRowName() == null) {
                            row = resultElement;
                        }
                        for (int i = 1; i <= columnCount; ++i) {
                            String columnName = rs.getMetaData().getColumnLabel(i);
                            columnName = columnName.toLowerCase();
                            String columnValue = rs.getString(columnName);
                            elementValues.put(columnName, columnValue);
                        }
                        boolean useAsParamToNextQuery = false;
                        for (int a = 0; a < resultObj.getDisplayColumnNames().length; ++a) {
                            String outPutElementType = resultObj.getElementLocalNames()[a];
                            if (outPutElementType.equals("element") || outPutElementType.equals("attribute")) {
                                String elementValue;
                                String displayTagName = resultObj.getDisplayColumnNames()[a];
                                String resultSetFieldName = resultObj.getResultSetColumnNames()[a];
                                resultSetFieldName = resultSetFieldName.toLowerCase();
                                if (useAsParamToNextQuery) {
                                    elementValue = (String)params.get(resultSetFieldName);
                                    elementValues.put(resultSetFieldName, elementValue);
                                } else {
                                    elementValue = (String)elementValues.get(resultSetFieldName);
                                }
                                if (elementValue == null) {
                                    elementValue = DBUtils.setOutparameterValue(cs, query, resultSetFieldName);
                                }
                                if (outPutElementType.equals("element")) {
                                    OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                                    rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                                    row.addChild((OMNode)rowElement);
                                    continue;
                                }
                                if (!outPutElementType.equals("attribute")) continue;
                                row.addAttribute(displayTagName, elementValue, omNs);
                                continue;
                            }
                            if (!resultObj.getElementLocalNames()[a].equals("call-query")) continue;
                            OMElement element = (OMElement)tmpElementsArrayList.get(a);
                            OMElement rowElement = DBUtils.getRDBMSResult(element, axisService, elementValues, queryLevel + 1);
                            --queryLevel;
                            row.addChild((OMNode)rowElement);
                        }
                        if (resultObj.getRowName() == null) continue;
                        resultElement.addChild((OMNode)row);
                    }
                } else {
                    OMElement row = null;
                    if (resultObj.getRowName() != null) {
                        row = fac.createOMElement(resultObj.getRowName(), omNs);
                    }
                    for (int a = 0; a < resultObj.getDisplayColumnNames().length; ++a) {
                        if (!resultObj.getElementLocalNames()[a].equals("element")) continue;
                        String displayTagName = resultObj.getDisplayColumnNames()[a];
                        String resultSetFieldName = resultObj.getResultSetColumnNames()[a];
                        String elementValue = DBUtils.setOutparameterValue(cs, query, resultSetFieldName);
                        if (columnDefalut == null || columnDefalut.equals("element")) {
                            OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                            rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                            if (row != null) {
                                row.addChild((OMNode)rowElement);
                                continue;
                            }
                            resultElement.addChild((OMNode)rowElement);
                            continue;
                        }
                        if (!columnDefalut.equals("attribute")) continue;
                        if (row != null) {
                            row.addAttribute(displayTagName, elementValue, omNs);
                            continue;
                        }
                        resultElement.addAttribute(displayTagName, elementValue, omNs);
                    }
                    if (row != null) {
                        resultElement.addChild((OMNode)row);
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Exception occurred while trying to execute the SQL statement : " + sqlQuery), (Throwable)e);
            throw new AxisFault("Exception occurred while trying to execute the SQL statement : " + sqlQuery, (Throwable)e);
        }
        finally {
            try {
                if (conn != null && queryLevel == 0) {
                    conn.commit();
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
                throw new AxisFault("Exception occurred while trying to commit.", (Throwable)e);
            }
        }
        return resultElement;
    }

    private static String setOutparameterValue(CallableStatement cs, Query query, String resultSetFieldName) throws SQLException, AxisFault {
        String elementValue = "";
        Param param = query.getParam(resultSetFieldName);
        if (param != null && ("OUT".equals(param.getType()) || "INOUT".equals(param.getType()))) {
            if (param.getSqlType().equals("STRING")) {
                elementValue = cs.getString(param.getOrdinal());
            } else if (param.getSqlType().equals("DOUBLE")) {
                elementValue = String.valueOf(cs.getDouble(param.getOrdinal()));
            } else if (param.getSqlType().equals("BIGINT")) {
                elementValue = String.valueOf(cs.getLong(param.getOrdinal()));
            } else if (param.getSqlType().equals("INTEGER")) {
                elementValue = String.valueOf(cs.getInt(param.getOrdinal()));
            } else if (param.getSqlType().equals("TIME")) {
                elementValue = String.valueOf(cs.getTime(param.getOrdinal()));
            } else if (param.getSqlType().equals("DATE")) {
                elementValue = String.valueOf(cs.getDate(param.getOrdinal()));
            } else if (param.getSqlType().equals("TIMESTAMP")) {
                elementValue = String.valueOf(cs.getTimestamp(param.getOrdinal()));
            } else {
                log.error((Object)("Unsupported data type : " + param.getSqlType()));
                throw new AxisFault("Unsupported data type : " + param.getSqlType());
            }
        }
        return elementValue;
    }

    private static OMElement getSelectResult(OMElement queryElement, HashMap inputValues, HashMap params, HashMap paramOrder, HashMap originalParamNames, HashMap paramType, AxisService axisService, boolean isDML, int queryLevel) throws AxisFault {
        String prefix;
        OMElement resultElement = null;
        Connection conn = null;
        boolean hasResponse = true;
        OMFactory fac = null;
        OMNamespace omNs = null;
        Result resultObj = null;
        String sqlQuery = queryElement.getFirstChildWithName(new QName("sql")).getText();
        try {
            conn = DBUtils.checkDBConnectionStatus(axisService, conn);
            conn.setAutoCommit(false);
            PreparedStatement preparedStatement = DBUtils.getProcessedPreparedStatement(inputValues, params, paramOrder, originalParamNames, paramType, conn, sqlQuery, "SQL", axisService.getName());
            int responseCode = -1;
            ResultSet rs = null;
            OMElement result = queryElement.getFirstChildWithName(new QName("result"));
            prefix = null;
            String resultElementNS = null;
            if (isDML) {
                responseCode = preparedStatement.executeUpdate();
            } else {
                rs = preparedStatement.executeQuery();
            }
            if (result == null) {
                hasResponse = false;
            }
            if (hasResponse) {
                resultObj = new Result(result);
                resultElementNS = result.getAttributeValue(new QName("defaultNamespace"));
                if (resultElementNS == null || resultElementNS.trim().length() == 0) {
                    resultElementNS = axisService.getTargetNamespace();
                }
                fac = OMAbstractFactory.getOMFactory();
                HashMap namespacePrefixMap = null;
                HashMap queryLevelNamespaceMap = null;
                HashMap queryLevelPrefixMap = null;
                if (axisService.getParameterValue("org.wso2.ws.dataservice.namespaceprefixmap") != null) {
                    namespacePrefixMap = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.namespaceprefixmap");
                    queryLevelNamespaceMap = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.querylevelnamespacemap");
                    queryLevelPrefixMap = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.querylevelprefixmap");
                    prefix = (String)namespacePrefixMap.get(resultElementNS);
                    if (prefix == null) {
                        prefix = "data" + BeanUtil.getUniquePrefix();
                        namespacePrefixMap.put(resultElementNS, prefix);
                        queryLevelNamespaceMap.put(new Integer(queryLevel), resultElementNS);
                        queryLevelPrefixMap.put(new Integer(queryLevel), prefix);
                    }
                } else {
                    namespacePrefixMap = new HashMap();
                    queryLevelNamespaceMap = new HashMap();
                    queryLevelPrefixMap = new HashMap();
                    prefix = "data" + BeanUtil.getUniquePrefix();
                    namespacePrefixMap.put(resultElementNS, prefix);
                    queryLevelNamespaceMap.put(new Integer(queryLevel), resultElementNS);
                    queryLevelPrefixMap.put(new Integer(queryLevel), prefix);
                    axisService.addParameter("org.wso2.ws.dataservice.namespaceprefixmap", (Object)namespacePrefixMap);
                    axisService.addParameter("org.wso2.ws.dataservice.querylevelnamespacemap", (Object)queryLevelNamespaceMap);
                    axisService.addParameter("org.wso2.ws.dataservice.querylevelprefixmap", (Object)queryLevelPrefixMap);
                }
                omNs = fac.createOMNamespace(resultElementNS, prefix);
                if (queryLevel > 0) {
                    String previousNS = (String)queryLevelNamespaceMap.get(new Integer(queryLevel - 1));
                    String previousNSPrefix = (String)queryLevelPrefixMap.get(new Integer(queryLevel - 1));
                    omNs = fac.createOMNamespace(previousNS, previousNSPrefix);
                    resultElement = fac.createOMElement(resultObj.getResultWrapper(), omNs);
                } else {
                    resultElement = fac.createOMElement(resultObj.getResultWrapper(), omNs);
                }
            }
            if (isDML) {
                if (hasResponse) {
                    resultElement.setText("Your query executed successfully. Return code from the database was " + responseCode);
                }
            } else {
                Iterator tmpElements = result.getChildElements();
                ArrayList<OMElement> tmpElementsArrayList = new ArrayList<OMElement>();
                while (tmpElements.hasNext()) {
                    OMElement element = (OMElement)tmpElements.next();
                    tmpElementsArrayList.add(element);
                }
                while (rs.next()) {
                    HashMap<String, String> elementValues = new HashMap<String, String>();
                    int columnCount = rs.getMetaData().getColumnCount();
                    if (queryLevel > 0) {
                        omNs = fac.createOMNamespace(resultElementNS, prefix);
                    }
                    OMElement row = fac.createOMElement(resultObj.getRowName(), omNs);
                    if (resultObj.getRowName() == null) {
                        row = resultElement;
                    }
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = rs.getMetaData().getColumnLabel(i);
                        columnName = columnName.toLowerCase();
                        String columnValue = rs.getString(columnName);
                        elementValues.put(columnName, columnValue);
                    }
                    boolean useAsParamToNextQuery = false;
                    for (int a = 0; a < resultObj.getDisplayColumnNames().length; ++a) {
                        String outPutElementType = resultObj.getElementLocalNames()[a];
                        if (outPutElementType.equals("element") || outPutElementType.equals("attribute")) {
                            String elementValue;
                            String displayTagName = resultObj.getDisplayColumnNames()[a];
                            String resultSetFieldName = resultObj.getResultSetColumnNames()[a];
                            resultSetFieldName = resultSetFieldName.toLowerCase();
                            if (useAsParamToNextQuery) {
                                elementValue = (String)params.get(resultSetFieldName);
                                elementValues.put(resultSetFieldName, elementValue);
                            } else {
                                elementValue = (String)elementValues.get(resultSetFieldName);
                            }
                            if (outPutElementType.equals("element")) {
                                OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                                rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                                row.addChild((OMNode)rowElement);
                                continue;
                            }
                            if (!outPutElementType.equals("attribute")) continue;
                            row.addAttribute(displayTagName, elementValue, omNs);
                            continue;
                        }
                        if (!resultObj.getElementLocalNames()[a].equals("call-query")) continue;
                        OMElement element = (OMElement)tmpElementsArrayList.get(a);
                        OMElement rowElement = DBUtils.getRDBMSResult(element, axisService, elementValues, queryLevel + 1);
                        row.addChild((OMNode)rowElement);
                    }
                    if (resultObj.getRowName() == null) continue;
                    resultElement.addChild((OMNode)row);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("[" + axisService.getName() + "] Exception occurred while trying to execute the SQL statement : " + sqlQuery), (Throwable)e);
            throw new AxisFault("[" + axisService.getName() + "] Exception occurred while trying to execute the SQL statement : " + sqlQuery, (Throwable)e);
        }
        finally {
            try {
                if (conn != null && queryLevel == 0) {
                    conn.commit();
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Exception occured while trying to close the DB connection.", (Throwable)e);
                throw new AxisFault("Exception occured while trying to close the DB connection.", (Throwable)e);
            }
        }
        if (queryLevel <= 0 && hasResponse) {
            HashMap allNamespaces = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.namespaceprefixmap");
            Set keySet = allNamespaces.keySet();
            Iterator keySetItr = keySet.iterator();
            while (keySetItr.hasNext()) {
                String namespaceURI = (String)keySetItr.next();
                prefix = (String)allNamespaces.get(namespaceURI);
                resultElement.declareNamespace(namespaceURI, prefix);
            }
        }
        return resultElement;
    }

    public static OMElement invoke(MessageContext msgContext) throws AxisFault {
        AxisOperation axisOp = msgContext.getAxisOperation();
        AxisService axisService = msgContext.getAxisService();
        OMElement inputMessage = msgContext.getEnvelope().getBody().getFirstElement();
        OMElement operationElement = (OMElement)axisOp.getParameterValue("org.wso2.ws.dataservice.db_operation_element");
        if ("CSV".equals((String)axisService.getParameterValue("DATASOURCE_TYPE"))) {
            return DBUtils.processCSVQuery(operationElement, axisService, inputMessage);
        }
        if ("EXCEL".equals((String)axisService.getParameterValue("DATASOURCE_TYPE"))) {
            return DBUtils.processExcelQuery(operationElement, axisService, inputMessage);
        }
        return DBUtils.processSQLQuery(operationElement, axisService, inputMessage);
    }

    private static boolean checkLibraryAvailability(String libraryName) throws AxisFault {
        try {
            if ("POI".equals(libraryName)) {
                Class.forName("org.apache.poi.poifs.filesystem.POIFSFileSystem");
            } else if ("OpenCSV".equals(libraryName)) {
                Class.forName("au.com.bytecode.opencsv.CSVReader");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Library not found for : " + libraryName), (Throwable)e);
            throw new AxisFault("Library not found for : " + libraryName, (Throwable)e);
        }
    }

    private static OMElement processExcelQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) throws AxisFault {
        String excelFilePath = (String)axisService.getParameterValue("excel_datasource");
        log.info((Object)("Using Excel file from : " + excelFilePath));
        InputStream dataSourceInputStream = null;
        try {
            OMElement queryElement;
            DBUtils.checkLibraryAvailability("POI");
            if (excelFilePath.startsWith("http://")) {
                URL url = new URL(excelFilePath);
                dataSourceInputStream = url.openStream();
            } else {
                dataSourceInputStream = new FileInputStream(excelFilePath);
            }
            POIFSFileSystem fs = new POIFSFileSystem(dataSourceInputStream);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
            String href = callQueryElement.getAttributeValue(new QName("href"));
            if (href != null) {
                HashMap queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                queryElement = (OMElement)queries.get(href);
            } else {
                queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
            }
            OMElement oMElement = DBUtils.getExcelResult(wb, queryElement, axisService);
            return oMElement;
        }
        catch (FileNotFoundException e1) {
            log.error((Object)("Excel file not fould : " + excelFilePath), (Throwable)e1);
            throw new AxisFault("Excel file not fould : " + excelFilePath);
        }
        catch (IOException e) {
            log.error((Object)("Error loading Excel file : " + excelFilePath), (Throwable)e);
            throw new AxisFault("Error loading Excel file : " + excelFilePath);
        }
        finally {
            if (dataSourceInputStream != null) {
                try {
                    dataSourceInputStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)("Error occured while close InputStream for : " + excelFilePath), (Throwable)e);
                }
            }
        }
    }

    private static OMElement getExcelResult(HSSFWorkbook wb, OMElement queryElement, AxisService axisService) throws AxisFault {
        OMElement resultElement = null;
        ExcelQuery excelQuery = new ExcelQuery(axisService, queryElement);
        OMElement result = queryElement.getFirstChildWithName(new QName("result"));
        String wrapperElementName = result.getAttributeValue(new QName("element"));
        String rowElementName = result.getAttributeValue(new QName("rowName"));
        String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(axisService.getTargetNamespace(), "data");
        resultElement = fac.createOMElement(wrapperElementName, omNs);
        if (!axisService.isElementFormDefault()) {
            omNs = fac.createOMNamespace("", "data");
        }
        String sheetName = excelQuery.getWorkBookName();
        int startReadingFromRow = excelQuery.getStartingRow();
        if (startReadingFromRow >= 0) {
            --startReadingFromRow;
        }
        int maxRowCount = excelQuery.getMaxRowCount();
        HSSFSheet sheet = wb.getSheet(sheetName);
        int rowCount = sheet.getPhysicalNumberOfRows();
        HSSFRow firstRow = null;
        if (excelQuery.hasHeaders()) {
            firstRow = sheet.getRow(0);
        }
        int processedRowCount = 0;
        for (int r = 0; r < rowCount; ++r) {
            if (r < startReadingFromRow) continue;
            if (processedRowCount == maxRowCount) break;
            HSSFRow hssfRow = sheet.getRow(r);
            OMElement row = fac.createOMElement(rowElementName, omNs);
            if (rowElementName == null) {
                row = resultElement;
            }
            Iterator elements = result.getChildElements();
            while (elements.hasNext()) {
                short columnNumber;
                OMElement element = (OMElement)elements.next();
                if (!element.getLocalName().equals("element")) continue;
                String displayTagName = element.getAttributeValue(new QName("name"));
                String columnValue = element.getAttributeValue(new QName("column"));
                short a = 1;
                if (excelQuery.hasHeaders()) {
                    columnNumber = DBUtils.getExcelColumnNumber(columnValue, firstRow);
                } else {
                    try {
                        columnNumber = (short)(Short.valueOf(columnValue) - a);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Column value for element : " + displayTagName + " should be a number."), (Throwable)e);
                        throw new AxisFault("Column value for element : " + displayTagName + " should be a number.");
                    }
                }
                HSSFCell hssfCell = hssfRow.getCell(columnNumber);
                String elementValue = "";
                if (hssfCell != null) {
                    if (1 == hssfCell.getCellType()) {
                        elementValue = hssfCell.getRichStringCellValue().getString();
                    } else if (3 != hssfCell.getCellType()) {
                        if (4 == hssfCell.getCellType()) {
                            elementValue = String.valueOf(hssfCell.getBooleanCellValue());
                        } else if (2 == hssfCell.getCellType()) {
                            elementValue = "{formula}";
                        } else if (0 == hssfCell.getCellType()) {
                            elementValue = String.valueOf(hssfCell.getNumericCellValue());
                        }
                    }
                }
                if (columnDefalut == null || columnDefalut.equals("element")) {
                    OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                    rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                    row.addChild((OMNode)rowElement);
                    continue;
                }
                if (!columnDefalut.equals("attribute")) continue;
                row.addAttribute(displayTagName, elementValue, omNs);
            }
            if (rowElementName == null) continue;
            resultElement.addChild((OMNode)row);
            ++processedRowCount;
        }
        return resultElement;
    }

    private static short getExcelColumnNumber(String columnName, HSSFRow headerRow) throws AxisFault {
        int noOfCells = headerRow.getPhysicalNumberOfCells();
        short columnNo = -1;
        for (int a = 0; a < noOfCells; ++a) {
            HSSFCell cell = headerRow.getCell((short)a);
            if (1 == cell.getCellType()) {
                if (!columnName.equals(cell.getRichStringCellValue().getString())) continue;
                columnNo = (short)a;
                break;
            }
            if (0 != cell.getCellType()) continue;
            try {
                double columnNameInDouble = Double.valueOf(columnName);
                if (columnNameInDouble != cell.getNumericCellValue()) continue;
                columnNo = (short)a;
                break;
            }
            catch (NumberFormatException e) {
                log.error((Object)("Numeric value expected for Column Name : " + columnName), (Throwable)e);
                throw new AxisFault("Numeric value expected for Column Name : " + columnName, (Throwable)e);
            }
        }
        return columnNo;
    }

    private static OMElement processCSVQuery(OMElement operationElement, AxisService axisService, OMElement inputMessage) throws AxisFault {
        String csvFilePath = (String)axisService.getParameterValue("csv_datasource");
        log.info((Object)("Using CSV file from : " + csvFilePath));
        CSVReader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            OMElement queryElement;
            HashMap queries;
            if (csvFilePath.startsWith("http://")) {
                URL url = new URL(csvFilePath);
                inputStreamReader = new InputStreamReader(url.openStream());
                reader = new CSVReader((Reader)inputStreamReader);
            } else {
                if (csvFilePath.startsWith("." + File.separator) || csvFilePath.startsWith(".." + File.separator)) {
                    File csvFile = new File(csvFilePath);
                    csvFilePath = csvFile.getAbsolutePath();
                    log.info((Object)("relative file path reference found. Using " + csvFilePath + " as absolute path."));
                }
                reader = new CSVReader((Reader)new FileReader(csvFilePath));
            }
            OMElement callQueryElement = operationElement.getFirstChildWithName(new QName("call-query"));
            String href = callQueryElement.getAttributeValue(new QName("href"));
            if (href != null) {
                queries = (HashMap)axisService.getParameterValue("org.wso2.ws.dataservice.db_query_elements");
                queryElement = (OMElement)queries.get(href);
            } else {
                queryElement = callQueryElement.getFirstChildWithName(new QName("query"));
            }
            try {
                queries = DBUtils.getCSVResult(reader, queryElement, axisService);
                return queries;
            }
            catch (AxisFault e) {
                try {
                    throw e;
                }
                catch (FileNotFoundException e2) {
                    log.error((Object)("CSV file not found : " + csvFilePath), (Throwable)e2);
                    throw new AxisFault("CSV file not found : " + csvFilePath, (Throwable)e2);
                }
                catch (MalformedURLException e3) {
                    log.error((Object)("Incorrect URL : " + csvFilePath), (Throwable)e3);
                    throw new AxisFault("Incorrect URL : " + csvFilePath, (Throwable)e3);
                }
                catch (IOException e4) {
                    log.error((Object)("Error opening stream for : " + csvFilePath), (Throwable)e4);
                    throw new AxisFault("Error opening stream for : " + csvFilePath, (Throwable)e4);
                }
            }
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static OMElement getCSVResult(CSVReader reader, OMElement queryElement, AxisService axisService) throws AxisFault {
        String[] nextLine;
        OMElement resultElement = null;
        CSVQuery csvQuery = new CSVQuery(axisService);
        int start = csvQuery.getStartingRow();
        int end = csvQuery.getMaxRowCount();
        int noOfRowsToRead = 0;
        noOfRowsToRead = end == -1 ? -1 : end;
        if (start >= 0) {
            --start;
        }
        OMElement result = queryElement.getFirstChildWithName(new QName("result"));
        String wrapperElementName = result.getAttributeValue(new QName("element"));
        String rowElementName = result.getAttributeValue(new QName("rowName"));
        String columnDefalut = result.getAttributeValue(new QName("columnDefault"));
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(axisService.getTargetNamespace(), "data");
        resultElement = fac.createOMElement(wrapperElementName, omNs);
        if (!axisService.isElementFormDefault()) {
            omNs = fac.createOMNamespace("", "data");
        }
        int[] columnNumbersToRead = null;
        if (csvQuery.hasHeaders()) {
            try {
                nextLine = reader.readNext();
                columnNumbersToRead = new int[csvQuery.getColumnNames().length];
                int index = 0;
                for (int b = 0; b < nextLine.length; ++b) {
                    String realColumnName = nextLine[b];
                    if (!csvQuery.isColumnNameMentioned(realColumnName)) continue;
                    columnNumbersToRead[index] = b;
                    ++index;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error reading header record", (Throwable)e);
                throw new AxisFault("Error reading header record", (Throwable)e);
            }
        } else {
            columnNumbersToRead = new int[csvQuery.getColumnNames().length];
            String colNo = "";
            for (int a = 0; a < csvQuery.getColumnNames().length; ++a) {
                try {
                    colNo = csvQuery.getColumnNames()[a];
                    columnNumbersToRead[a] = Integer.valueOf(colNo);
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)("When headers are set to false, you need to have numeric value for column.Incorrect value found : " + colNo), (Throwable)e);
                    throw new AxisFault("When headers are set to false, you need to have numeric value for column.Incorrect value found : " + colNo, (Throwable)e);
                }
            }
        }
        try {
            int processedRowCount = 0;
            while ((nextLine = reader.readNext()) != null) {
                if (nextLine.length == 1 && (nextLine[0] == null || nextLine[0].trim().equals(""))) continue;
                if (noOfRowsToRead != -1 && processedRowCount + start == noOfRowsToRead + start) break;
                if (start > processedRowCount + 1) {
                    ++processedRowCount;
                    continue;
                }
                HashMap<Integer, String> elementValues = new HashMap<Integer, String>();
                int columnCount = csvQuery.getColumnNames().length;
                OMElement row = fac.createOMElement(rowElementName, omNs);
                if (rowElementName == null) {
                    row = resultElement;
                }
                for (int i = 0; i < columnCount; ++i) {
                    int columnNo = columnNumbersToRead[i];
                    String columnValue = "";
                    try {
                        columnValue = nextLine[columnNo];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        log.info((Object)("Reading row : " + (processedRowCount + 1) + ".No value found " + "for column no : " + columnNo + ".Empty value will be printed."), (Throwable)e);
                    }
                    elementValues.put(new Integer(columnNo), columnValue);
                }
                Iterator elements = result.getChildElements();
                while (elements.hasNext()) {
                    OMElement element = (OMElement)elements.next();
                    if (!element.getLocalName().equals("element")) continue;
                    String displayTagName = element.getAttributeValue(new QName("name"));
                    String columnReference = element.getAttributeValue(new QName("column"));
                    int columnRef = 0;
                    try {
                        columnRef = Integer.valueOf(columnReference);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Column value specified " + columnReference + " for " + displayTagName + " should be a numeric value."), (Throwable)e);
                        throw new AxisFault("Column value specified " + columnReference + " for " + displayTagName + " should be a numeric value.", (Throwable)e);
                    }
                    String elementValue = (String)elementValues.get(new Integer(columnRef - 1));
                    if (columnDefalut == null || columnDefalut.equals("element")) {
                        OMElement rowElement = fac.createOMElement(displayTagName, omNs);
                        rowElement.addChild((OMNode)fac.createOMText((OMContainer)rowElement, elementValue));
                        row.addChild((OMNode)rowElement);
                        continue;
                    }
                    if (!columnDefalut.equals("attribute")) continue;
                    row.addAttribute(displayTagName, elementValue, omNs);
                }
                if (rowElementName != null) {
                    resultElement.addChild((OMNode)row);
                }
                ++processedRowCount;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading CSV file.", (Throwable)e);
            throw new AxisFault("Error reading CSV file.", (Throwable)e);
        }
        return resultElement;
    }

    public static Connection createConnection(AxisService axisService, Config config) throws AxisFault {
        try {
            log.debug((Object)("Getting database connection for " + axisService.getName()));
            Connection conn = null;
            if (config.getPropertyValue("org.wso2.ws.dataservice.minpoolsize") != null || config.getPropertyValue("org.wso2.ws.dataservice.maxpoolsize") != null) {
                DataSource dataSource = (DataSource)axisService.getParameterValue("org.wso2.ws.dataservice.dbconnection");
                conn = dataSource.getConnection();
            } else {
                Class.forName(config.getPropertyValue("org.wso2.ws.dataservice.driver")).newInstance();
                Properties props = new Properties();
                props.put("user", config.getPropertyValue("org.wso2.ws.dataservice.user"));
                props.put("password", config.getPropertyValue("org.wso2.ws.dataservice.password"));
                conn = DriverManager.getConnection(config.getPropertyValue("org.wso2.ws.dataservice.protocol"), props);
            }
            return conn;
        }
        catch (SQLException e) {
            log.error((Object)"Error occured while connecting to database", (Throwable)e);
            throw new AxisFault("Error occured while connecting to database", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("JDBC driver not available in classpath : " + e.getMessage()));
            throw new AxisFault("JDBC driver not available in classpath : " + e.getMessage());
        }
        catch (InstantiationException e) {
            log.error((Object)("Error occurred during instantiating " + config.getPropertyValue("org.wso2.ws.dataservice.driver")), (Throwable)e);
            throw new AxisFault("Error occurred during instantiating " + config.getPropertyValue("org.wso2.ws.dataservice.driver"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal Access error during loading " + config.getPropertyValue("org.wso2.ws.dataservice.driver")), (Throwable)e);
            throw new AxisFault("Illegal Access error during loading " + config.getPropertyValue("org.wso2.ws.dataservice.driver"), (Throwable)e);
        }
    }

    public static DBCPConnectionManager initializeDBConnectionManager(String serviceName, Config config) throws AxisFault {
        log.debug((Object)("Getting database connection for " + serviceName));
        DBCPConnectionManager dbcpConnectionManager = null;
        dbcpConnectionManager = new DBCPConnectionManager(config);
        return dbcpConnectionManager;
    }

    public static PreparedStatement getProcessedPreparedStatement(HashMap inputs, HashMap params, HashMap paramOrder, HashMap originalParamNames, HashMap paramTypes, Connection conn, String sqlStatement, String callee, String serviceName) throws AxisFault {
        String paramName = null;
        String originalParamName = null;
        String sqlType = null;
        String value = null;
        String paramType = null;
        log.debug((Object)("[" + serviceName + "] Processing prepared statement for SQL " + sqlStatement));
        Set paramNames = params.keySet();
        Object[] pramNameArray = paramNames.toArray();
        try {
            PreparedStatement sqlQuery = null;
            if ("SQL".equals(callee)) {
                sqlQuery = conn.prepareStatement(sqlStatement);
                if (sqlStatement.indexOf("?") > -1 && pramNameArray.length == 0) {
                    throw new AxisFault("[" + serviceName + "]  SQL : " + sqlStatement + " expects one or more parameters. " + "But none is mentioned in the configuration file.");
                }
            } else if ("STORED-PROCEDURE".equals(callee)) {
                sqlQuery = conn.prepareCall(sqlStatement);
            }
            for (int i = 0; i < pramNameArray.length; ++i) {
                paramName = (String)paramOrder.get(new Integer(i + 1));
                originalParamName = (String)originalParamNames.get(new Integer(i + 1));
                sqlType = (String)params.get(paramName);
                paramType = (String)paramTypes.get(paramName);
                value = (String)inputs.get(paramName);
                log.debug((Object)("[" + serviceName + "]  Param name : " + paramName + " SQL Type : " + sqlType + " Value : " + value));
                if (("IN".equals(paramType) || "INOUT".equals(paramType)) && (value == null || value.trim().length() == 0)) {
                    log.error((Object)("[" + serviceName + "]  Empty value found for parameter : " + originalParamName));
                    throw new AxisFault("[" + serviceName + "]  Empty value found for parameter : " + originalParamName);
                }
                if ("NULL".equalsIgnoreCase(value)) {
                    value = null;
                }
                if (sqlType == null) {
                    if ("IN".equals(paramType)) {
                        sqlQuery.setString(i + 1, value);
                        continue;
                    }
                    if ("INOUT".equals(paramType)) {
                        sqlQuery.setString(i + 1, value);
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
                        continue;
                    }
                    ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
                    continue;
                }
                if ("INTEGER".equals(sqlType)) {
                    if ("IN".equals(paramType)) {
                        if ("SQL".equals(callee)) {
                            sqlQuery.setInt(i + 1, Integer.parseInt(value));
                            continue;
                        }
                        ((CallableStatement)sqlQuery).setInt(i + 1, Integer.parseInt(value));
                        continue;
                    }
                    if ("INOUT".equals(paramType)) {
                        ((CallableStatement)sqlQuery).setInt(i + 1, Integer.parseInt(value));
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 4);
                        continue;
                    }
                    ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 4);
                    continue;
                }
                if ("STRING".equals(sqlType)) {
                    if ("IN".equals(paramType)) {
                        if ("SQL".equals(callee)) {
                            sqlQuery.setString(i + 1, value);
                            continue;
                        }
                        ((CallableStatement)sqlQuery).setString(i + 1, value);
                        continue;
                    }
                    if ("INOUT".equals(paramType)) {
                        ((CallableStatement)sqlQuery).setString(i + 1, value);
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
                        continue;
                    }
                    ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
                    continue;
                }
                if ("DOUBLE".equals(sqlType)) {
                    if ("IN".equals(paramType)) {
                        if ("SQL".equals(callee)) {
                            sqlQuery.setDouble(i + 1, Double.parseDouble(value));
                            continue;
                        }
                        ((CallableStatement)sqlQuery).setDouble(i + 1, Double.parseDouble(value));
                        continue;
                    }
                    if ("INOUT".equals(paramType)) {
                        ((CallableStatement)sqlQuery).setDouble(i + 1, Double.parseDouble(value));
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 8);
                        continue;
                    }
                    ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 8);
                    continue;
                }
                if ("DATE".equals(sqlType)) {
                    try {
                        String modifiedValue = value.substring(0, 10);
                        if ("IN".equals(paramType)) {
                            if ("SQL".equals(callee)) {
                                sqlQuery.setDate(i + 1, Date.valueOf(modifiedValue));
                                continue;
                            }
                            ((CallableStatement)sqlQuery).setDate(i + 1, Date.valueOf(modifiedValue));
                            continue;
                        }
                        if ("INOUT".equals(paramType)) {
                            ((CallableStatement)sqlQuery).setDate(i + 1, Date.valueOf(modifiedValue));
                            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 91);
                            continue;
                        }
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 91);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)("Incorrect date format(" + value + ") for parameter : " + paramName), (Throwable)e);
                        throw new AxisFault("Incorrect date format for parameter  : " + paramName + ".Date should be in yyyy-mm-dd format.", (Throwable)e);
                    }
                }
                if ("TIMESTAMP".equals(sqlType)) {
                    Timestamp timestamp = DBUtils.getTimestamp(value, paramName);
                    if ("IN".equals(paramType)) {
                        if ("SQL".equals(callee)) {
                            sqlQuery.setTimestamp(i + 1, timestamp);
                            continue;
                        }
                        ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp);
                        continue;
                    }
                    if ("INOUT".equals(paramType)) {
                        ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp);
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 93);
                        continue;
                    }
                    ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 93);
                    continue;
                }
                if ("TIME".equals(sqlType)) {
                    Time time = DBUtils.getTime(value, paramName);
                    if ("IN".equals(paramType)) {
                        if ("SQL".equals(callee)) {
                            sqlQuery.setTime(i + 1, time);
                            continue;
                        }
                        ((CallableStatement)sqlQuery).setTime(i + 1, time);
                        continue;
                    }
                    if ("INOUT".equals(paramType)) {
                        ((CallableStatement)sqlQuery).setTime(i + 1, time);
                        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 92);
                        continue;
                    }
                    ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 92);
                    continue;
                }
                log.error((Object)("[" + serviceName + "]  Unsupported data type : " + sqlType + " as input parameter."));
                throw new AxisFault("[" + serviceName + "]  Found Unsupported data type : " + sqlType + " as input parameter.");
            }
            return sqlQuery;
        }
        catch (NumberFormatException e) {
            log.error((Object)("[" + serviceName + "]  Incorrect value found for parameter : " + originalParamName), (Throwable)e);
            throw new AxisFault("[" + serviceName + "]  Incorrect value found for parameter : " + originalParamName, (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)("[" + serviceName + "]  Error occurred while preparing prepared statement for sql : " + sqlStatement), (Throwable)e);
            throw new AxisFault("[" + serviceName + "]  Error occurred while preparing prepared statement for sql : " + sqlStatement, (Throwable)e);
        }
    }

    private static Timestamp getTimestamp(String value, String paramName) throws AxisFault {
        Timestamp timestamp = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSSSSS");
            java.util.Date date = sdf.parse(value);
            timestamp = new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                java.util.Date date = sdf.parse(value);
                timestamp = new Timestamp(date.getTime());
            }
            catch (ParseException e1) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.sss'Z'");
                try {
                    java.util.Date date = sdf.parse(value);
                    timestamp = new Timestamp(date.getTime());
                }
                catch (ParseException e2) {
                    try {
                        sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.sss'+'hh:mm");
                        java.util.Date date = sdf.parse(value);
                        timestamp = new Timestamp(date.getTime());
                    }
                    catch (ParseException e3) {
                        try {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.sss'-'hh:mm");
                            java.util.Date date = sdf.parse(value);
                            timestamp = new Timestamp(date.getTime());
                        }
                        catch (ParseException e4) {
                            try {
                                sdf = new SimpleDateFormat("yyyy-MM-dd");
                                java.util.Date date = sdf.parse(value);
                                timestamp = new Timestamp(date.getTime());
                            }
                            catch (ParseException e5) {
                                log.error((Object)("Incorrect Timestamp format for parameter : " + paramName + ".Timestamp should be in one of following formats " + "yyyy-MM-dd'T'hh:mm:ss.sss'+'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'-'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'Z', " + "yyyy-MM-dd hh:mm:ss.SSSSSS or " + "yyyy-MM-dd hh:mm:ss"), (Throwable)e5);
                                throw new AxisFault("Incorrect Timestamp format for parameter : " + paramName + ".Timestamp should be in one of following formats " + "yyyy-MM-dd'T'hh:mm:ss.sss'+'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'-'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'Z', " + "yyyy-MM-dd hh:mm:ss.SSSSSS or " + "yyyy-MM-dd hh:mm:ss", (Throwable)e5);
                            }
                        }
                    }
                }
            }
        }
        return timestamp;
    }

    private static Time getTime(String value, String paramName) throws AxisFault {
        Time time;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
            java.util.Date date = sdf.parse(value);
            time = new Time(date.getTime());
        }
        catch (ParseException e) {
            log.error((Object)("Incorrect Time format for parameter : " + paramName + ".Time should be in the format hh:mm:ss"), (Throwable)e);
            throw new AxisFault("Incorrect Time format for parameter : " + paramName + ".Time should be in the format hh:mm:ss", (Throwable)e);
        }
        return time;
    }
}

