/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.ws.dataservice.beans.Config;

public class DBCPConnectionManager {
    private static final Log log = LogFactory.getLog((Class)DBCPConnectionManager.class);
    private DataSource datasource = null;
    private GenericObjectPool pool = null;

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource value) {
        this.datasource = value;
    }

    public DBCPConnectionManager(Config config) {
        try {
            this.connectToDB(config);
        }
        catch (Exception e) {
            log.error((Object)"Error occured connecting to database using connection pooling manager", (Throwable)e);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable e) {
            log.error((Object)"Error occured when finalizing.", e);
        }
    }

    private void connectToDB(Config config) {
        String driverClass = config.getPropertyValue("org.wso2.ws.dataservice.driver");
        String jdbcURL = config.getPropertyValue("org.wso2.ws.dataservice.protocol");
        String userName = config.getPropertyValue("org.wso2.ws.dataservice.user");
        String password = config.getPropertyValue("org.wso2.ws.dataservice.password");
        String minPool = config.getPropertyValue("org.wso2.ws.dataservice.minpoolsize");
        String maxPool = config.getPropertyValue("org.wso2.ws.dataservice.maxpoolsize");
        int minPoolSize = 1;
        int maxPoolSize = 5;
        try {
            if (minPool != null && minPool.trim().length() > 0) {
                minPoolSize = Integer.valueOf(minPool);
            }
            if (maxPool != null && maxPool.trim().length() > 0) {
                maxPoolSize = Integer.valueOf(maxPool);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Non-numeric value found for max/min pool size", (Throwable)e);
        }
        try {
            Class.forName(driverClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Error locating class " + driverClass), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Error instantiating class " + driverClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to class " + driverClass), (Throwable)e);
        }
        try {
            this.datasource = this.setupDataSource(jdbcURL, userName, password, minPoolSize, maxPoolSize);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while creating datasource.", (Throwable)e);
        }
    }

    public DataSource setupDataSource(String connectionURL, String username, String password, int minIdle, int maxActive) throws Exception {
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        connectionPool.setMinIdle(minIdle);
        connectionPool.setMaxActive(maxActive);
        connectionPool.setMaxWait(60000L);
        this.pool = connectionPool;
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectionURL, username, password);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        this.pool.setFactory((PoolableObjectFactory)factory);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        return dataSource;
    }

    public void printDriverStats() {
        GenericObjectPool connectionPool = this.pool;
        log.info((Object)("NumActive: " + connectionPool.getNumActive()));
        log.info((Object)("NumIdle: " + connectionPool.getNumIdle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLockedProcessCount() {
        int num_locked_connections = 0;
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pstmt = con.prepareStatement("SHOW PROCESSLIST");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("State") == null || !rs.getString("State").equals("Locked")) continue;
                ++num_locked_connections;
            }
            log.info((Object)("Number of locked connections : " + num_locked_connections));
        }
        catch (Exception e) {
            log.error((Object)"Error occured while getting lockedProcessCount", (Throwable)e);
        }
        finally {
            try {
                rs.close();
                pstmt.close();
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error closing connection.", (Throwable)e);
            }
        }
        return num_locked_connections;
    }
}

