/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ws.dataservice;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.wso2.ws.dataservice.DBDeployer;
import org.wso2.ws.dataservice.beans.Param;

public class CallQuery {
    private ArrayList inputParms = new ArrayList();
    private ArrayList outputParms = new ArrayList();
    private String sql;
    private String elementName;
    private String rawName;
    private ArrayList queryRefList = new ArrayList();
    private String defaultNamespace;
    private String columnDefault;
    private String nsPrefix;

    public ArrayList getInputParms() {
        return this.inputParms;
    }

    public void addInputParms(Param param) {
        this.inputParms.add(param);
    }

    public ArrayList getOutputParms() {
        return this.outputParms;
    }

    public void addOutputParms(Param param) {
        this.outputParms.add(param);
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getRawName() {
        return this.rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
    }

    public ArrayList getQueryRefList() {
        return this.queryRefList;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getColumnDefault() {
        return this.columnDefault;
    }

    public void setColumnDefault(String columnDefault) {
        this.columnDefault = columnDefault;
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public void setNsPrefix(String nsPrefix) {
        this.nsPrefix = nsPrefix;
    }

    public void populateCallQuery(OMElement queryElement, AxisService axisService) throws AxisFault {
        OMElement resultElement;
        Iterator inputsIterator = queryElement.getChildrenWithName(new QName("param"));
        while (inputsIterator.hasNext()) {
            OMElement input = (OMElement)inputsIterator.next();
            String name = input.getAttributeValue(new QName("name"));
            String sqlType = input.getAttributeValue(new QName("sqlType"));
            String dataType = DBDeployer.getJavaTypeFromSQLType(sqlType);
            String paramType = input.getAttributeValue(new QName("type"));
            String ordinal = input.getAttributeValue(new QName("ordinal"));
            Param param = new Param();
            param.setSqlType(dataType);
            if (paramType != null && paramType.trim().length() > 0) {
                param.setType(paramType);
            } else {
                param.setType("IN");
            }
            if (ordinal != null && ordinal.trim().length() > 0) {
                try {
                    param.setOrdinal(Integer.valueOf(ordinal));
                }
                catch (NumberFormatException e) {
                    throw new AxisFault("[" + axisService.getName() + "] Non-numeric value(" + ordinal + ") found for ordinal for parameter :" + name);
                }
            }
            param.setName(name);
            this.addInputParms(param);
        }
        OMElement sqlQuery = queryElement.getFirstChildWithName(new QName("sql"));
        if (sqlQuery != null) {
            this.sql = sqlQuery.getText();
        }
        if ((resultElement = queryElement.getFirstChildWithName(new QName("result"))) != null) {
            this.elementName = resultElement.getAttributeValue(new QName("element"));
            this.rawName = resultElement.getAttributeValue(new QName("rowName"));
            this.defaultNamespace = resultElement.getAttributeValue(new QName("defaultNamespace"));
            if (this.defaultNamespace == null) {
                this.defaultNamespace = axisService.getTargetNamespace();
                this.nsPrefix = axisService.getTargetNamespacePrefix();
            } else {
                int index = this.rawName.indexOf(":");
                if (index > -1) {
                    this.nsPrefix = this.rawName.substring(1, index);
                    this.rawName = this.rawName.substring(index + 1);
                } else {
                    this.nsPrefix = "ns1";
                }
            }
            this.columnDefault = resultElement.getAttributeValue(new QName("columnDefault"));
            Iterator elements = resultElement.getChildrenWithName(new QName("element"));
            while (elements.hasNext()) {
                OMElement element = (OMElement)elements.next();
                Param param = new Param();
                param.setSqlType("java.lang.String");
                param.setColumnName(element.getAttributeValue(new QName("column")));
                param.setName(element.getAttributeValue(new QName("name")));
                this.addOutputParms(param);
            }
            Iterator queryElements = resultElement.getChildrenWithName(new QName("call-query"));
            while (queryElements.hasNext()) {
                OMElement query = (OMElement)queryElements.next();
                this.queryRefList.add(query.getAttributeValue(new QName("href")));
            }
        } else {
            this.defaultNamespace = axisService.getTargetNamespace();
            this.nsPrefix = axisService.getTargetNamespacePrefix();
        }
    }
}

