/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.view.internal.jam;

import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanSet;
import org.codehaus.annogen.view.internal.IndigenousAnnoExtractor;
import org.codehaus.annogen.view.internal.NullIAE;
import org.codehaus.annogen.view.internal.javadoc.JavadocAnnogenTigerDelegate;
import org.codehaus.annogen.view.internal.javadoc.ParameterJavadocIAE;
import org.codehaus.annogen.view.internal.javadoc.ProgramElementJavadocIAE;
import org.codehaus.annogen.view.internal.reflect.ReflectAnnogenTigerDelegate;
import org.codehaus.annogen.view.internal.reflect.ReflectIAE;
import org.codehaus.jam.JAnnotatedElement;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JAnnotationValue;
import org.codehaus.jam.JInvokable;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.provider.JamLogger;

public final class JamIAE
implements IndigenousAnnoExtractor {
    private JAnnotatedElement mElement;
    private JamLogger mLogger;

    public static IndigenousAnnoExtractor create(JAnnotatedElement element, JamLogger logger, ReflectAnnogenTigerDelegate rtiger, JavadocAnnogenTigerDelegate jtiger) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        Object artifact = element.getArtifact();
        if (artifact == null) {
            return JamIAE.createForUnknownArtifact(element, logger);
        }
        if (element instanceof JProperty) {
            throw new IllegalStateException("NYI");
        }
        if (element instanceof JParameter) {
            JInvokable parent = (JInvokable)element.getParent();
            Object parentArt = parent.getArtifact();
            int num = JamIAE.getParameterNumber((JParameter)element);
            if (parentArt instanceof ExecutableMemberDoc) {
                return ParameterJavadocIAE.create((ExecutableMemberDoc)parentArt, num, jtiger);
            }
            if (parentArt instanceof Method) {
                return ReflectIAE.create((Method)parentArt, num, rtiger);
            }
            if (parentArt instanceof Constructor) {
                return ReflectIAE.create((Constructor)parentArt, num, rtiger);
            }
            return JamIAE.createForUnknownArtifact(element, logger);
        }
        if (artifact instanceof ProgramElementDoc) {
            return ProgramElementJavadocIAE.create((ProgramElementDoc)artifact, jtiger);
        }
        if (artifact instanceof Class) {
            return ReflectIAE.create((Class)artifact, rtiger);
        }
        if (artifact instanceof Package) {
            return ReflectIAE.create((Package)artifact, rtiger);
        }
        if (artifact instanceof Method) {
            return ReflectIAE.create((Method)artifact, rtiger);
        }
        if (artifact instanceof Constructor) {
            return ReflectIAE.create((Constructor)artifact, rtiger);
        }
        if (artifact instanceof Field) {
            return ReflectIAE.create((Field)artifact, rtiger);
        }
        return JamIAE.createForUnknownArtifact(element, logger);
    }

    private static IndigenousAnnoExtractor createForUnknownArtifact(JAnnotatedElement element, JamLogger logger) {
        JAnnotation[] anns = element.getAnnotations();
        if (anns == null || anns.length == 0) {
            return NullIAE.getInstance();
        }
        return new JamIAE(element, logger);
    }

    private JamIAE(JAnnotatedElement element, JamLogger logger) {
        this.mElement = element;
        this.mLogger = logger;
    }

    public boolean extractIndigenousAnnotations(AnnoBeanSet out) {
        JAnnotation[] anns = this.mElement.getAnnotations();
        if (anns == null || anns.length == 0) {
            return false;
        }
        for (int i = 0; i < anns.length; ++i) {
            Class annoClass = this.getAnnotationTypeClass(anns[i]);
            if (annoClass == null) continue;
            AnnoBean bean = out.findOrCreateBeanFor(annoClass);
            this.populate(anns[i], bean);
        }
        return true;
    }

    private void populate(JAnnotation src, AnnoBean dest) {
        JAnnotationValue[] values = src.getValues();
        if (values == null || values.length == 0) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            dest.setValue(values[i].getName(), values[i].getValue());
        }
    }

    private Class getAnnotationTypeClass(JAnnotation ann) {
        try {
            return Class.forName(ann.getQualifiedName());
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return null;
        }
    }

    public static int getParameterNumber(JParameter param) {
        JParameter[] params = ((JInvokable)param.getParent()).getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (param != params[i]) continue;
            return i;
        }
        throw new IllegalStateException();
    }
}

