/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLSubject
extends SAMLObject
implements Cloneable {
    protected SAMLNameIdentifier nameId;
    protected ArrayList confirmationMethods;
    protected Element confirmationData;
    protected KeyInfo keyInfo;
    public static final String CONF_ARTIFACT = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
    public static final String CONF_ARTIFACT01 = "urn:oasis:names:tc:SAML:1.0:cm:artifact-01";
    public static final String CONF_BEARER = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String CONF_HOLDER_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String CONF_SENDER_VOUCHES = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";

    public SAMLSubject() {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
    }

    public SAMLSubject(SAMLNameIdentifier sAMLNameIdentifier, Collection collection, Element element, Object object) throws SAMLException {
        block8: {
            this.nameId = null;
            this.confirmationMethods = new ArrayList();
            this.confirmationData = null;
            this.keyInfo = null;
            if (sAMLNameIdentifier != null) {
                this.nameId = (SAMLNameIdentifier)sAMLNameIdentifier.setParent(this);
            }
            if (element != null && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
                throw new IllegalArgumentException("confirmationData must be a saml:SubjectConfirmationData element");
            }
            this.confirmationData = element;
            if (collection != null) {
                this.confirmationMethods.addAll(collection);
            }
            if (object != null) {
                try {
                    if (object instanceof KeyInfo && ((KeyInfo)object).getElement().getParentNode() == null) {
                        this.keyInfo = (KeyInfo)object;
                        break block8;
                    }
                    if (object instanceof Element && ((Element)object).getParentNode() == null) {
                        this.keyInfo = new KeyInfo((Element)object, null);
                        break block8;
                    }
                    throw new IllegalArgumentException("SAMLSubject() unable to process the provided keyInfo object/element");
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new MalformedException("SAMLSubject() caught an XML security exception", (Exception)((Object)xMLSecurityException));
                }
            }
        }
    }

    public SAMLSubject(Element element) throws SAMLException {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
        this.fromDOM(element);
    }

    public SAMLSubject(InputStream inputStream) throws SAMLException {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
        this.fromDOM(SAMLSubject.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Subject")) {
            throw new MalformedException("SAMLSubject.fromDOM() requires saml:Subject at root");
        }
        Element element2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
        if (element2 != null) {
            this.nameId = (SAMLNameIdentifier)SAMLNameIdentifier.getInstance(element2).setParent(this);
            element2 = XML.getNextSiblingElement(element2);
        }
        if ((element2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation")) != null) {
            Element element3 = XML.getFirstChildElement(element2);
            while (element3 != null && XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod") && element3.hasChildNodes()) {
                this.confirmationMethods.add(element3.getFirstChild().getNodeValue());
                element3 = XML.getNextSiblingElement(element3);
            }
            if (element3 != null && XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
                this.confirmationData = element3;
                element3 = XML.getNextSiblingElement(element3);
            }
            if (element3 != null && XML.isElementNamed(element3, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) {
                try {
                    this.keyInfo = new KeyInfo(element3, null);
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new MalformedException("SAMLSubject.fromDOM() caught an XML security exception", (Exception)((Object)xMLSecurityException));
                }
            }
        }
        this.checkValidity();
    }

    public SAMLNameIdentifier getNameIdentifier() {
        return this.nameId;
    }

    public void setNameIdentifier(SAMLNameIdentifier sAMLNameIdentifier) throws SAMLException {
        this.nameId = sAMLNameIdentifier != null ? (SAMLNameIdentifier)sAMLNameIdentifier.setParent(this) : null;
        this.setDirty(true);
    }

    public Iterator getConfirmationMethods() {
        return this.confirmationMethods.iterator();
    }

    public void setConfirmationMethods(Collection collection) {
        this.confirmationMethods.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addConfirmationMethod((String)iterator.next());
            }
        }
        this.setDirty(true);
    }

    public void addConfirmationMethod(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("confirmationMethod cannot be null or empty");
        }
        this.confirmationMethods.add(string);
        this.setDirty(true);
    }

    public void removeConfirmationMethod(int n) throws IndexOutOfBoundsException {
        this.confirmationMethods.remove(n);
        this.setDirty(true);
    }

    public Element getConfirmationData() {
        return this.confirmationData;
    }

    public void setConfirmationData(Element element) {
        if (element != null && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
            throw new IllegalArgumentException("confirmationData must be a saml:SubjectConfirmationData element");
        }
        this.confirmationData = element;
        this.setDirty(true);
    }

    public Element getKeyInfo() {
        return this.keyInfo != null ? this.keyInfo.getElement() : null;
    }

    public Object getNativeKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(Object object) throws SAMLException {
        if (object != null && !(object instanceof KeyInfo) && !(object instanceof Element)) {
            throw new IllegalArgumentException("keyInfo must be a ds:KeyInfo element or a native library object");
        }
        KeyInfo keyInfo = null;
        try {
            keyInfo = object instanceof Element ? new KeyInfo((Element)object, null) : (KeyInfo)object;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new SAMLException("setKeyInfo() caught an XML security exception", (Exception)((Object)xMLSecurityException));
        }
        this.keyInfo = keyInfo;
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Subject");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            if (this.nameId != null) {
                element.appendChild(this.nameId.toDOM(document, false));
            }
            if (this.confirmationMethods.size() > 0) {
                Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
                Iterator iterator = this.confirmationMethods.iterator();
                while (iterator.hasNext()) {
                    element2.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod")).appendChild(document.createTextNode((String)iterator.next()));
                }
                if (this.confirmationData != null) {
                    if (this.confirmationData.getOwnerDocument() == document) {
                        element2.appendChild(this.confirmationData);
                    } else {
                        element2.appendChild(document.adoptNode(this.confirmationData));
                    }
                }
                if (this.keyInfo != null) {
                    if (this.keyInfo.getElement().getOwnerDocument() == document) {
                        element2.appendChild(this.keyInfo.getElement());
                    } else {
                        element2.appendChild(document.adoptNode(this.keyInfo.getElement()));
                    }
                }
                element.appendChild(element2);
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.nameId == null && (this.confirmationMethods == null || this.confirmationMethods.size() == 0)) {
            throw new MalformedException("Subject is invalid, requires either NameIdentifier or at least one ConfirmationMethod");
        }
        if (this.confirmationData != null && !XML.isElementNamed(this.confirmationData, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
            throw new MalformedException("Subject is invalid, requires that confirmation data be a saml:SubjectConfirmationData element");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubject sAMLSubject = (SAMLSubject)super.clone();
        try {
            if (this.nameId != null) {
                sAMLSubject.nameId = (SAMLNameIdentifier)((SAMLNameIdentifier)this.nameId.clone()).setParent(sAMLSubject);
            }
            sAMLSubject.confirmationMethods = (ArrayList)this.confirmationMethods.clone();
            if (this.confirmationData != null) {
                sAMLSubject.confirmationData = (Element)this.confirmationData.cloneNode(true);
            }
            if (this.keyInfo != null) {
                sAMLSubject.keyInfo = new KeyInfo((Element)this.keyInfo.getElement().cloneNode(true), null);
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new CloneNotSupportedException(xMLSecurityException.getMessage());
        }
        return sAMLSubject;
    }
}

