/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen.service.wsdl2code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.util.OptionsValidator;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.util.WSDL2JavaOptionsValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.utils.FileManipulator;

public class WSDL2Code {
    private static Log log = LogFactory.getLog((Class)WSDL2Code.class);
    private static final String CODEGEN_POM_XSL = "codegen-pom.xsl";
    private static final String CODEGEN_OPTIONS = "codegen-options.xml";

    public OMElement getCodegenOptions() throws AxisFault {
        OMElement docEle = this.loadCodegenOptions();
        docEle.build();
        return docEle;
    }

    private OMElement loadCodegenOptions() throws AxisFault {
        XMLStreamReader streamReader;
        InputStream inStream = this.getClass().getResourceAsStream(CODEGEN_OPTIONS);
        if (inStream == null && (inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CODEGEN_OPTIONS)) == null) {
            String s = "Codegen option file is not available";
            log.error((Object)s);
            throw new AxisFault(s);
        }
        try {
            streamReader = XMLInputFactory.newInstance().createXMLStreamReader(inStream);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error occurred while creating XMLStreamReader", (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(streamReader);
        return builder.getDocumentElement();
    }

    public OMElement getCodegenOptionsWithValues(String codegenOption, String codegenOptionValue) throws AxisFault {
        OMElement docEle = this.loadCodegenOptions();
        try {
            AXIOMXPath xp = new AXIOMXPath("/codegen/argument[@name='" + codegenOption + "']");
            OMElement nameEle = (OMElement)xp.selectSingleNode((Object)docEle);
            if (nameEle != null) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMElement uploadFileValueEle = fac.createOMElement(new QName("uploadFileValue"));
                nameEle.addChild((OMNode)uploadFileValueEle);
                Map fileResourcesMap = (Map)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
                if (fileResourcesMap == null) {
                    String msg = "File resource is not available";
                    log.error((Object)msg);
                    throw new AxisFault(msg);
                }
                String absFilePath = (String)fileResourcesMap.get(codegenOptionValue);
                if (absFilePath == null) {
                    String msg = "Uploaded file is not available";
                    log.error((Object)msg);
                    throw new AxisFault(msg);
                }
                OMText omText = fac.createOMText(absFilePath, 12);
                uploadFileValueEle.addChild((OMNode)omText);
            }
            return nameEle;
        }
        catch (JaxenException e) {
            String msg = "Xpath error has been encounted while looking for the argument : " + codegenOption;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public String codegen(String[] options) throws AxisFault {
        Map allOptions;
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        String codegenOutputDir = MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("WORK_DIR") + File.separator + "tools_codegen" + File.separator + uuid + File.separator;
        System.getProperties().remove("project.base.dir");
        System.getProperties().remove("name");
        System.setProperty("project.base.dir", codegenOutputDir);
        ArrayList<String> optionsList = new ArrayList<String>();
        for (int j = 0; j < options.length; ++j) {
            optionsList.add(options[j]);
        }
        optionsList.add("-o");
        optionsList.add(codegenOutputDir);
        String[] args = optionsList.toArray(new String[optionsList.size()]);
        try {
            CommandLineOptionParser commandLineOptionParser = new CommandLineOptionParser(args);
            allOptions = commandLineOptionParser.getAllOptions();
            List list = commandLineOptionParser.getInvalidOptions((OptionsValidator)new WSDL2JavaOptionsValidator());
            if (list.size() > 0) {
                String faultOptions = "";
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CommandLineOption commandLineOption = (CommandLineOption)iterator.next();
                    String optionValue = commandLineOption.getOptionValue();
                    faultOptions = faultOptions + "Invalid input for [ " + commandLineOption.getOptionType() + (optionValue != null ? " : " + optionValue + " ]" : " ]") + "\n";
                }
                log.error((Object)faultOptions);
                throw new AxisFault(faultOptions);
            }
            new CodeGenerationEngine(commandLineOptionParser).generate();
        }
        catch (Exception e) {
            String msg;
            String rootMsg = "Code generation failed";
            Throwable throwable = e.getCause();
            if (throwable != null && (msg = throwable.getMessage()) != null) {
                log.error((Object)(rootMsg + " " + msg), throwable);
                throw new AxisFault(throwable.toString());
            }
            log.error((Object)rootMsg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        CommandLineOption option = (CommandLineOption)allOptions.get("sn");
        try {
            uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
            File destDir = new File(MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("WORK_DIR") + File.separator + "tools_codegen" + File.separator + uuid);
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            String destArchive = destDir.getAbsolutePath() + File.separator + uuid + ".zip";
            InputStream pomXslInputStream = this.getClass().getResourceAsStream(CODEGEN_POM_XSL);
            if (pomXslInputStream == null) {
                pomXslInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CODEGEN_POM_XSL);
            }
            String name = uuid;
            boolean isBuildXml = false;
            String version = "1.0";
            File buildXml = new File(codegenOutputDir, "build.xml");
            if (buildXml.exists() && buildXml.isFile()) {
                OMAttribute omAttribute;
                String nameVal;
                isBuildXml = true;
                FileInputStream buildInputStream = new FileInputStream(buildXml);
                AXIOMXPath xp = new AXIOMXPath("/project/property[@name='name']");
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(buildInputStream);
                StAXOMBuilder builder = new StAXOMBuilder(streamReader);
                OMElement documentElement = builder.getDocumentElement();
                OMElement nameEle = (OMElement)xp.selectSingleNode((Object)documentElement);
                if (nameEle != null && (nameVal = (omAttribute = nameEle.getAttribute(new QName("value"))).getAttributeValue()) != null) {
                    name = nameVal;
                }
            }
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMElement infoEle = fac.createOMElement(new QName("info"));
            OMElement nameEle = fac.createOMElement(new QName("name"));
            nameEle.setText(name);
            infoEle.addChild((OMNode)nameEle);
            OMElement isBuildXmlEle = fac.createOMElement(new QName("isBuildXml"));
            isBuildXmlEle.setText(Boolean.valueOf(isBuildXml).toString());
            infoEle.addChild((OMNode)isBuildXmlEle);
            OMElement versionEle = fac.createOMElement(new QName("version"));
            versionEle.setText(version);
            infoEle.addChild((OMNode)versionEle);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            infoEle.serialize((OutputStream)bao);
            ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(bao.toByteArray());
            if (pomXslInputStream != null) {
                File pomFileOut = new File(codegenOutputDir, "pom.xml");
                FileOutputStream pomFileOutputStream = new FileOutputStream(pomFileOut);
                StreamSource xmlSource = new StreamSource(xmlInputStream);
                StreamSource xslSource = new StreamSource(pomXslInputStream);
                StreamResult result = new StreamResult(pomFileOutputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
                transformer.transform(xmlSource, result);
            }
            new ArchiveManipulator().archiveDir(destArchive, new File(codegenOutputDir).getPath());
            new FileManipulator().deleteDir(new File(codegenOutputDir));
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
            }
            fileResourcesMap.put(uuid, destArchive);
            return "/filedownload?id=" + uuid;
        }
        catch (IOException e) {
            String msg = WSDL2Code.class.getName() + " IOException has occured.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = WSDL2Code.class.getName() + " error encountred while reading the build.xml";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (JaxenException e) {
            String msg = WSDL2Code.class.getName() + " xpath error has occured";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            String msg = WSDL2Code.class.getName() + " transformation error has occured";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (TransformerException e) {
            String msg = WSDL2Code.class.getName() + " transformation error has occured";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }
}

