/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Document;
import org.wso2.codegen.service.ServiceEndpointsData;
import org.wso2.codegen.service.WSDLMetaDataFactory;

public class WSDL11MetaDataFactory
extends WSDLMetaDataFactory {
    private Definition wsdlDefinition;
    private URL wsdlLocation;

    public WSDL11MetaDataFactory(String wsdlVersion, String serviceName, MessageContext currentMessageContext) {
        this.wsdlVersion = wsdlVersion;
        this.serviceName = serviceName;
        this.currentMessageContext = currentMessageContext;
    }

    public ServiceEndpointsData[] createServiceEndpointsDataArray(URL wsdlLocation) throws AxisFault {
        return this.serviceEndpointsDataHelper1(wsdlLocation);
    }

    public URL getWSDLLocation() {
        return this.wsdlLocation;
    }

    private ServiceEndpointsData[] serviceEndpointsDataHelper1(URL wsdlLocation) throws AxisFault {
        this.wsdlLocation = wsdlLocation;
        try {
            this.readWSDL(this.wsdlLocation);
            return this.serviceEndpointsDataHelper0();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private ServiceEndpointsData[] serviceEndpointsDataHelper0() {
        QName[] serviceBindings = this.getServiceList();
        ServiceEndpointsData[] servicePortData = new ServiceEndpointsData[serviceBindings.length];
        for (int i = 0; i < serviceBindings.length; ++i) {
            ServiceEndpointsData data = new ServiceEndpointsData();
            data.setServiceName(serviceBindings[i].getLocalPart());
            String[] ports = this.getPortNameList(serviceBindings[i]);
            data.setEndpointNames(ports);
            servicePortData[i] = data;
        }
        return servicePortData;
    }

    public void printWSDL(OutputStream out, String ip, String serviceContextPath, AxisService axisService) throws AxisFault {
        axisService.printWSDL(out, ip);
    }

    public void readWSDL(URL wsdlLocation) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        InputStream in = wsdlLocation.openConnection().getInputStream();
        Document document = XMLUtils.newDocument((InputStream)in);
        this.wsdlDefinition = reader.readWSDL(this.getBaseURI(wsdlLocation.toString()), document);
    }

    private QName[] getServiceList() {
        ArrayList<QName> returnList = new ArrayList<QName>();
        Map serviceMap = this.wsdlDefinition.getServices();
        if (serviceMap != null && !serviceMap.isEmpty()) {
            Iterator serviceIterator = serviceMap.values().iterator();
            while (serviceIterator.hasNext()) {
                Service service = (Service)serviceIterator.next();
                returnList.add(service.getQName());
            }
        }
        return returnList.toArray(new QName[returnList.size()]);
    }

    private String[] getPortNameList(QName serviceName) {
        Map portMap;
        ArrayList<String> returnList = new ArrayList<String>();
        Service service = this.wsdlDefinition.getService(serviceName);
        if (service != null && (portMap = service.getPorts()) != null && !portMap.isEmpty()) {
            Iterator portIterator = portMap.values().iterator();
            while (portIterator.hasNext()) {
                Port port = (Port)portIterator.next();
                Binding binding = port.getBinding();
                QName bindingQName = binding.getQName();
                String bindingName = bindingQName.getLocalPart();
                if (bindingName.endsWith("HttpBinding")) continue;
                returnList.add(port.getName());
            }
        }
        return returnList.toArray(new String[returnList.size()]);
    }
}

