/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.llom.Checker;
import org.apache.axiom.soap.impl.llom.MURoleChecker;
import org.apache.axiom.soap.impl.llom.RoleChecker;
import org.apache.axiom.soap.impl.llom.RolePlayerChecker;
import org.apache.axiom.soap.impl.llom.SOAPElement;
import org.apache.axiom.soap.impl.llom.SOAPEnvelopeImpl;

public abstract class SOAPHeaderImpl
extends SOAPElement
implements SOAPHeader {
    protected SOAPHeaderImpl(OMNamespace ns, SOAPFactory factory) {
        super("Header", ns, factory);
    }

    public SOAPHeaderImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Header", true, factory);
    }

    public SOAPHeaderImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)envelope, "Header", builder, factory);
    }

    public abstract SOAPHeaderBlock addHeaderBlock(String var1, OMNamespace var2) throws OMException;

    public Iterator getHeadersToProcess(RolePlayer rolePlayer) {
        return new HeaderIterator(new RolePlayerChecker(rolePlayer));
    }

    public Iterator getHeadersToProcess(RolePlayer rolePlayer, String namespace) {
        return new HeaderIterator(new RolePlayerChecker(rolePlayer, namespace));
    }

    public Iterator examineHeaderBlocks(String role) {
        return new HeaderIterator(new RoleChecker(role));
    }

    public abstract Iterator extractHeaderBlocks(String var1);

    public Iterator examineMustUnderstandHeaderBlocks(String actor) {
        return new HeaderIterator(new MURoleChecker(actor));
    }

    public Iterator examineAllHeaderBlocks() {
        class DefaultChecker
        implements Checker {
            DefaultChecker() {
            }

            public boolean checkHeader(SOAPHeaderBlock header) {
                return true;
            }
        }
        return new HeaderIterator(new DefaultChecker());
    }

    public Iterator extractAllHeaderBlocks() {
        throw new UnsupportedOperationException();
    }

    public ArrayList getHeaderBlocksWithNSURI(String nsURI) {
        ArrayList<OMElement> headers = null;
        OMElement header = this.getFirstElement();
        if (header != null) {
            headers = new ArrayList<OMElement>();
        }
        for (OMElement node = header; node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            header = node;
            OMNamespace namespace = header.getNamespace();
            if (nsURI == null) {
                if (namespace != null) continue;
                headers.add(header);
                continue;
            }
            if (namespace == null || !nsURI.equals(namespace.getNamespaceURI())) continue;
            headers.add(header);
        }
        return headers;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }

    class HeaderIterator
    implements Iterator {
        SOAPHeaderBlock current;
        boolean advance = false;
        Checker checker;

        public HeaderIterator() {
            this(null);
        }

        public HeaderIterator(Checker checker) {
            this.checker = checker;
            this.current = (SOAPHeaderBlock)SOAPHeaderImpl.this.getFirstElement();
            if (this.current != null && !this.checkHeader(this.current)) {
                this.advance = true;
                this.hasNext();
            }
        }

        public void remove() {
        }

        public boolean checkHeader(SOAPHeaderBlock header) {
            if (this.checker == null) {
                return true;
            }
            return this.checker.checkHeader(header);
        }

        public boolean hasNext() {
            if (!this.advance) {
                return this.current != null;
            }
            this.advance = false;
            for (OMNode sibling = this.current.getNextOMSibling(); sibling != null; sibling = sibling.getNextOMSibling()) {
                SOAPHeaderBlock possible;
                if (!(sibling instanceof SOAPHeaderBlock) || !this.checkHeader(possible = (SOAPHeaderBlock)sibling)) continue;
                this.current = (SOAPHeaderBlock)sibling;
                return true;
            }
            this.current = null;
            return false;
        }

        public Object next() {
            SOAPHeaderBlock ret = this.current;
            if (ret != null) {
                this.advance = true;
                this.hasNext();
            }
            return ret;
        }
    }
}

