/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jibx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValidationProblem;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CodeGenerationUtility {
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private final CodeGenConfiguration codeGenConfig;
    private static HashSet s_primitiveSet = new HashSet();
    private static HashMap s_wrapperMap;
    private static final HashSet s_reservedWords;

    public CodeGenerationUtility(CodeGenConfiguration config) {
        this.codeGenConfig = config;
    }

    public void engage(String path) {
        File file = null;
        if (path != null && !(file = new File(path)).exists()) {
            throw new RuntimeException("jibx binding definition file " + path + " not found");
        }
        try {
            Element detail;
            String classname;
            Element detail2;
            String prefix;
            String ns;
            boolean unwrap = !this.codeGenConfig.isParametersWrapped();
            BindingElement binding = null;
            if (file == null) {
                if (!unwrap) {
                    throw new RuntimeException("JiBX wrapped support requires a binding definition to be provided using the -Ebindingfile {file-path} parameter");
                }
            } else {
                ValidationContext vctx = BindingElement.newValidationContext();
                binding = BindingElement.readBinding((InputStream)new FileInputStream(file), (String)path, (ValidationContext)vctx);
                binding.setBaseUrl(file.toURL());
                vctx.setBindingRoot(binding);
                IncludePrevalidationVisitor ipv = new IncludePrevalidationVisitor(vctx);
                vctx.tourTree(binding, (ModelVisitor)ipv);
                if (vctx.getErrorCount() != 0 || vctx.getFatalCount() != 0) {
                    ArrayList probs = vctx.getProblems();
                    System.err.println("Errors in generated binding:");
                    for (int j = 0; j < probs.size(); ++j) {
                        ValidationProblem prob = (ValidationProblem)probs.get(j);
                        System.err.print(prob.getSeverity() >= 1 ? "Error: " : "Warning: ");
                        System.err.println(prob.getDescription());
                    }
                    throw new RuntimeException("invalid jibx binding definition file " + path);
                }
            }
            HashMap simpleTypeMap = new HashMap();
            CodeGenerationUtility.buildFormat("byte", "byte", "org.jibx.runtime.Utility.serializeByte", "org.jibx.runtime.Utility.parseByte", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("unsignedShort", "char", "org.jibx.runtime.Utility.serializeChar", "org.jibx.runtime.Utility.parseChar", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("double", "double", "org.jibx.runtime.Utility.serializeDouble", "org.jibx.runtime.Utility.parseDouble", "0.0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("float", "float", "org.jibx.runtime.Utility.serializeFloat", "org.jibx.runtime.Utility.parseFloat", "0.0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("int", "int", "org.jibx.runtime.Utility.serializeInt", "org.jibx.runtime.Utility.parseInt", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("long", "long", "org.jibx.runtime.Utility.serializeLong", "org.jibx.runtime.Utility.parseLong", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("short", "short", "org.jibx.runtime.Utility.serializeShort", "org.jibx.runtime.Utility.parseShort", "0", simpleTypeMap);
            CodeGenerationUtility.buildFormat("boolean", "boolean", "org.jibx.runtime.Utility.serializeBoolean", "org.jibx.runtime.Utility.parseBoolean", "false", simpleTypeMap);
            CodeGenerationUtility.buildFormat("dateTime", "java.util.Date", "org.jibx.runtime.Utility.serializeDateTime", "org.jibx.runtime.Utility.deserializeDateTime", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("date", "java.sql.Date", "org.jibx.runtime.Utility.serializeSqlDate", "org.jibx.runtime.Utility.deserializeSqlDate", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("time", "java.sql.Time", "org.jibx.runtime.Utility.serializeSqlTime", "org.jibx.runtime.Utility.deserializeSqlTime", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("base64Binary", "byte[]", "org.jibx.runtime.Utility.serializeBase64", "org.jibx.runtime.Utility.deserializeBase64", null, simpleTypeMap);
            CodeGenerationUtility.buildFormat("string", "java.lang.String", null, null, null, simpleTypeMap);
            HashMap elementMap = new HashMap();
            HashMap complexTypeMap = new HashMap();
            HashMap bindingMap = new HashMap();
            if (binding != null) {
                CodeGenerationUtility.collectTopLevelComponents(binding, "", elementMap, complexTypeMap, simpleTypeMap, bindingMap);
            }
            if (unwrap && complexTypeMap.size() > 0 && (binding == null || !binding.isForceClasses())) {
                throw new RuntimeException("unwrapped binding must use force-classes='true' option in " + path);
            }
            this.codeGenConfig.setPackClasses(false);
            this.codeGenConfig.setTypeMapper((TypeMapper)new NamedParameterTypeMapper());
            Iterator operations = this.codeGenConfig.getAxisService().getOperations();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            int opindex = 0;
            HashMap typeMappedClassMap = new HashMap();
            String mappedclass = null;
            HashSet<String> objins = new HashSet<String>();
            HashSet<String> objouts = new HashSet<String>();
            HashSet<String> objfaults = new HashSet<String>();
            HashMap nsMap = new HashMap();
            ArrayList<Element> wrappers = new ArrayList<Element>();
            while (operations.hasNext()) {
                String cname;
                SOAPHeaderMessage header;
                int i;
                ArrayList headers;
                AxisOperation op = (AxisOperation)operations.next();
                String mep = op.getMessageExchangePattern();
                AxisMessage inmsg = null;
                AxisMessage outmsg = null;
                if (WSDLUtil.isInputPresentForMEP((String)mep)) {
                    inmsg = op.getMessage("In");
                    if (inmsg == null) {
                        throw new RuntimeException("Expected input message not found for operation " + op.getName());
                    }
                    headers = inmsg.getSoapHeaders();
                    for (i = 0; i < headers.size(); ++i) {
                        header = (SOAPHeaderMessage)headers.get(i);
                        cname = this.mapMessage(header, elementMap);
                        objins.add(cname);
                        if (mappedclass != null || !CodeGenerationUtility.isLookupClass(cname)) continue;
                        mappedclass = cname;
                    }
                }
                if (WSDLUtil.isOutputPresentForMEP((String)mep)) {
                    outmsg = op.getMessage("Out");
                    if (outmsg == null) {
                        throw new RuntimeException("Expected output message not found for operation " + op.getName());
                    }
                    headers = outmsg.getSoapHeaders();
                    for (i = 0; i < headers.size(); ++i) {
                        header = (SOAPHeaderMessage)headers.get(i);
                        cname = this.mapMessage(header, elementMap);
                        objouts.add(cname);
                        if (mappedclass != null || !CodeGenerationUtility.isLookupClass(cname)) continue;
                        mappedclass = cname;
                    }
                }
                if (unwrap) {
                    Element wrapper;
                    String receivername = "jibxReceiver" + opindex++;
                    Element dbmethod = doc.createElement("dbmethod");
                    dbmethod.setAttribute("receiver-name", receivername);
                    dbmethod.setAttribute("method-name", op.getName().getLocalPart());
                    HashSet nameset = new HashSet(s_reservedWords);
                    if (inmsg != null) {
                        wrapper = this.unwrapMessage(inmsg, false, simpleTypeMap, elementMap, complexTypeMap, typeMappedClassMap, bindingMap, nameset, nsMap, doc);
                        dbmethod.appendChild(wrapper);
                        wrappers.add(wrapper);
                    }
                    if (outmsg != null) {
                        wrapper = this.unwrapMessage(outmsg, true, simpleTypeMap, elementMap, complexTypeMap, typeMappedClassMap, bindingMap, nameset, nsMap, doc);
                        dbmethod.appendChild(wrapper);
                        wrappers.add(wrapper);
                    }
                    op.addParameter(new Parameter("databinding-generated-receiver", (Object)receivername));
                    op.addParameter(new Parameter("databinding-generated-implementation", (Object)Boolean.TRUE));
                    op.addParameter(new Parameter("databinding-operation-details", (Object)dbmethod));
                } else {
                    String cname2;
                    if (inmsg != null) {
                        cname2 = this.mapMessage(inmsg, elementMap);
                        objins.add(cname2);
                        if (mappedclass == null && CodeGenerationUtility.isLookupClass(cname2)) {
                            mappedclass = cname2;
                        }
                    }
                    if (outmsg != null) {
                        cname2 = this.mapMessage(outmsg, elementMap);
                        objouts.add(cname2);
                        if (mappedclass == null && CodeGenerationUtility.isLookupClass(cname2)) {
                            mappedclass = cname2;
                        }
                    }
                }
                Iterator iter = op.getFaultMessages().iterator();
                while (iter.hasNext()) {
                    String cname3 = this.mapMessage((AxisMessage)iter.next(), elementMap);
                    objfaults.add(cname3);
                    if (mappedclass != null || !CodeGenerationUtility.isLookupClass(cname3)) continue;
                    mappedclass = cname3;
                }
            }
            Collection prefixes = nsMap.values();
            boolean dfltns = prefixes.contains("");
            boolean wrapdflt = false;
            if (!dfltns) {
                for (int i = 0; i < wrappers.size(); ++i) {
                    Element wrapper = (Element)wrappers.get(i);
                    if (!"true".equals(wrapper.getAttribute("uses-default"))) continue;
                    wrapdflt = true;
                    break;
                }
            }
            String xtrapref = "";
            if (dfltns || wrapdflt) {
                xtrapref = "_";
                int index = 0;
                while (prefixes.contains(xtrapref)) {
                    xtrapref = "_" + index++;
                }
            }
            for (int i = 0; i < wrappers.size(); ++i) {
                String childns;
                Element element;
                String lname;
                Node node;
                Element wrapper = (Element)wrappers.get(i);
                boolean addns = false;
                ns = wrapper.getAttribute("ns");
                prefix = "";
                if ("true".equals(wrapper.getAttribute("need-namespaces"))) {
                    if (!"".equals(ns)) {
                        if (dfltns || wrapdflt) {
                            prefix = (String)nsMap.get(ns);
                            if (prefix == null) {
                                prefix = xtrapref;
                                addns = true;
                            }
                        } else {
                            prefix = "";
                            addns = true;
                        }
                    }
                    wrapper.setAttribute("prefix", prefix);
                    for (node = wrapper.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (node.getNodeType() != 1 || !"parameter-element".equals(lname = (element = (Element)node).getNodeName()) && !"return-element".equals(lname)) continue;
                        childns = element.getAttribute("ns");
                        if ("".equals(childns)) {
                            element.setAttribute("prefix", "");
                            continue;
                        }
                        if (ns.equals(childns)) {
                            element.setAttribute("prefix", prefix);
                            continue;
                        }
                        String childprefix = (String)nsMap.get(childns);
                        if (childprefix == null) {
                            throw new RuntimeException("Unable to set namespace " + childns + " for child element");
                        }
                        element.setAttribute("prefix", childprefix);
                    }
                } else {
                    if (!"".equals(ns)) {
                        prefix = "";
                        addns = true;
                    }
                    wrapper.setAttribute("prefix", prefix);
                    for (node = wrapper.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (node.getNodeType() != 1 || !"parameter-element".equals(lname = (element = (Element)node).getNodeName()) && !"return-element".equals(lname)) continue;
                        childns = element.getAttribute("ns");
                        if ("".equals(childns)) {
                            element.setAttribute("prefix", "");
                            continue;
                        }
                        if (ns.equals(childns)) {
                            element.setAttribute("prefix", prefix);
                            continue;
                        }
                        throw new RuntimeException("Unable to set namespace " + childns + " for child element");
                    }
                }
                if (!addns) continue;
                Element addedns = doc.createElement("extra-namespace");
                addedns.setAttribute("ns", ns);
                addedns.setAttribute("prefix", prefix);
                wrapper.appendChild(addedns);
            }
            ArrayList<Element> details = new ArrayList<Element>();
            Element bindinit = doc.createElement("initialize-binding");
            if (!typeMappedClassMap.isEmpty()) {
                Iterator iter = typeMappedClassMap.keySet().iterator();
                while (iter.hasNext()) {
                    javax.xml.namespace.QName tname = (javax.xml.namespace.QName)iter.next();
                    String clsindex = ((Integer)typeMappedClassMap.get(tname)).toString();
                    detail2 = doc.createElement("abstract-type");
                    detail2.setAttribute("ns", tname.getNamespaceURI());
                    detail2.setAttribute("name", tname.getLocalPart());
                    detail2.setAttribute("type-index", clsindex);
                    bindinit.appendChild(detail2);
                    if (mappedclass != null) continue;
                    MappingElement mapping = (MappingElement)complexTypeMap.get(tname);
                    mappedclass = mapping.getClassName();
                }
            }
            if (binding != null && binding.getName() != null && binding.getTargetPackage() != null) {
                bindinit.setAttribute("binding-name", binding.getName());
                bindinit.setAttribute("binding-package", binding.getTargetPackage());
            } else {
                if (mappedclass == null) {
                    mappedclass = "";
                }
                bindinit.setAttribute("bound-class", mappedclass);
            }
            Iterator<Object> iter = nsMap.keySet().iterator();
            while (iter.hasNext()) {
                ns = (String)iter.next();
                prefix = (String)nsMap.get(ns);
                detail2 = doc.createElement("binding-namespace");
                detail2.setAttribute("ns", ns);
                detail2.setAttribute("prefix", prefix);
                bindinit.appendChild(detail2);
            }
            details.add(bindinit);
            iter = objins.iterator();
            while (iter.hasNext()) {
                classname = (String)iter.next();
                detail = doc.createElement("object-input");
                detail.setAttribute("type", classname);
                details.add(detail);
            }
            iter = objouts.iterator();
            while (iter.hasNext()) {
                classname = (String)iter.next();
                detail = doc.createElement("object-output");
                detail.setAttribute("type", classname);
                details.add(detail);
            }
            iter = objfaults.iterator();
            while (iter.hasNext()) {
                classname = (String)iter.next();
                detail = doc.createElement("object-fault");
                detail.setAttribute("type", classname);
                details.add(detail);
            }
            this.codeGenConfig.getAxisService().addParameter(new Parameter("databinding-service-details", details));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (JiBXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isLookupClass(String type) {
        return !type.startsWith("java.") && !type.startsWith("javax.") && !type.startsWith("org.w3c.");
    }

    private static void buildFormat(String stype, String jtype, String sname, String dname, String dflt, Map map) {
        FormatElement format = new FormatElement();
        format.setTypeName(jtype);
        format.setSerializerName(sname);
        format.setDeserializerName(dname);
        format.setDefaultText(dflt);
        map.put(new javax.xml.namespace.QName(SCHEMA_NAMESPACE, stype), format);
    }

    private Element unwrapMessage(AxisMessage msg, boolean isout, Map simpleTypeMap, Map elementMap, Map complexTypeMap, Map typeMappedClassMap, Map bindingMap, Set nameset, Map nsmap, Document doc) {
        String wrappertype;
        ArrayList<javax.xml.namespace.QName> partNameList;
        Element wrapdetail;
        javax.xml.namespace.QName qname;
        block35: {
            XmlSchemaType type;
            block34: {
                qname = msg.getElementQName();
                if (qname == null) {
                    throw new RuntimeException("No element reference in message " + msg.getName());
                }
                XmlSchemaElement wrapdef = this.codeGenConfig.getAxisService().getSchemaElement(qname);
                if (wrapdef == null) {
                    throw new RuntimeException("Cannot unwrap - no definition found for element " + qname);
                }
                type = wrapdef.getSchemaType();
                wrapdetail = doc.createElement(isout ? "out-wrapper" : "in-wrapper");
                wrapdetail.setAttribute("ns", qname.getNamespaceURI());
                wrapdetail.setAttribute("name", qname.getLocalPart());
                partNameList = new ArrayList<javax.xml.namespace.QName>();
                wrappertype = "";
                boolean nons = qname.getNamespaceURI().length() == 0;
                boolean dfltns = false;
                boolean complex = false;
                if (!(type instanceof XmlSchemaComplexType)) break block34;
                XmlSchemaComplexType ctype = (XmlSchemaComplexType)type;
                if (ctype.getAttributes().getCount() != 0) {
                    throw new RuntimeException("Cannot unwrap element " + qname + ": attributes not allowed on type to be unwrapped");
                }
                XmlSchemaParticle particle = ctype.getParticle();
                if (particle == null) break block35;
                if (!(particle instanceof XmlSchemaSequence)) {
                    throw new RuntimeException("Cannot unwrap element " + qname + ": type to be unwrapped must be a sequence");
                }
                if (particle.getMinOccurs() != 1L || particle.getMaxOccurs() != 1L) {
                    throw new RuntimeException("Cannot unwrap element " + qname + ": contained sequence must have minOccurs='1' and maxOccurs='1'");
                }
                XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
                javax.xml.namespace.QName opName = msg.getAxisOperation().getName();
                XmlSchemaObjectCollection items = sequence.getItems();
                boolean first = true;
                Iterator iter = items.getIterator();
                while (iter.hasNext()) {
                    String javatype;
                    String createtype;
                    boolean isarray;
                    String javaname;
                    Element param;
                    block38: {
                        ElementBase child;
                        MappingElement mapping;
                        javax.xml.namespace.QName itemname;
                        javax.xml.namespace.QName typename;
                        javax.xml.namespace.QName refname;
                        block36: {
                            FormatElement format;
                            XmlSchemaElement element;
                            block37: {
                                javax.xml.namespace.QName tname;
                                XmlSchemaSimpleType stype;
                                XmlSchemaSimpleTypeContent content;
                                XmlSchemaParticle item = (XmlSchemaParticle)iter.next();
                                if (!(item instanceof XmlSchemaElement)) {
                                    throw new RuntimeException("Cannot unwrap element " + qname + ": only element items allowed in sequence");
                                }
                                element = (XmlSchemaElement)item;
                                refname = element.getRefName();
                                typename = element.getSchemaTypeName();
                                if (refname == null && typename == null) {
                                    throw new RuntimeException("Cannot unwrap element " + qname + ": all elements in contained sequence must be element references or reference a named type");
                                }
                                if (first) {
                                    first = false;
                                } else if (isout) {
                                    throw new RuntimeException("Cannot unwrap element " + qname + ": only one child element allowed in sequence for wrapped output");
                                }
                                param = doc.createElement(isout ? "return-element" : "parameter-element");
                                itemname = refname == null ? element.getQName() : refname;
                                nons = nons || itemname.getNamespaceURI().length() == 0;
                                param.setAttribute("ns", itemname.getNamespaceURI());
                                param.setAttribute("name", itemname.getLocalPart());
                                javaname = CodeGenerationUtility.toJavaName(itemname.getLocalPart(), nameset);
                                param.setAttribute("java-name", javaname);
                                param.setAttribute("nillable", Boolean.toString(element.isNillable()));
                                boolean optional = element.getMinOccurs() == 0L;
                                param.setAttribute("optional", Boolean.toString(optional));
                                isarray = element.getMaxOccurs() > 1L;
                                param.setAttribute("array", Boolean.toString(isarray));
                                createtype = null;
                                if (!(element.getSchemaType() instanceof XmlSchemaSimpleType)) break block36;
                                format = (FormatElement)simpleTypeMap.get(typename);
                                if (format == null && (content = (stype = (XmlSchemaSimpleType)element.getSchemaType()).getContent()) instanceof XmlSchemaSimpleTypeRestriction && SCHEMA_NAMESPACE.equals((tname = ((XmlSchemaSimpleTypeRestriction)content).getBaseTypeName()).getNamespaceURI()) && (format = (FormatElement)simpleTypeMap.get(tname)) != null) {
                                    typename = tname;
                                }
                                if (format == null) {
                                    throw new RuntimeException("Cannot unwrap element " + qname + ": no format definition found for type " + typename + " (used by element " + itemname + ')');
                                }
                                javatype = format.getTypeName();
                                param.setAttribute("form", "simple");
                                param.setAttribute("serializer", format.getSerializerName());
                                param.setAttribute("deserializer", format.getDeserializerName());
                                if (!optional && !element.isNillable() || !s_wrapperMap.containsKey(javatype)) break block37;
                                param.setAttribute("wrapped-primitive", "true");
                                param.setAttribute("value-method", javatype + "Value");
                                javatype = (String)s_wrapperMap.get(javatype);
                                break block38;
                            }
                            param.setAttribute("wrapped-primitive", "false");
                            String dflt = element.getDefaultValue();
                            if (dflt == null) {
                                dflt = format.getDefaultText();
                                if (javatype.equals("float")) {
                                    dflt = dflt + 'F';
                                }
                            }
                            if (dflt == null) break block38;
                            param.setAttribute("default", dflt);
                            break block38;
                        }
                        if (refname == null) {
                            mapping = (MappingElement)complexTypeMap.get(typename);
                            if (mapping == null) {
                                throw new RuntimeException("Cannot unwrap element " + qname + ": no abstract mapping definition found for type " + typename + " (used by element " + itemname + ')');
                            }
                            Integer tindex = (Integer)typeMappedClassMap.get(typename);
                            if (tindex == null) {
                                tindex = new Integer(typeMappedClassMap.size());
                                typeMappedClassMap.put(typename, tindex);
                            }
                            param.setAttribute("type-index", tindex.toString());
                        } else {
                            mapping = (MappingElement)elementMap.get(refname);
                            if (mapping == null) {
                                throw new RuntimeException("Cannot unwrap element " + qname + ": no concrete mapping definition found for element " + refname + " (used by element " + itemname + ')');
                            }
                            param.setAttribute("type-index", "");
                        }
                        param.setAttribute("form", "complex");
                        complex = true;
                        javatype = mapping.getClassName();
                        createtype = mapping.getCreateType();
                        if (createtype == null && mapping.isAbstract() && mapping.getExtensionTypes().isEmpty()) {
                            createtype = javatype;
                        }
                        Iterator citer = mapping.topChildIterator();
                        while (citer.hasNext() && (child = (ElementBase)citer.next()).type() == 4) {
                            dfltns = this.mapNamespace((NamespaceElement)child, dfltns, nsmap);
                        }
                        BindingElement binding = (BindingElement)bindingMap.get(mapping);
                        citer = binding.topChildIterator();
                        while (citer.hasNext()) {
                            ElementBase child2 = (ElementBase)citer.next();
                            if (child2.type() == 4) {
                                dfltns = this.mapNamespace((NamespaceElement)child2, dfltns, nsmap);
                                continue;
                            }
                            if (child2.type() == 8) continue;
                            break;
                        }
                    }
                    param.setAttribute("java-type", javatype);
                    if (createtype != null) {
                        param.setAttribute("create-type", createtype);
                    }
                    boolean isobj = !s_primitiveSet.contains(javatype);
                    String fulltype = javatype;
                    if (isarray) {
                        fulltype = fulltype + "[]";
                        isobj = false;
                    }
                    param.setAttribute("object", Boolean.toString(isobj));
                    wrappertype = isout ? fulltype : "java.lang.Object";
                    wrapdetail.appendChild(param);
                    javax.xml.namespace.QName partqname = WSDLUtil.getPartQName((String)opName.getLocalPart(), (String)"_input", (String)javaname);
                    partNameList.add(partqname);
                    this.codeGenConfig.getTypeMapper().addTypeMappingName(partqname, fulltype);
                }
                if (nons && dfltns) {
                    throw new RuntimeException("Cannot unwrap element " + qname + ": no-namespace element(s) conflict with default namespace use in binding");
                }
                wrapdetail.setAttribute("uses-default", Boolean.toString(nons));
                wrapdetail.setAttribute("need-namespaces", Boolean.toString(complex));
                break block35;
            }
            if (type != null) {
                throw new RuntimeException("Cannot unwrap element " + qname + ": not a complexType definition");
            }
        }
        if (wrapdetail.getFirstChild() == null) {
            wrapdetail.setAttribute("empty", "true");
            wrapdetail.setAttribute("need-namespaces", "false");
            wrappertype = "";
        } else {
            wrapdetail.setAttribute("empty", "false");
        }
        MessagePartInformationHolder infoHolder = new MessagePartInformationHolder();
        infoHolder.setOperationName(msg.getAxisOperation().getName());
        infoHolder.setPartsList(partNameList);
        try {
            msg.addParameter(new Parameter("UnWrapped_details", (Object)infoHolder));
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        try {
            msg.addParameter(new Parameter("UnWrapped", (Object)Boolean.TRUE));
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        this.codeGenConfig.getTypeMapper().addTypeMappingName(qname, wrappertype);
        return wrapdetail;
    }

    private boolean mapNamespace(NamespaceElement ns, boolean dfltns, Map nsmap) {
        String prior;
        String prefix = ns.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if ((prior = (String)nsmap.get(ns.getUri())) != null) {
            if (prefix.length() == 0) {
                return dfltns;
            }
            if (prior.length() == 0) {
                dfltns = false;
            }
        }
        nsmap.put(ns.getUri(), prefix);
        return dfltns || prefix.length() == 0;
    }

    private static String toJavaName(String name, Set nameset) {
        StringBuffer buff = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char chr = name.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(chr) || i > 0 && Character.isJavaIdentifierPart(chr)) {
                buff.append(chr);
                continue;
            }
            if (chr == ':' || chr == '.') {
                buff.append('$');
                continue;
            }
            buff.append('_');
        }
        int count = 0;
        String jname = buff.toString();
        while (!nameset.add(jname)) {
            jname = buff.toString() + count++;
        }
        return jname;
    }

    private String mapMessage(AxisMessage msg, Map complexTypeMap) {
        javax.xml.namespace.QName qname = msg.getElementQName();
        if (qname == null) {
            throw new RuntimeException("No element reference in message " + msg.getName());
        }
        return this.mapQName(qname, complexTypeMap);
    }

    private String mapMessage(SOAPHeaderMessage msg, Map complexTypeMap) {
        javax.xml.namespace.QName qname = msg.getElement();
        if (qname == null) {
            throw new RuntimeException("No element reference in header");
        }
        return this.mapQName(qname, complexTypeMap);
    }

    private String mapQName(javax.xml.namespace.QName qname, Map complexTypeMap) throws RuntimeException {
        Object obj = complexTypeMap.get(qname);
        if (obj == null) {
            throw new RuntimeException("No mapping defined for element " + qname);
        }
        MappingElement mapping = (MappingElement)obj;
        String cname = mapping.getClassName();
        this.codeGenConfig.getTypeMapper().addTypeMappingName(qname, cname);
        return cname;
    }

    private static void collectTopLevelComponents(BindingElement binding, String dns, Map elementMap, Map complexTypeMap, Map simpleTypeMap, Map bindingMap) {
        String defaultns = CodeGenerationUtility.findDefaultNS(binding.topChildIterator(), dns);
        Iterator iter = binding.topChildIterator();
        while (iter.hasNext()) {
            ElementBase child = (ElementBase)iter.next();
            if (child.type() == 8) {
                IncludeElement include = (IncludeElement)child;
                CodeGenerationUtility.collectTopLevelComponents(include.getBinding(), defaultns, elementMap, complexTypeMap, simpleTypeMap, bindingMap);
                continue;
            }
            if (child.type() == 2) {
                FormatElement format = (FormatElement)child;
                CodeGenerationUtility.registerElement(format.getQName(), (ElementBase)format, simpleTypeMap);
                bindingMap.put(format, binding);
                continue;
            }
            if (child.type() != 3) continue;
            MappingElement mapping = (MappingElement)child;
            bindingMap.put(mapping, binding);
            if (mapping.isAbstract() && mapping.getTypeQName() != null) {
                CodeGenerationUtility.registerElement(mapping.getTypeQName(), (ElementBase)mapping, complexTypeMap);
                continue;
            }
            if (mapping.getName() == null) continue;
            String uri = mapping.getUri();
            if (uri == null) {
                uri = CodeGenerationUtility.findDefaultNS(mapping.topChildIterator(), defaultns);
            }
            elementMap.put(new javax.xml.namespace.QName(uri, mapping.getName()), mapping);
        }
    }

    private static void registerElement(QName qname, ElementBase element, Map map) {
        if (qname != null) {
            map.put(new javax.xml.namespace.QName(qname.getUri(), qname.getName()), element);
        }
    }

    private static String findDefaultNS(Iterator iter, String dns) {
        ElementBase child;
        while (iter.hasNext() && (child = (ElementBase)iter.next()).type() == 4) {
            NamespaceElement namespace = (NamespaceElement)child;
            String defaultName = namespace.getDefaultName();
            if (!"elements".equals(defaultName) && !"all".equals(defaultName)) continue;
            return namespace.getUri();
        }
        return dns;
    }

    static {
        s_primitiveSet.add("boolean");
        s_primitiveSet.add("byte");
        s_primitiveSet.add("char");
        s_primitiveSet.add("double");
        s_primitiveSet.add("float");
        s_primitiveSet.add("int");
        s_primitiveSet.add("long");
        s_primitiveSet.add("short");
        s_primitiveSet.add("void");
        s_wrapperMap = new HashMap();
        s_wrapperMap.put("boolean", "Boolean");
        s_wrapperMap.put("byte", "Byte");
        s_wrapperMap.put("char", "Character");
        s_wrapperMap.put("double", "Double");
        s_wrapperMap.put("float", "Float");
        s_wrapperMap.put("int", "Integer");
        s_wrapperMap.put("long", "Long");
        s_wrapperMap.put("short", "Short");
        s_reservedWords = new HashSet();
        s_reservedWords.add("abstract");
        s_reservedWords.add("assert");
        s_reservedWords.add("boolean");
        s_reservedWords.add("break");
        s_reservedWords.add("byte");
        s_reservedWords.add("case");
        s_reservedWords.add("catch");
        s_reservedWords.add("char");
        s_reservedWords.add("class");
        s_reservedWords.add("const");
        s_reservedWords.add("continue");
        s_reservedWords.add("default");
        s_reservedWords.add("do");
        s_reservedWords.add("double");
        s_reservedWords.add("else");
        s_reservedWords.add("enum");
        s_reservedWords.add("extends");
        s_reservedWords.add("final");
        s_reservedWords.add("finally");
        s_reservedWords.add("float");
        s_reservedWords.add("for");
        s_reservedWords.add("goto");
        s_reservedWords.add("if");
        s_reservedWords.add("implements");
        s_reservedWords.add("import");
        s_reservedWords.add("instanceof");
        s_reservedWords.add("int");
        s_reservedWords.add("interface");
        s_reservedWords.add("long");
        s_reservedWords.add("native");
        s_reservedWords.add("new");
        s_reservedWords.add("package");
        s_reservedWords.add("private");
        s_reservedWords.add("protected");
        s_reservedWords.add("public");
        s_reservedWords.add("return");
        s_reservedWords.add("short");
        s_reservedWords.add("static");
        s_reservedWords.add("strictfp");
        s_reservedWords.add("super");
        s_reservedWords.add("switch");
        s_reservedWords.add("synchronized");
        s_reservedWords.add("this");
        s_reservedWords.add("throw");
        s_reservedWords.add("throws");
        s_reservedWords.add("transient");
        s_reservedWords.add("try");
        s_reservedWords.add("void");
        s_reservedWords.add("volatile");
        s_reservedWords.add("while");
        s_reservedWords.add("true");
        s_reservedWords.add("false");
        s_reservedWords.add("null");
        s_reservedWords.add("true");
        s_reservedWords.add("uctx");
        s_reservedWords.add("child");
        s_reservedWords.add("wrapper");
    }

    private static class NamedParameterTypeMapper
    extends JavaTypeMapper {
        private NamedParameterTypeMapper() {
        }

        public String getParameterName(javax.xml.namespace.QName qname) {
            return qname.getLocalPart();
        }
    }

    private class IncludePrevalidationVisitor
    extends ModelVisitor {
        private final ValidationContext m_context;

        private IncludePrevalidationVisitor(ValidationContext vctx) {
            this.m_context = vctx;
        }

        public boolean visit(IncludeElement node) {
            try {
                this.m_context.getFormatDefinitions();
                node.prevalidate(this.m_context);
            }
            catch (Throwable t) {
                this.m_context.addFatal("Error during validation: " + t.getMessage());
                t.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

