/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.description.java2wsdl.Java2WSDLUtils;
import org.apache.ws.java2wsdl.Java2WSDLBuilder;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class Java2WSDLCodegenEngine
implements Java2WSDLConstants {
    private Java2WSDLBuilder java2WsdlBuilder;
    public static final String WSDL_FILENAME_SUFFIX = ".wsdl";
    public static final String COMMA = ",";

    public Java2WSDLCodegenEngine(Map optionsMap) throws Exception {
        String className;
        Java2WSDLCommandLineOption option = this.loadOption("cn", "className", optionsMap);
        String string = className = option == null ? null : option.getOptionValue();
        if (className == null || className.length() == 0) {
            throw new Exception("class name must be present!");
        }
        this.java2WsdlBuilder = new Java2WSDLBuilder(this.resolveOutputStream(className, optionsMap), className, this.resolveClassLoader(optionsMap));
        this.configureJava2WSDLBuilder(optionsMap, className);
    }

    public void generate() throws Exception {
        try {
            this.java2WsdlBuilder.generateWSDL();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private FileOutputStream resolveOutputStream(String className, Map optionsMap) throws Exception {
        FileOutputStream out;
        String outputFileName;
        Java2WSDLCommandLineOption option = this.loadOption("o", "output", optionsMap);
        String outputFolderName = option == null ? System.getProperty("user.dir") : option.getOptionValue();
        File outputFolder = new File(outputFolderName);
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        } else if (!outputFolder.isDirectory()) {
            throw new Exception("The specivied location " + outputFolderName + "is not a folder");
        }
        option = this.loadOption("of", "outputFilename", optionsMap);
        String string = outputFileName = option == null ? null : option.getOptionValue();
        if (outputFileName == null) {
            outputFileName = Java2WSDLUtils.getSimpleClassName(className) + WSDL_FILENAME_SUFFIX;
        }
        File outputFile = new File(outputFolder, outputFileName);
        try {
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            out = new FileOutputStream(outputFile);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return out;
    }

    private ClassLoader resolveClassLoader(Map optionsMap) throws Exception {
        ClassLoader classLoader;
        Java2WSDLCommandLineOption option = this.loadOption("cp", "classPath", optionsMap);
        if (option != null) {
            ArrayList optionValues = option.getOptionValues();
            URL[] urls = new URL[optionValues.size()];
            String[] classPathEntries = optionValues.toArray(new String[optionValues.size()]);
            try {
                for (int i = 0; i < classPathEntries.length; ++i) {
                    String classPathEntry = classPathEntries[i];
                    urls[i] = Java2WSDLUtils.isURL(classPathEntry) ? new URL(classPathEntry) : new File(classPathEntry).toURL();
                }
            }
            catch (MalformedURLException e) {
                throw new Exception(e);
            }
            classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private void configureJava2WSDLBuilder(Map optionsMap, String className) throws Exception {
        String optionValue;
        Java2WSDLCommandLineOption option = this.loadOption("stn", "schemaTargetnamespace", optionsMap);
        this.java2WsdlBuilder.setSchemaTargetNamespace(option == null ? null : option.getOptionValue());
        option = this.loadOption("stp", "schemaTargetnamespacePrefix", optionsMap);
        this.java2WsdlBuilder.setSchemaTargetNamespacePrefix(option == null ? null : option.getOptionValue());
        option = this.loadOption("tn", "targetNamespace", optionsMap);
        this.java2WsdlBuilder.setTargetNamespace(option == null ? null : option.getOptionValue());
        option = this.loadOption("tp", "targetNamespacePrefix", optionsMap);
        this.java2WsdlBuilder.setTargetNamespacePrefix(option == null ? null : option.getOptionValue());
        option = this.loadOption("sn", "serviceName", optionsMap);
        this.java2WsdlBuilder.setServiceName(option == null ? Java2WSDLUtils.getSimpleClassName(className) : option.getOptionValue());
        option = this.loadOption("st", "st", optionsMap);
        if (option != null) {
            this.java2WsdlBuilder.setStyle(option.getOptionValue());
        }
        if ((option = this.loadOption("l", "l", optionsMap)) != null) {
            this.java2WsdlBuilder.setLocationUri(option.getOptionValue());
        }
        if ((option = this.loadOption("u", "u", optionsMap)) != null) {
            this.java2WsdlBuilder.setUse(option.getOptionValue());
        }
        this.java2WsdlBuilder.setAttrFormDefault((option = this.loadOption("afd", "attributeFormDefault", optionsMap)) == null ? null : option.getOptionValue());
        option = this.loadOption("efd", "elementFormDefault", optionsMap);
        this.java2WsdlBuilder.setElementFormDefault(option == null ? null : option.getOptionValue());
        option = this.loadOption("xc", "extraClasses", optionsMap);
        this.java2WsdlBuilder.setExtraClasses(option == null ? new ArrayList() : option.getOptionValues());
        option = this.loadOption("nsg", "namespaceGenerator", optionsMap);
        if (option != null) {
            this.java2WsdlBuilder.setNsGenClassName(option.getOptionValue());
        }
        if ((option = this.loadOption("sg", "schemaGenerator", optionsMap)) != null) {
            this.java2WsdlBuilder.setSchemaGenClassName(option.getOptionValue());
        }
        option = this.loadOption("p2n", "package2Namespace", optionsMap);
        this.java2WsdlBuilder.setPkg2nsMap(this.loadJavaPkg2NamespaceMap(option));
        option = this.loadOption("wv", "wsdl-version", optionsMap);
        if (option != null && ("2.0".equals(optionValue = option.getOptionValue()) || "2".equals(optionValue))) {
            this.java2WsdlBuilder.setWSDLVersion("2.0");
        }
        if ((option = this.loadOption("dlb", "doclitbare", optionsMap)) != null) {
            this.java2WsdlBuilder.setGenerateDocLitBare(true);
        }
    }

    private Java2WSDLCommandLineOption loadOption(String shortOption, String longOption, Map options) {
        Java2WSDLCommandLineOption option = null;
        if (longOption != null && (option = (Java2WSDLCommandLineOption)options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = (Java2WSDLCommandLineOption)options.get(shortOption);
        }
        return option;
    }

    protected void addToSchemaLocationMap(String optionValue) throws Exception {
    }

    protected Map loadJavaPkg2NamespaceMap(Java2WSDLCommandLineOption option) {
        Hashtable<String, String> pkg2nsMap = new Hashtable<String, String>();
        if (option != null) {
            ArrayList optionValues = option.getOptionValues();
            for (int count = 0; count < optionValues.size(); ++count) {
                String anOptionValue = ((String)optionValues.get(count)).trim();
                pkg2nsMap.put(anOptionValue.substring(1, anOptionValue.indexOf(COMMA)).trim(), anOptionValue.substring(anOptionValue.indexOf(COMMA) + 1, anOptionValue.length() - 1).trim());
            }
        }
        return pkg2nsMap;
    }
}

