/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.wsdl.util.WSDLWrapperBasicImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperReloadImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperSaveImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSDLDefinitionWrapper
implements Definition {
    private static final Log log = LogFactory.getLog((Class)WSDLDefinitionWrapper.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String myClassName = "WSDLDefinitionWrapper";
    static final long serialVersionUID = -2788807375814097409L;
    private boolean reduceWSDLMemoryCache = false;
    private int reduceWSDLMemoryType = 0;
    private WSDLWrapperImpl wrapperImpl = null;

    public WSDLDefinitionWrapper(Definition def) {
        this.prepare(def, null);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL) {
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, boolean limitInMemory) {
        this.reduceWSDLMemoryCache = limitInMemory;
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, int limitType) {
        this.reduceWSDLMemoryCache = true;
        this.reduceWSDLMemoryType = limitType;
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, AxisConfiguration axisCfg) {
        String value;
        Parameter param = axisCfg.getParameter("reduceWSDLMemoryCache");
        this.reduceWSDLMemoryCache = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
        param = axisCfg.getParameter("reduceWSDLMemoryType");
        if (param != null && (value = (String)param.getValue()) != null) {
            Integer i = new Integer(value);
            this.reduceWSDLMemoryType = i;
        }
        this.prepare(def, wURL);
    }

    private void prepare(Definition def, URL wURL) {
        this.wrapperImpl = this.reduceWSDLMemoryCache ? (this.reduceWSDLMemoryType == 2 ? new WSDLWrapperReloadImpl(def, wURL) : new WSDLWrapperSaveImpl(def, wURL)) : new WSDLWrapperBasicImpl(def, wURL);
        this.wrapperImpl.releaseResources();
    }

    public Definition getUnwrappedDefinition() {
        return this.wrapperImpl.getUnwrappedDefinition();
    }

    public void setDocumentBaseURI(String d) {
        this.wrapperImpl.setDocumentBaseURI(d);
    }

    public String getDocumentBaseURI() {
        return this.wrapperImpl.getDocumentBaseURI();
    }

    public void setQName(QName n) {
        this.wrapperImpl.setQName(n);
    }

    public QName getQName() {
        return this.wrapperImpl.getQName();
    }

    public void setTargetNamespace(String t) {
        this.wrapperImpl.setTargetNamespace(t);
    }

    public String getTargetNamespace() {
        return this.wrapperImpl.getTargetNamespace();
    }

    public void addNamespace(String prefix, String namespaceURI) {
        this.wrapperImpl.addNamespace(prefix, namespaceURI);
    }

    public String removeNamespace(String prefix) {
        return this.wrapperImpl.removeNamespace(prefix);
    }

    public String getNamespace(String prefix) {
        return this.wrapperImpl.getNamespace(prefix);
    }

    public String getPrefix(String namespaceURI) {
        return this.wrapperImpl.getPrefix(namespaceURI);
    }

    public Map getNamespaces() {
        return this.wrapperImpl.getNamespaces();
    }

    public List getNativeAttributeNames() {
        return this.wrapperImpl.getNativeAttributeNames();
    }

    public void setTypes(Types types) {
        this.wrapperImpl.setTypes(types);
    }

    public Types getTypes() {
        return this.wrapperImpl.getTypes();
    }

    public void addImport(Import importDef) {
        this.wrapperImpl.addImport(importDef);
    }

    public Import removeImport(Import importDef) {
        return this.wrapperImpl.removeImport(importDef);
    }

    public List getImports(String namespaceURI) {
        return this.wrapperImpl.getImports(namespaceURI);
    }

    public Map getImports() {
        return this.wrapperImpl.getImports();
    }

    public void addMessage(Message message) {
        this.wrapperImpl.addMessage(message);
    }

    public Message getMessage(QName name) {
        return this.wrapperImpl.getMessage(name);
    }

    public Message removeMessage(QName name) {
        return this.wrapperImpl.removeMessage(name);
    }

    public Map getMessages() {
        return this.wrapperImpl.getMessages();
    }

    public void addBinding(Binding binding) {
        this.wrapperImpl.addBinding(binding);
    }

    public Binding getBinding(QName name) {
        return this.wrapperImpl.getBinding(name);
    }

    public Binding removeBinding(QName name) {
        return this.wrapperImpl.removeBinding(name);
    }

    public Map getBindings() {
        return this.wrapperImpl.getBindings();
    }

    public Map getAllBindings() {
        return this.wrapperImpl.getAllBindings();
    }

    public void addPortType(PortType portType) {
        this.wrapperImpl.addPortType(portType);
    }

    public PortType getPortType(QName name) {
        return this.wrapperImpl.getPortType(name);
    }

    public PortType removePortType(QName name) {
        return this.wrapperImpl.removePortType(name);
    }

    public Map getPortTypes() {
        return this.wrapperImpl.getPortTypes();
    }

    public Map getAllPortTypes() {
        return this.wrapperImpl.getAllPortTypes();
    }

    public void addService(Service service) {
        this.wrapperImpl.addService(service);
    }

    public Service getService(QName name) {
        return this.wrapperImpl.getService(name);
    }

    public Service removeService(QName name) {
        return this.wrapperImpl.removeService(name);
    }

    public Map getServices() {
        return this.wrapperImpl.getServices();
    }

    public Map getAllServices() {
        return this.wrapperImpl.getAllServices();
    }

    public void setDocumentationElement(Element docEl) {
        this.wrapperImpl.setDocumentationElement(docEl);
    }

    public Element getDocumentationElement() {
        return this.wrapperImpl.getDocumentationElement();
    }

    public void addExtensibilityElement(ExtensibilityElement extElement) {
        this.wrapperImpl.addExtensibilityElement(extElement);
    }

    public List getExtensibilityElements() {
        return this.wrapperImpl.getExtensibilityElements();
    }

    public Binding createBinding() {
        return this.wrapperImpl.createBinding();
    }

    public BindingFault createBindingFault() {
        return this.wrapperImpl.createBindingFault();
    }

    public BindingInput createBindingInput() {
        return this.wrapperImpl.createBindingInput();
    }

    public BindingOperation createBindingOperation() {
        return this.wrapperImpl.createBindingOperation();
    }

    public BindingOutput createBindingOutput() {
        return this.wrapperImpl.createBindingOutput();
    }

    public Fault createFault() {
        return this.wrapperImpl.createFault();
    }

    public Import createImport() {
        return this.wrapperImpl.createImport();
    }

    public Input createInput() {
        return this.wrapperImpl.createInput();
    }

    public Message createMessage() {
        return this.wrapperImpl.createMessage();
    }

    public Operation createOperation() {
        return this.wrapperImpl.createOperation();
    }

    public Output createOutput() {
        return this.wrapperImpl.createOutput();
    }

    public Part createPart() {
        return this.wrapperImpl.createPart();
    }

    public Port createPort() {
        return this.wrapperImpl.createPort();
    }

    public PortType createPortType() {
        return this.wrapperImpl.createPortType();
    }

    public Service createService() {
        return this.wrapperImpl.createService();
    }

    public Types createTypes() {
        return this.wrapperImpl.createTypes();
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        this.wrapperImpl.setExtensionRegistry(extReg);
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.wrapperImpl.getExtensionRegistry();
    }

    public String toString() {
        return this.wrapperImpl.toString();
    }

    public ExtensibilityElement removeExtensibilityElement(ExtensibilityElement extElement) {
        return this.wrapperImpl.removeExtensibilityElement(extElement);
    }

    public Object getExtensionAttribute(QName name) {
        return this.wrapperImpl.getExtensionAttribute(name);
    }

    public Map getExtensionAttributes() {
        return this.wrapperImpl.getExtensionAttributes();
    }

    public void setExtensionAttribute(QName name, Object value) {
        this.wrapperImpl.setExtensionAttribute(name, value);
    }
}

