/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.FileWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDL11Writer {
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    private File baseFolder = null;
    private int count;

    public WSDL11Writer(File baseFolder) {
        this.baseFolder = baseFolder;
        this.count = 0;
    }

    public void writeWSDL(AxisService axisService) {
        try {
            if (axisService != null) {
                File outputFile = FileWriter.createClassFile(this.baseFolder, null, axisService.getName(), ".wsdl");
                FileOutputStream fos = new FileOutputStream(outputFile);
                axisService.printWSDL(fos);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("WSDL writing failed!", e);
        }
    }

    public void writeWSDL(AxisService axisService, Definition definition, Map changedMap) {
        try {
            if (axisService != null) {
                HashMap<String, String> baseURIwsdlNameMap = new HashMap<String, String>();
                baseURIwsdlNameMap.put(definition.getDocumentBaseURI(), axisService.getName() + ".wsdl");
                this.writeWSDL(definition, axisService.getName() + ".wsdl", changedMap, baseURIwsdlNameMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("WSDL writing failed!", e);
        }
    }

    private void writeWSDL(Definition definition, String fileName, Map changedMap, Map baseURIwsdlNameMap) throws Exception {
        Map imports = definition.getImports();
        if (imports != null && imports.size() > 0) {
            Vector importsVector = null;
            Import wsdlImport = null;
            String wsdlName = null;
            String wsdlLocation = null;
            Iterator improtsVectorIter = imports.values().iterator();
            while (improtsVectorIter.hasNext()) {
                importsVector = (Vector)improtsVectorIter.next();
                Iterator importsIter = importsVector.iterator();
                while (importsIter.hasNext()) {
                    wsdlImport = (Import)importsIter.next();
                    wsdlLocation = wsdlImport.getDefinition().getDocumentBaseURI();
                    if (!baseURIwsdlNameMap.containsKey(wsdlLocation)) {
                        wsdlName = wsdlLocation.substring(wsdlLocation.lastIndexOf(47) + 1);
                        if (!wsdlName.endsWith(".wsdl") && !wsdlName.endsWith(".xsd")) {
                            wsdlName = wsdlName.indexOf("xsd") > -1 ? "xsd" + this.count++ + ".xsd" : "wsdl" + this.count++ + ".wsdl";
                        }
                        while (baseURIwsdlNameMap.containsValue(wsdlName)) {
                            String fileNamePart = wsdlName.substring(0, wsdlName.lastIndexOf("."));
                            String extension = wsdlName.substring(wsdlName.lastIndexOf("."));
                            wsdlName = fileNamePart + this.count++ + extension;
                        }
                        baseURIwsdlNameMap.put(wsdlLocation, wsdlName);
                        Definition innerDefinition = wsdlImport.getDefinition();
                        this.writeWSDL(innerDefinition, wsdlName, changedMap, baseURIwsdlNameMap);
                    }
                    wsdlImport.setLocationURI((String)baseURIwsdlNameMap.get(wsdlLocation));
                }
            }
        }
        this.adjustWSDLSchemaLocations(definition, changedMap);
        WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
        File outputFile = FileWriter.createClassFile(this.baseFolder, null, fileName, null);
        FileOutputStream out = new FileOutputStream(outputFile);
        if (definition.getServices().size() > 1) {
            Service service;
            ArrayList<Service> removedServices = new ArrayList<Service>();
            ArrayList servicesList = new ArrayList();
            Map services = definition.getServices();
            Iterator iter = services.values().iterator();
            while (iter.hasNext()) {
                servicesList.add(iter.next());
            }
            String serviceNameFromFileName = fileName;
            if (fileName.indexOf(".wsdl") > -1) {
                serviceNameFromFileName = fileName.substring(0, fileName.lastIndexOf(".wsdl"));
            }
            if (fileName.indexOf(".xsd") > -1) {
                serviceNameFromFileName = fileName.substring(0, fileName.lastIndexOf(".xsd"));
            }
            Iterator iter2 = servicesList.iterator();
            while (iter2.hasNext()) {
                service = (Service)iter2.next();
                if (service.getQName().getLocalPart().equals(serviceNameFromFileName)) continue;
                definition.removeService(service.getQName());
                removedServices.add(service);
            }
            wsdlWriter.writeWSDL(definition, (OutputStream)out);
            iter2 = removedServices.iterator();
            while (iter2.hasNext()) {
                service = (Service)iter2.next();
                definition.addService(service);
            }
        } else {
            wsdlWriter.writeWSDL(definition, (OutputStream)out);
        }
        out.flush();
        out.close();
    }

    public void adjustWSDLSchemaLocatins(Definition definition, Map changedSchemaLocations) {
        this.adjustWSDLSchemaLocations(definition, changedSchemaLocations);
    }

    public void adjustWSDLSchemaLocations(Definition definition, Map changedSchemaLocations) {
        Types wsdlTypes = definition.getTypes();
        if (wsdlTypes != null) {
            List extensibilityElements = wsdlTypes.getExtensibilityElements();
            Iterator iter = extensibilityElements.iterator();
            while (iter.hasNext()) {
                Object currentObject = iter.next();
                if (!(currentObject instanceof Schema)) continue;
                Schema schema = (Schema)currentObject;
                this.changeLocations(schema.getElement(), changedSchemaLocations);
            }
        }
    }

    private void changeLocations(Element element, Map changedScheamLocations) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            this.processImport(nodeList.item(i), changedScheamLocations);
        }
    }

    private void processImport(Node importNode, Map changedScheamLocations) {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String attributeValue;
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals(SCHEMA_LOCATION) || changedScheamLocations.get(attributeValue = attribute.getNodeValue()) == null) continue;
            attribute.setNodeValue((String)changedScheamLocations.get(attributeValue));
        }
    }
}

