/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static final Log log = LogFactory.getLog((Class)Utils.class);

    public static void addHandler(Flow flow, Handler handler, String phaseName) {
        HandlerDescription handlerDesc = new HandlerDescription(handler.getName());
        PhaseRule rule = new PhaseRule(phaseName);
        handlerDesc.setRules(rule);
        handler.init(handlerDesc);
        handlerDesc.setHandler(handler);
        flow.addHandler(handlerDesc);
    }

    public static MessageContext createOutMessageContext(MessageContext inMessageContext) throws AxisFault {
        return MessageContextBuilder.createOutMessageContext(inMessageContext);
    }

    public static AxisService createSimpleService(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleService(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleServiceforClient(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleInOnlyService(QName serviceName, MessageReceiver messageReceiver, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        InOnlyAxisOperation axisOp = new InOnlyAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/" + opName.getLocalPart(), axisOp);
        return service;
    }

    public static AxisService createSimpleService(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new Parameter("ServiceClass", className));
        InOutAxisOperation axisOp = new InOutAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/" + opName.getLocalPart(), axisOp);
        return service;
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new Parameter("ServiceClass", className));
        OutInAxisOperation axisOp = new OutInAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        return service;
    }

    public static ServiceContext fillContextInformation(AxisService axisService, ConfigurationContext configurationContext) throws AxisFault {
        return Utils.fillServiceContextAndServiceGroupContext(axisService, configurationContext);
    }

    private static ServiceContext fillServiceContextAndServiceGroupContext(AxisService axisService, ConfigurationContext configurationContext) throws AxisFault {
        String serviceGroupContextId = UUIDGenerator.getUUID();
        ServiceGroupContext serviceGroupContext = configurationContext.createServiceGroupContext(axisService.getAxisServiceGroup());
        serviceGroupContext.setId(serviceGroupContextId);
        configurationContext.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
        return serviceGroupContext.getServiceContext(axisService);
    }

    public static String[] parseRequestURLForServiceAndOperation(String path, String servicePath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseRequestURLForServiceAndOperation : [" + path + "][" + servicePath + "]"));
        }
        if (path == null) {
            return null;
        }
        String[] values = new String[2];
        int index = path.lastIndexOf(servicePath);
        if (-1 != index) {
            int serviceStart = index + servicePath.length();
            if (path.length() > serviceStart + 1) {
                int operationIndex;
                String service = path.substring(serviceStart + 1);
                int queryIndex = service.indexOf(63);
                if (queryIndex > 0) {
                    service = service.substring(0, queryIndex);
                }
                if ((operationIndex = service.indexOf(47)) > 0) {
                    values[0] = service.substring(0, operationIndex);
                    values[1] = service.substring(operationIndex + 1);
                    operationIndex = values[1].lastIndexOf(47);
                    if (operationIndex > 0) {
                        values[1] = values[1].substring(operationIndex + 1);
                    }
                } else {
                    values[0] = service;
                }
            }
        } else {
            log.info((Object)("Unable to parse request URL [" + path + "][" + servicePath + "]"));
        }
        return values;
    }

    public static ConfigurationContext getNewConfigurationContext(String repositry) throws Exception {
        File file = new File(repositry);
        if (!file.exists()) {
            throw new Exception("repository directory " + file.getAbsolutePath() + " does not exists");
        }
        File axis2xml = new File(file, "axis.xml");
        String axis2xmlString = null;
        if (axis2xml.exists()) {
            axis2xmlString = axis2xml.getName();
        }
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem(file.getAbsolutePath(), axis2xmlString);
    }

    public static String getParameterValue(Parameter param) {
        if (param == null) {
            return null;
        }
        return (String)param.getValue();
    }

    public static String getModuleName(String moduleName) {
        if (moduleName.endsWith("-SNAPSHOT")) {
            return moduleName.substring(0, moduleName.indexOf("-SNAPSHOT"));
        }
        int delimiter = 45;
        int version_index = moduleName.lastIndexOf(delimiter);
        if (version_index > 0) {
            String versionString = Utils.getModuleVersion(moduleName);
            if (versionString == null) {
                return moduleName;
            }
            return moduleName.substring(0, version_index);
        }
        return moduleName;
    }

    public static String getModuleVersion(String moduleName) {
        if (moduleName.endsWith("-SNAPSHOT")) {
            return "SNAPSHOT";
        }
        int version_seperator = 45;
        int version_index = moduleName.lastIndexOf(version_seperator);
        if (version_index > 0) {
            String versionString = moduleName.substring(version_index + 1, moduleName.length());
            try {
                Float.parseFloat(versionString);
                return versionString;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static String getModuleName(String moduleName, String moduleVersion) {
        if (moduleVersion != null && moduleVersion.length() != 0) {
            moduleName = moduleName + "-" + moduleVersion;
        }
        return moduleName;
    }

    public static boolean checkVersion(String module1version, String module2version) throws AxisFault {
        if (module1version != null && !module1version.equals(module2version) || module2version != null && !module2version.equals(module1version)) {
            throw new AxisFault("trying to engage two different module versions " + module1version + " : " + module2version);
        }
        return true;
    }

    public static void calculateDefaultModuleVersion(HashMap modules, AxisConfiguration axisConfig) {
        String moduleName;
        Iterator allModules = modules.values().iterator();
        HashMap<String, String> defaultModules = new HashMap<String, String>();
        while (allModules.hasNext()) {
            String moduleVersionString;
            String moduleNameString;
            AxisModule axisModule = (AxisModule)allModules.next();
            moduleName = axisModule.getName();
            if ("SNAPSHOT".equals(axisModule.getVersion())) {
                moduleNameString = axisModule.getName();
                moduleVersionString = axisModule.getVersion();
            } else if (axisModule.getVersion() == null) {
                moduleNameString = Utils.getModuleName(moduleName);
                moduleVersionString = Utils.getModuleVersion(moduleName);
                if (moduleVersionString != null) {
                    try {
                        Float.valueOf(moduleVersionString);
                        axisModule.setVersion(moduleVersionString);
                        axisModule.setName(moduleName);
                    }
                    catch (NumberFormatException e) {
                        moduleVersionString = null;
                    }
                }
            } else {
                moduleNameString = axisModule.getName();
                moduleVersionString = axisModule.getVersion();
            }
            String currentDefaultVerison = (String)defaultModules.get(moduleNameString);
            if (currentDefaultVerison != null) {
                if ("SNAPSHOT".equals(currentDefaultVerison) || moduleVersionString == null || !Utils.isLatest(moduleVersionString, currentDefaultVerison)) continue;
                defaultModules.put(moduleNameString, moduleVersionString);
                continue;
            }
            defaultModules.put(moduleNameString, moduleVersionString);
        }
        Iterator def_mod_itr = defaultModules.keySet().iterator();
        while (def_mod_itr.hasNext()) {
            moduleName = (String)def_mod_itr.next();
            axisConfig.addDefaultModuleVersion(moduleName, (String)defaultModules.get(moduleName));
        }
    }

    public static boolean isLatest(String moduleVersion, String currentDefaultVersion) {
        float m_c_vresion;
        if ("SNAPSHOT".equals(moduleVersion)) {
            return true;
        }
        float m_version = Float.parseFloat(moduleVersion);
        return m_version > (m_c_vresion = Float.parseFloat(currentDefaultVersion));
    }

    public static boolean isExplicitlyTrue(MessageContext messageContext, String propertyName) {
        Object flag = messageContext.getProperty(propertyName);
        return JavaUtils.isTrueExplicitly(flag);
    }

    public static int getAxisSpecifMEPConstant(String messageExchangePattern) {
        int mepConstant = -1;
        if ("http://www.w3.org/ns/wsdl/in-out".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-out".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/in-out".equals(messageExchangePattern)) {
            mepConstant = 12;
        } else if ("http://www.w3.org/ns/wsdl/in-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/in-only".equals(messageExchangePattern)) {
            mepConstant = 10;
        } else if ("http://www.w3.org/ns/wsdl/in-opt-out".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(messageExchangePattern)) {
            mepConstant = 13;
        } else if ("http://www.w3.org/ns/wsdl/out-in".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-in".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/out-in".equals(messageExchangePattern)) {
            mepConstant = 16;
        } else if ("http://www.w3.org/ns/wsdl/out-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/out-only".equals(messageExchangePattern)) {
            mepConstant = 14;
        } else if ("http://www.w3.org/ns/wsdl/out-opt-in".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(messageExchangePattern)) {
            mepConstant = 17;
        } else if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(messageExchangePattern)) {
            mepConstant = 11;
        } else if ("http://www.w3.org/ns/wsdl/robust-out-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(messageExchangePattern)) {
            mepConstant = 15;
        }
        if (mepConstant == -1) {
            throw new AxisError(Messages.getMessage("mepmappingerror"));
        }
        return mepConstant;
    }

    public static AxisFault getInboundFaultFromMessageContext(MessageContext messageContext) {
        AxisFault result = (AxisFault)messageContext.getProperty("inboundFaultOverride");
        if (result == null) {
            SOAPBody soapBody;
            SOAPEnvelope envelope = messageContext.getEnvelope();
            if (envelope != null && (soapBody = envelope.getBody()) != null) {
                SOAPFault soapFault = soapBody.getFault();
                if (soapFault != null) {
                    return new AxisFault(soapFault, messageContext);
                }
                if (messageContext.isDoingREST() && soapBody.getFirstElement() != null) {
                    return new AxisFault(soapBody.getFirstElement().toString());
                }
            }
            throw new IllegalArgumentException("The MessageContext does not have an associated SOAPFault.");
        }
        return result;
    }
}

