/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.local.LocalResponder;
import org.apache.axis2.transport.local.LocalTransportSender;
import org.apache.axis2.util.MessageContextBuilder;

public class LocalTransportReceiver {
    public static ConfigurationContext CONFIG_CONTEXT;
    private ConfigurationContext confContext;
    private LocalTransportSender sender;

    public LocalTransportReceiver(ConfigurationContext configContext) {
        this.confContext = configContext;
    }

    public LocalTransportReceiver(LocalTransportSender sender) {
        this(CONFIG_CONTEXT);
        this.sender = sender;
    }

    public void processMessage(InputStream in, EndpointReference to, String action) throws AxisFault {
        MessageContext msgCtx = this.confContext.createMessageContext();
        TransportInDescription tIn = this.confContext.getAxisConfiguration().getTransportIn("local");
        TransportOutDescription tOut = this.confContext.getAxisConfiguration().getTransportOut("local");
        try {
            StAXBuilder builder;
            tOut.setSender(new LocalResponder(this.sender));
            msgCtx.setTransportIn(tIn);
            msgCtx.setTransportOut(tOut);
            msgCtx.setProperty("TRANSPORT_OUT", this.sender.getResponse());
            msgCtx.setTo(to);
            msgCtx.setWSAAction(action);
            msgCtx.setServerSide(true);
            InputStreamReader streamReader = new InputStreamReader(in);
            try {
                builder = BuilderUtil.getBuilder(streamReader);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            msgCtx.setEnvelope(envelope);
            AxisEngine.receive(msgCtx);
        }
        catch (AxisFault e) {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgCtx, e);
            faultContext.setTransportOut(tOut);
            faultContext.setProperty("TRANSPORT_OUT", this.sender.getResponse());
            AxisEngine.sendFault(faultContext);
        }
    }
}

